/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.materializer;

import java.util.List;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.helpers.IJobInfo;
import org.eclipse.buckminster.core.materializer.IMaterializer;
import org.eclipse.buckminster.core.materializer.MaterializationContext;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class MaterializerJob
extends Job
implements IJobInfo {
    private final IMaterializer materializer;
    private final MaterializationContext context;
    private final List<Resolution> resolutions;

    public MaterializerJob(String id, IMaterializer materializer, List<Resolution> resolutions, MaterializationContext context) {
        super(String.valueOf(id) + " materializer");
        if (resolutions.size() < 1) {
            throw new IllegalArgumentException();
        }
        this.materializer = materializer;
        this.context = context;
        this.resolutions = resolutions;
        this.setSystem(false);
        this.setUser(false);
        this.setPriority(30);
    }

    public boolean belongsTo(Object family) {
        return this.context == family;
    }

    @Override
    public String getOperationName() {
        Resolution lastResolution = this.resolutions.get(this.resolutions.size() - 1);
        return NLS.bind((String)Messages.Materialization_of_0, (Object)lastResolution.getComponentIdentifier().toString());
    }

    protected IStatus run(IProgressMonitor monitor) {
        block2: {
            try {
                this.materializer.materialize(this.resolutions, this.context, monitor);
            }
            catch (CoreException e) {
                this.context.addRequestStatus(this.resolutions.get(this.resolutions.size() - 1).getRequest(), BuckminsterException.wrap((Throwable)e).getStatus());
                if (this.context.isContinueOnError()) break block2;
                return e.getStatus();
            }
        }
        return Status.OK_STATUS;
    }
}

