/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.metadata.model;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.cspec.QualifiedDependency;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.metadata.StorageManager;
import org.eclipse.buckminster.core.metadata.model.IUUIDPersisted;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.mspec.model.MaterializationSpec;
import org.eclipse.buckminster.core.query.model.ComponentQuery;
import org.eclipse.buckminster.sax.UUIDKeyed;
import org.eclipse.core.runtime.CoreException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class BOMNode
extends UUIDKeyed
implements IUUIDPersisted {
    public static final int SEQUENCE_NUMBER = 3;
    public static final String TAG = "depnode";

    public void addUnresolved(List<ComponentRequest> unresolved, Set<Resolution> skipThese) {
    }

    public List<Resolution> findAll(Set<Resolution> skipThese) throws CoreException {
        return Collections.emptyList();
    }

    public List<BOMNode> getChildren() {
        return Collections.emptyList();
    }

    public abstract QualifiedDependency getQualifiedDependency();

    public ComponentQuery getQuery() throws CoreException {
        return null;
    }

    public UUID getQueryId() {
        return null;
    }

    public abstract ComponentRequest getRequest();

    public Resolution getResolution() {
        return null;
    }

    public UUID getResolutionId() throws CoreException {
        return null;
    }

    public abstract String getViewName() throws CoreException;

    public boolean isChild(BOMNode node) throws CoreException {
        return false;
    }

    public boolean isFullyResolved(ComponentQuery query, Map<String, ? extends Object> properties) throws CoreException {
        return this.isFullyResolved(query, new HashSet<BOMNode>(), properties);
    }

    @Override
    public boolean isPersisted(StorageManager sm) throws CoreException {
        return false;
    }

    public boolean isReferencing(BOMNode node, boolean shallow) throws CoreException {
        return this.equals(node);
    }

    @Override
    public void remove(StorageManager sm) throws CoreException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void store(StorageManager sm) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public final void toSax(ContentHandler receiver) throws SAXException {
        receiver.startDocument();
        this.toSax(receiver, "http://www.eclipse.org/buckminster/MetaData-1.0", "md", this.getDefaultTag());
        receiver.endDocument();
    }

    public int uniqueNodeCount() throws CoreException {
        HashSet<BOMNode> allNodes = new HashSet<BOMNode>();
        this.collectNodes(allNodes);
        return allNodes.size();
    }

    protected boolean isFullyResolved(ComponentQuery query, HashSet<BOMNode> seen, Map<String, ? extends Object> properties) throws CoreException {
        ComponentRequest request = this.getRequest();
        return query.skipComponent(request, properties) || request.isOptional();
    }

    abstract void addMaterializationCandidates(RMContext var1, List<Resolution> var2, ComponentQuery var3, MaterializationSpec var4, Set<Resolution> var5) throws CoreException;

    void collectAll(Set<Resolution> notThese, List<Resolution> all) throws CoreException {
    }

    BOMNode replaceNode(BOMNode node, Map<BOMNode, BOMNode> visited) throws CoreException {
        BOMNode self = visited.get(this);
        if (self == null) {
            self = node.getQualifiedDependency().equals(this.getQualifiedDependency()) ? node : this;
            visited.put(this, self);
        }
        return self;
    }

    private void collectNodes(Set<BOMNode> nodes) throws CoreException {
        if (nodes.add(this)) {
            for (BOMNode child : this.getChildren()) {
                child.collectNodes(nodes);
            }
        }
    }
}

