/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.metadata.model;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.cspec.IComponentIdentifier;
import org.eclipse.buckminster.core.cspec.IGenerator;
import org.eclipse.buckminster.core.cspec.QualifiedDependency;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.metadata.model.BOMNode;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.mspec.model.MaterializationSpec;
import org.eclipse.buckminster.core.query.model.ComponentQuery;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.xml.sax.helpers.AttributesImpl;

public class GeneratorNode
extends BOMNode {
    public static final String ATTR_ATTRIBUTE = "attribute";
    public static final String ATTR_COMPONENT = "component";
    public static final String ATTR_GENERATES = "generates";
    public static final String ATTR_GENERATES_TYPE = "generatesType";
    public static final String ATTR_GENERATES_VERSION = "generatesVersion";
    public static final String ATTR_DECLARING_CSPEC_ID = "declaringCSpecId";
    public static final String TAG = "generatorNode";
    private final String attribute;
    private final String component;
    private final IComponentIdentifier generates;
    private final CSpec declaringCSpec;

    public GeneratorNode(CSpec declaringCSpec, IGenerator generator) {
        this.declaringCSpec = declaringCSpec;
        this.component = generator.getComponent();
        this.attribute = generator.getAttribute();
        this.generates = generator.getGeneratedIdentifier();
    }

    public GeneratorNode(CSpec declaringCSpec, String component, String attribute, IComponentIdentifier generates) {
        this.declaringCSpec = declaringCSpec;
        this.component = component;
        this.attribute = attribute;
        this.generates = generates;
    }

    public GeneratorNode(CSpec declaringCSpec, String component, String attribute, String generates) {
        this(declaringCSpec, component, attribute, new ComponentIdentifier(generates, null, null));
    }

    public String getAttribute() {
        return this.attribute;
    }

    public String getComponent() {
        return this.component;
    }

    public CSpec getDeclaringCSpec() {
        return this.declaringCSpec;
    }

    public String getDefaultTag() {
        return TAG;
    }

    public IComponentIdentifier getGeneratesId() {
        return this.generates;
    }

    @Override
    public QualifiedDependency getQualifiedDependency() {
        return new QualifiedDependency(this.getRequest(), null);
    }

    @Override
    public ComponentRequest getRequest() {
        VersionRange range = null;
        if (this.generates.getVersion() != null) {
            range = new VersionRange(this.generates.getVersion(), true, this.generates.getVersion(), true);
        }
        return new ComponentRequest(this.generates.getName(), this.generates.getComponentTypeID(), range);
    }

    @Override
    public String getViewName() throws CoreException {
        return String.valueOf(this.getRequest().getViewName()) + ":generated";
    }

    @Override
    public boolean isFullyResolved(ComponentQuery query, Map<String, ? extends Object> properties) throws CoreException {
        return true;
    }

    protected void addAttributes(AttributesImpl attrs) {
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_DECLARING_CSPEC_ID, (String)this.declaringCSpec.getId().toString());
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_ATTRIBUTE, (String)this.attribute);
        if (this.component != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_COMPONENT, (String)this.component);
        }
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_GENERATES, (String)this.generates.getName());
        if (this.generates.getComponentTypeID() != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_GENERATES_TYPE, (String)this.generates.getComponentTypeID());
        }
        if (this.generates.getVersion() != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_GENERATES_VERSION, (String)this.generates.getVersion().toString());
        }
    }

    @Override
    void addMaterializationCandidates(RMContext context, List<Resolution> resolutions, ComponentQuery query, MaterializationSpec mspec, Set<Resolution> perused) throws CoreException {
    }
}

