/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.query.model;

import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.buckminster.core.common.model.Documentation;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.common.model.SAXEmitter;
import org.eclipse.buckminster.core.helpers.DateAndTimeUtils;
import org.eclipse.buckminster.core.helpers.TextUtils;
import org.eclipse.buckminster.core.query.IAdvisorNode;
import org.eclipse.buckminster.core.query.builder.AdvisorNodeBuilder;
import org.eclipse.buckminster.core.query.model.MutableLevel;
import org.eclipse.buckminster.core.query.model.SourceLevel;
import org.eclipse.buckminster.core.version.VersionSelector;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.sax.AbstractSaxableElement;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class AdvisorNode
extends AbstractSaxableElement
implements Cloneable,
IAdvisorNode {
    public static final String ATTR_ATTRIBUTES = "attributes";
    public static final String ATTR_COMPONENT_TYPE = "componentType";
    public static final String ATTR_FILTER = "filter";
    public static final String ATTR_MUTABLE_LEVEL = "mutableLevel";
    public static final String ATTR_NAME_PATTERN = "namePattern";
    public static final String ATTR_OVERLAY_FOLDER = "overlayFolder";
    public static final String ATTR_PRUNE = "prune";
    public static final String ATTR_SKIP_COMPONENT = "skipComponent";
    public static final String ATTR_SOURCE_LEVEL = "sourceLevel";
    public static final String ATTR_USE_TARGET_PLATFORM = "useTargetPlatform";
    public static final String ATTR_USE_MATERIALIZATION = "useMaterialization";
    public static final String ATTR_USE_WORKSPACE = "useWorkspace";
    public static final String ATTR_VERSION_OVERRIDE = "versionOverride";
    public static final String ATTR_VERSION_OVERRIDE_TYPE = "versionOverrideType";
    public static final String ATTR_ALLOW_CIRCULAR_DEPENDENCY = "allowCircularDependency";
    public static final String ATTR_WHEN_NOT_EMPTY = "whenNotEmpty";
    public static final String ATTR_USE_REMOTE_RESOLUTION = "useRemoteResolution";
    public static final String ATTR_SYSTEM_DISCOVERY = "systemDiscovery";
    public static final String ATTR_BRANCH_TAG_PATH = "branchTagPath";
    public static final String ATTR_REVISION = "revision";
    public static final String ATTR_TIMESTAMP = "timestamp";
    public static final String ATTR_RESOLUTION_PRIO = "resolutionPrio";
    public static final String TAG = "advisorNode";
    private final boolean allowCircularDependency;
    private final Documentation documentation;
    private final List<String> attributes;
    private final String componentTypeID;
    private final Filter filter;
    private final MutableLevel mutableLevel;
    private final Pattern namePattern;
    private final URL overlayFolder;
    private final Map<String, String> properties;
    private final boolean prune;
    private final boolean skipComponent;
    private final SourceLevel sourceLevel;
    private final boolean useTargetPlatform;
    private final boolean useMaterialization;
    private final boolean useWorkspace;
    private final VersionRange versionOverride;
    private final boolean useRemoteResolution;
    private final boolean systemDiscovery;
    private final VersionSelector[] branchTagPath;
    private final String revision;
    private final Date timestamp;
    private final int[] resolutionPrio;

    public AdvisorNode(AdvisorNodeBuilder bld) {
        this.documentation = bld.getDocumentation();
        this.allowCircularDependency = bld.allowCircularDependency();
        this.namePattern = bld.getNamePattern();
        this.filter = bld.getFilter();
        this.componentTypeID = bld.getComponentTypeID();
        this.overlayFolder = bld.getOverlayFolder();
        this.prune = bld.isPrune();
        this.mutableLevel = bld.getMutableLevel();
        this.sourceLevel = bld.getSourceLevel();
        this.skipComponent = bld.skipComponent();
        this.useMaterialization = bld.isUseMaterialization();
        this.useTargetPlatform = bld.isUseTargetPlatform();
        this.useWorkspace = bld.isUseWorkspace();
        this.versionOverride = bld.getVersionOverride();
        this.useRemoteResolution = bld.isUseRemoteResolution();
        this.systemDiscovery = bld.isSystemDiscovery();
        this.branchTagPath = bld.getBranchTagPath();
        this.revision = bld.getRevision();
        this.timestamp = bld.getTimestamp();
        this.resolutionPrio = bld.getResolutionPrio();
        this.attributes = Utils.createUnmodifiableList(bld.getAttributes());
        this.properties = ExpandingProperties.createUnmodifiableProperties(bld.getProperties());
    }

    @Override
    public boolean allowCircularDependency() {
        return this.allowCircularDependency;
    }

    @Override
    public final List<String> getAttributes() {
        return this.attributes;
    }

    @Override
    public final VersionSelector[] getBranchTagPath() {
        return this.branchTagPath;
    }

    @Override
    public final String getComponentTypeID() {
        return this.componentTypeID;
    }

    public String getDefaultTag() {
        return TAG;
    }

    @Override
    public Documentation getDocumentation() {
        return this.documentation;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public final MutableLevel getMutableLevel() {
        return this.mutableLevel;
    }

    @Override
    public final Pattern getNamePattern() {
        return this.namePattern;
    }

    @Override
    public URL getOverlayFolder() {
        return this.overlayFolder;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public int[] getResolutionPrio() {
        return this.resolutionPrio;
    }

    @Override
    public String getRevision() {
        return this.revision;
    }

    @Override
    public final SourceLevel getSourceLevel() {
        return this.sourceLevel;
    }

    @Override
    public Date getTimestamp() {
        return this.timestamp;
    }

    @Override
    public final VersionRange getVersionOverride() {
        return this.versionOverride;
    }

    @Override
    public final boolean isPrune() {
        return this.prune;
    }

    @Override
    public final boolean isSystemDiscovery() {
        return this.systemDiscovery;
    }

    @Override
    public final boolean isUseMaterialization() {
        return this.useMaterialization;
    }

    @Override
    public final boolean isUseRemoteResolution() {
        return this.useRemoteResolution;
    }

    @Override
    public final boolean isUseTargetPlatform() {
        return this.useTargetPlatform;
    }

    @Override
    public final boolean isUseWorkspace() {
        return this.useWorkspace;
    }

    @Override
    public final boolean skipComponent() {
        return this.skipComponent;
    }

    protected void addAttributes(AttributesImpl attrs) throws SAXException {
        String tmp;
        if (this.namePattern != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_NAME_PATTERN, (String)this.namePattern.toString());
        }
        if (this.filter != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_FILTER, (String)this.filter.toString());
        }
        if (this.overlayFolder != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_OVERLAY_FOLDER, (String)this.overlayFolder.toString());
        }
        if (this.componentTypeID != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_COMPONENT_TYPE, (String)this.componentTypeID);
        }
        if (this.mutableLevel != MutableLevel.INDIFFERENT) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_MUTABLE_LEVEL, (String)this.mutableLevel.name());
        }
        if (this.sourceLevel != SourceLevel.INDIFFERENT) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_SOURCE_LEVEL, (String)this.sourceLevel.name());
        }
        if (this.skipComponent) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_SKIP_COMPONENT, (String)"true");
        }
        if (this.allowCircularDependency) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_ALLOW_CIRCULAR_DEPENDENCY, (String)"true");
        }
        if (!this.systemDiscovery) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_SYSTEM_DISCOVERY, (String)"false");
        }
        if (!this.useMaterialization) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_USE_MATERIALIZATION, (String)"false");
        }
        if (!this.useRemoteResolution) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_USE_REMOTE_RESOLUTION, (String)"false");
        }
        if (!this.useTargetPlatform) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_USE_TARGET_PLATFORM, (String)"false");
        }
        if (!this.useWorkspace) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_USE_WORKSPACE, (String)"false");
        }
        if (this.versionOverride != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_VERSION_OVERRIDE, (String)this.versionOverride.toString());
        }
        if ((tmp = TextUtils.concat(this.attributes, ",")) != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_ATTRIBUTES, (String)tmp);
        }
        if (this.prune) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_PRUNE, (String)"true");
        }
        if ((tmp = VersionSelector.toString(this.branchTagPath)) != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_BRANCH_TAG_PATH, (String)tmp);
        }
        if (!Arrays.equals(this.resolutionPrio, DEFAULT_RESOLUTION_PRIO)) {
            StringBuilder bld = new StringBuilder();
            bld.append(this.resolutionPrio[0]);
            int idx = 1;
            while (idx < this.resolutionPrio.length) {
                bld.append(',');
                bld.append(this.resolutionPrio[idx]);
                ++idx;
            }
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_RESOLUTION_PRIO, (String)bld.toString());
        }
        if (this.revision != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_REVISION, (String)this.revision);
        }
        if (this.timestamp != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_TIMESTAMP, (String)DateAndTimeUtils.toISOFormat(this.timestamp));
        }
    }

    protected void emitElements(ContentHandler handler, String namespace, String prefix) throws SAXException {
        if (this.documentation != null) {
            this.documentation.toSax(handler, namespace, prefix, this.documentation.getDefaultTag());
        }
        SAXEmitter.emitProperties(handler, this.properties, namespace, prefix, true, false);
    }
}

