/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.query.model;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.common.model.Documentation;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.common.model.SAXEmitter;
import org.eclipse.buckminster.core.cspec.model.ComponentName;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.helpers.BMProperties;
import org.eclipse.buckminster.core.metadata.StorageManager;
import org.eclipse.buckminster.core.metadata.model.IUUIDPersisted;
import org.eclipse.buckminster.core.parser.IParser;
import org.eclipse.buckminster.core.parser.IParserFactory;
import org.eclipse.buckminster.core.query.IAdvisorNode;
import org.eclipse.buckminster.core.query.IComponentQuery;
import org.eclipse.buckminster.core.query.builder.AdvisorNodeBuilder;
import org.eclipse.buckminster.core.query.builder.ComponentQueryBuilder;
import org.eclipse.buckminster.core.query.model.AdvisorNode;
import org.eclipse.buckminster.core.rmap.model.ProviderScore;
import org.eclipse.buckminster.core.version.VersionSelector;
import org.eclipse.buckminster.download.DownloadManager;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.buckminster.runtime.URLUtils;
import org.eclipse.buckminster.sax.UUIDKeyed;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ComponentQuery
extends UUIDKeyed
implements IUUIDPersisted,
IComponentQuery {
    public static final String ATTR_PROPERTIES = "properties";
    public static final String ATTR_RESOURCE_MAP = "resourceMap";
    public static final String ATTR_SHORT_DESC = "shortDesc";
    public static final String ELEM_ROOT_REQUEST = "rootRequest";
    public static final int SEQUENCE_NUMBER = 4;
    public static final String TAG = "componentQuery";
    private final List<AdvisorNode> advisorNodes;
    private transient Map<String, String> allProperties;
    private final Documentation documentation;
    private final Map<String, String> properties;
    private final URL contextURL;
    private final String propertiesURL;
    private final String resourceMapURL;
    private final ComponentRequest rootRequest;
    private final String shortDesc;
    private transient IConnectContext connectContext;

    public static ComponentQuery fromStream(URL url, IConnectContext cctx, InputStream stream, boolean validating) throws CoreException {
        try {
            IParserFactory pf = CorePlugin.getDefault().getParserFactory();
            IParser<ComponentQuery> parser = pf.getComponentQueryParser(false);
            ComponentQuery cquery = parser.parse(url.toString(), stream);
            cquery.setConnectContext(cctx);
            return cquery;
        }
        catch (Exception e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    public static ComponentQuery fromURL(URL url, IConnectContext cctx, boolean validating) throws CoreException {
        InputStream stream = null;
        try {
            stream = DownloadManager.read((URL)url, (IConnectContext)cctx);
            ComponentQuery componentQuery = ComponentQuery.fromStream(url, cctx, stream, validating);
            return componentQuery;
        }
        catch (IOException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        finally {
            IOUtils.close((Closeable)stream);
        }
    }

    public ComponentQuery(ComponentQueryBuilder bld) {
        this.documentation = bld.getDocumentation();
        this.shortDesc = bld.getShortDesc();
        this.propertiesURL = bld.getPropertiesURL();
        this.resourceMapURL = bld.getResourceMapURL();
        this.rootRequest = bld.getRootRequest();
        List<AdvisorNodeBuilder> advisorNodeBuilders = bld.getAdvisoryNodes();
        if (advisorNodeBuilders.size() == 0) {
            this.advisorNodes = Collections.emptyList();
        } else {
            ArrayList<AdvisorNode> advisorNodeList = new ArrayList<AdvisorNode>(advisorNodeBuilders.size());
            for (AdvisorNodeBuilder nodeBld : advisorNodeBuilders) {
                advisorNodeList.add(nodeBld.create());
            }
            this.advisorNodes = Collections.unmodifiableList(advisorNodeList);
        }
        Map<String, String> props = bld.getDeclaredProperties();
        this.properties = props == null || props.size() == 0 ? Collections.emptyMap() : Collections.unmodifiableMap(new ExpandingProperties<String>(props));
        this.contextURL = bld.getContextURL();
    }

    public boolean allowCircularDependency(ComponentName cName, Map<String, ? extends Object> props) {
        IAdvisorNode node = this.getMatchingNode(cName, props);
        return node == null ? false : node.allowCircularDependency();
    }

    @Override
    public List<? extends IAdvisorNode> getAdvisoryNodes() {
        return this.advisorNodes;
    }

    public List<String> getAttributes(ComponentName cName, Map<String, ? extends Object> props) {
        IAdvisorNode node = this.getMatchingNode(cName, props);
        return node == null ? Collections.emptyList() : node.getAttributes();
    }

    public VersionSelector[] getBranchTagPath(ComponentName cName, Map<String, ? extends Object> props) {
        IAdvisorNode node = this.getMatchingNode(cName, props);
        return node == null ? VersionSelector.EMPTY_PATH : node.getBranchTagPath();
    }

    public IConnectContext getConnectContext() {
        return this.connectContext;
    }

    @Override
    public URL getContextURL() {
        return this.contextURL;
    }

    @Override
    public Map<String, String> getDeclaredProperties() {
        return this.properties;
    }

    public String getDefaultTag() {
        return TAG;
    }

    @Override
    public Documentation getDocumentation() {
        return this.documentation;
    }

    public ComponentRequest getExpandedRootRequest(Map<String, ? extends Object> props) {
        String expName;
        String name = this.rootRequest.getName();
        return name.equals(expName = ExpandingProperties.expand(props, name, 0)) ? this.rootRequest : new ComponentRequest(expName, this.rootRequest.getComponentTypeID(), this.rootRequest.getVersionRange());
    }

    public synchronized Map<String, String> getGlobalProperties() {
        block8: {
            if (this.allProperties != null) {
                return this.allProperties;
            }
            this.allProperties = new ExpandingProperties<String>();
            this.allProperties.putAll(this.properties);
            if (this.propertiesURL != null) {
                URL propsURL = this.getResolvedPropertiesURL();
                InputStream input = null;
                try {
                    try {
                        input = DownloadManager.read((URL)propsURL, (IConnectContext)this.getConnectContext());
                        BMProperties urlProps = new BMProperties(input);
                        if (urlProps.size() > 0) {
                            this.allProperties = new ExpandingProperties<String>(this.allProperties);
                            this.allProperties.putAll(urlProps);
                        }
                    }
                    catch (Exception e) {
                        CorePlugin.getLogger().info(NLS.bind((String)Messages.Unable_to_read_property_file_0_1, (Object)propsURL, (Object)e.toString()), new Object[0]);
                        IOUtils.close((Closeable)input);
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.close(input);
                    throw throwable;
                }
                IOUtils.close((Closeable)input);
            }
        }
        return this.allProperties;
    }

    public IAdvisorNode getMatchingNode(ComponentName cName, Map<String, ? extends Object> props) {
        String name = cName.getName();
        for (IAdvisorNode iAdvisorNode : this.advisorNodes) {
            Filter filter;
            String matchingType;
            Pattern pattern = iAdvisorNode.getNamePattern();
            if (pattern != null && !pattern.matcher(name).find() || (matchingType = iAdvisorNode.getComponentTypeID()) != null && !matchingType.equals(cName.getComponentTypeID()) || (filter = iAdvisorNode.getFilter()) != null && !filter.matches(props)) continue;
            return iAdvisorNode;
        }
        return null;
    }

    @Override
    public AdvisorNode getNodeByCriteria(Pattern pattern, String componentType, Filter filter) {
        for (AdvisorNode node : this.advisorNodes) {
            if (!Trivial.equalsAllowNull((Object)node.getNamePattern(), (Object)pattern) || !Trivial.equalsAllowNull((Object)node.getComponentTypeID(), (Object)componentType) || !Trivial.equalsAllowNull((Object)node.getFilter(), (Object)filter)) continue;
            return node;
        }
        return null;
    }

    public URL getOverlayFolder(ComponentName cName, Map<String, ? extends Object> props) {
        IAdvisorNode node = this.getMatchingNode(cName, props);
        return node == null ? null : node.getOverlayFolder();
    }

    @Override
    public String getPropertiesURL() {
        return this.propertiesURL;
    }

    public ProviderScore getProviderScore(ComponentName cName, boolean mutable, boolean source, Map<String, ? extends Object> props) {
        IAdvisorNode node = this.getMatchingNode(cName, props);
        if (node == null) {
            return ProviderScore.GOOD;
        }
        ProviderScore mutableScore = ProviderScore.FAIR;
        switch (node.getMutableLevel()) {
            case REQUIRE: {
                if (!mutable) {
                    return ProviderScore.REJECTED;
                }
                mutableScore = ProviderScore.PREFERRED;
                break;
            }
            case DESIRE: {
                mutableScore = mutable ? ProviderScore.GOOD : ProviderScore.BAD;
                break;
            }
            case AVOID: {
                mutableScore = mutable ? ProviderScore.BAD : ProviderScore.GOOD;
                break;
            }
            case REJECT: {
                if (mutable) {
                    return ProviderScore.REJECTED;
                }
                mutableScore = ProviderScore.PREFERRED;
            }
        }
        ProviderScore sourceScore = ProviderScore.FAIR;
        switch (node.getSourceLevel()) {
            case REQUIRE: {
                if (!source) {
                    return ProviderScore.REJECTED;
                }
                sourceScore = ProviderScore.PREFERRED;
                break;
            }
            case DESIRE: {
                sourceScore = source ? ProviderScore.GOOD : ProviderScore.BAD;
                break;
            }
            case AVOID: {
                sourceScore = source ? ProviderScore.BAD : ProviderScore.GOOD;
                break;
            }
            case REJECT: {
                if (source) {
                    return ProviderScore.REJECTED;
                }
                sourceScore = ProviderScore.PREFERRED;
            }
        }
        return ProviderScore.values()[(sourceScore.ordinal() + mutableScore.ordinal()) / 2];
    }

    public int[] getResolutionPrio(ComponentName cName, Map<String, ? extends Object> props) {
        IAdvisorNode node = this.getMatchingNode(cName, props);
        return node == null ? IAdvisorNode.DEFAULT_RESOLUTION_PRIO : node.getResolutionPrio();
    }

    public URL getResolvedPropertiesURL() {
        return this.propertiesURL == null ? null : URLUtils.resolveURL((URL)this.contextURL, (String)ExpandingProperties.expand(BMProperties.getSystemProperties(), this.propertiesURL, 0));
    }

    public URL getResolvedResourceMapURL() {
        return this.resourceMapURL == null ? null : URLUtils.resolveURL((URL)this.contextURL, (String)ExpandingProperties.expand(BMProperties.getSystemProperties(), this.resourceMapURL, 0));
    }

    @Override
    public String getResourceMapURL() {
        return this.resourceMapURL;
    }

    public String getRevision(ComponentName cName, Map<String, ? extends Object> props) {
        IAdvisorNode node = this.getMatchingNode(cName, props);
        return node == null ? null : node.getRevision();
    }

    @Override
    public ComponentRequest getRootRequest() {
        return this.rootRequest;
    }

    @Override
    public String getShortDesc() {
        return this.shortDesc;
    }

    public String getTagInfo() {
        return NLS.bind((String)Messages.Query_for_0, (Object)this.rootRequest);
    }

    public Date getTimestamp(ComponentName cName, Map<String, ? extends Object> props) {
        IAdvisorNode node = this.getMatchingNode(cName, props);
        return node == null ? null : node.getTimestamp();
    }

    public VersionRange getVersionOverride(ComponentName cName, Map<String, ? extends Object> props) {
        IAdvisorNode node = this.getMatchingNode(cName, props);
        return node == null ? null : node.getVersionOverride();
    }

    @Override
    public boolean isPersisted(StorageManager sm) throws CoreException {
        return false;
    }

    public boolean isPrune(ComponentName cName, Map<String, ? extends Object> props) {
        IAdvisorNode node = this.getMatchingNode(cName, props);
        return node == null ? false : node.isPrune();
    }

    @Override
    public void remove(StorageManager sm) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void removeAdvisorNode(IAdvisorNode node) {
        this.advisorNodes.remove(node);
    }

    public ComponentQuery resolve() {
        ComponentQueryBuilder bld = new ComponentQueryBuilder();
        bld.initFrom(this);
        URL tmp = this.getResolvedPropertiesURL();
        if (tmp != null) {
            bld.setPropertiesURL(tmp.toString());
        }
        if ((tmp = this.getResolvedResourceMapURL()) != null) {
            bld.setResourceMapURL(tmp.toString());
        }
        bld.setContextURL(null);
        return bld.createComponentQuery();
    }

    public boolean skipComponent(ComponentName cName, Map<String, ? extends Object> props) {
        IAdvisorNode node = this.getMatchingNode(cName, props);
        return node == null ? false : node.skipComponent();
    }

    @Override
    public void store(StorageManager sm) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void toSax(ContentHandler handler) throws SAXException {
        handler.startDocument();
        this.toSax(handler, "http://www.eclipse.org/buckminster/CQuery-1.0", "cq", this.getDefaultTag());
        handler.endDocument();
    }

    public void toSax(ContentHandler handler, String namespace, String prefix, String localName) throws SAXException {
        handler.startPrefixMapping("cq", "http://www.eclipse.org/buckminster/CQuery-1.0");
        super.toSax(handler, namespace, prefix, localName);
        handler.endPrefixMapping("cq");
    }

    public boolean useMaterialization(ComponentName cName, Map<String, ? extends Object> props) {
        IAdvisorNode node = this.getMatchingNode(cName, props);
        return node == null ? true : node.isUseMaterialization();
    }

    public boolean useResolutionService(ComponentName cName, Map<String, ? extends Object> props) {
        IAdvisorNode node = this.getMatchingNode(cName, props);
        return node == null ? true : node.isUseRemoteResolution();
    }

    public boolean useTargetPlatform(ComponentName cName, Map<String, ? extends Object> props) {
        IAdvisorNode node = this.getMatchingNode(cName, props);
        return node == null ? true : node.isUseTargetPlatform();
    }

    public boolean useWorkspace(ComponentName cName, Map<String, ? extends Object> props) {
        IAdvisorNode node = this.getMatchingNode(cName, props);
        return node == null ? true : node.isUseWorkspace();
    }

    protected void addAttributes(AttributesImpl attrs) throws SAXException {
        if (this.resourceMapURL != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_RESOURCE_MAP, (String)this.resourceMapURL.toString());
        }
        if (this.propertiesURL != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_PROPERTIES, (String)this.propertiesURL.toString());
        }
        if (this.shortDesc != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_SHORT_DESC, (String)this.shortDesc);
        }
    }

    protected void emitElements(ContentHandler handler, String namespace, String prefix) throws SAXException {
        if (this.documentation != null) {
            this.documentation.toSax(handler, namespace, prefix, this.documentation.getDefaultTag());
        }
        this.rootRequest.toSax(handler, namespace, prefix, ELEM_ROOT_REQUEST);
        SAXEmitter.emitProperties(handler, this.properties, namespace, prefix, true, false);
        for (AdvisorNode node : this.advisorNodes) {
            node.toSax(handler, namespace, prefix, node.getDefaultTag());
        }
    }

    protected String getElementNamespace(String namespace) {
        return "http://www.eclipse.org/buckminster/CQuery-1.0";
    }

    protected String getElementPrefix(String prefix) {
        return "cq";
    }

    private void setConnectContext(IConnectContext cctx) {
        this.connectContext = cctx;
    }
}

