/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.rmap.model;

import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.rmap.model.BidirectionalTransformer;
import org.eclipse.buckminster.core.version.AbstractConverter;
import org.eclipse.buckminster.core.version.IVersionConverter;
import org.eclipse.buckminster.sax.AbstractSaxableElement;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.p2.metadata.IVersionFormat;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class VersionConverterDesc
extends AbstractSaxableElement {
    public static final String TAG = "versionConverter";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_VERSION_FORMAT = "versionFormat";
    public static final String ATTR_VERSION_TYPE = "versionType";
    private final String type;
    private final BidirectionalTransformer[] transformers;
    private final IVersionFormat versionFormat;

    public VersionConverterDesc(String type, IVersionFormat versionFormat, BidirectionalTransformer[] transformers) {
        this.type = type;
        this.transformers = transformers;
        this.versionFormat = versionFormat;
    }

    public String getDefaultTag() {
        return TAG;
    }

    public final BidirectionalTransformer[] getTransformers() {
        return this.transformers;
    }

    public final String getType() {
        return this.type;
    }

    public IVersionConverter getVersionConverter() throws CoreException {
        AbstractConverter vct = (AbstractConverter)CorePlugin.getDefault().getVersionConverter(this.type);
        vct.setTransformers(this.transformers);
        vct.setVersionFormat(this.versionFormat);
        return vct;
    }

    protected void addAttributes(AttributesImpl attrs) throws SAXException {
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_TYPE, (String)this.type);
        if (this.versionFormat != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_VERSION_FORMAT, (String)this.versionFormat.toString());
        }
    }

    protected void emitElements(ContentHandler handler, String namespace, String prefix) throws SAXException {
        BidirectionalTransformer[] bidirectionalTransformerArray = this.transformers;
        int n = this.transformers.length;
        int n2 = 0;
        while (n2 < n) {
            BidirectionalTransformer transformer = bidirectionalTransformerArray[n2];
            transformer.toSax(handler, namespace, prefix, transformer.getDefaultTag());
            ++n2;
        }
    }
}

