/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.version;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.buckminster.core.actor.IActionContext;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.helpers.DateAndTimeUtils;
import org.eclipse.buckminster.core.metadata.MissingComponentException;
import org.eclipse.buckminster.core.metadata.WorkspaceInfo;
import org.eclipse.buckminster.core.reader.AbstractReaderType;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.core.version.AbstractQualifierGenerator;
import org.eclipse.buckminster.core.version.BuildTimestampQualifierGenerator;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;

public class TimestampQualifierGenerator
extends AbstractQualifierGenerator {
    public static final String FORMAT_PROPERTY = "generator.lastModified.format";
    public static final String DEFAULT_FORMAT = "'v'yyyyMMddHHmm";
    public static final String[] commonFormats = new String[]{"'v'yyyyMMddHHmm", "'v'yyyyMMdd-HHmm", "'v'yyyyMMdd", "'I'yyyyMMddHHmm", "'I'yyyyMMdd-HHmm", "'I'yyyyMMdd"};
    public static final DateFormat[] commonFormatters;
    private static final long SANITY_THRESHOLD = 315792000000L;

    static {
        int idx = commonFormats.length;
        commonFormatters = new DateFormat[idx];
        while (--idx >= 0) {
            SimpleDateFormat dm = new SimpleDateFormat(commonFormats[idx]);
            dm.setTimeZone(DateAndTimeUtils.UTC);
            dm.setLenient(false);
            TimestampQualifierGenerator.commonFormatters[idx] = dm;
        }
    }

    public static DateFormat getDateFormat(Map<String, ? extends Object> props) {
        String format = (String)props.get(FORMAT_PROPERTY);
        if (format == null) {
            format = DEFAULT_FORMAT;
        }
        SimpleDateFormat mf = new SimpleDateFormat(format);
        mf.setTimeZone(DateAndTimeUtils.UTC);
        mf.setLenient(false);
        return mf;
    }

    private static Date getLastModification(ComponentIdentifier cid, IActionContext context) throws CoreException {
        IPath location = WorkspaceInfo.getComponentLocation(cid);
        IProject project = WorkspaceInfo.getProject(cid);
        if (project == null) {
            Buckminster.getLogger().debug("getLastModification: Failed determine project for component %s", new Object[]{cid});
            return null;
        }
        IReaderType readerType = AbstractReaderType.getTypeForResource((IResource)project);
        if (readerType == null) {
            Buckminster.getLogger().debug("getLastModification: Failed determine reader type for component %s", new Object[]{cid});
            return null;
        }
        try {
            return readerType.getLastModification(location.toFile(), context.getCancellationMonitor());
        }
        catch (RuntimeException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    private static Date parseSaneDate(DateFormat mf, String str) throws ParseException {
        long now = System.currentTimeMillis();
        long sanePast = now - 315792000000L;
        Date dt = mf.parse(str);
        long tm = dt.getTime();
        if (tm > now || tm < sanePast) {
            throw new ParseException("Bogus", 0);
        }
        return dt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public Version generateQualifier(IActionContext context, ComponentIdentifier cid, List<ComponentIdentifier> dependencies) throws CoreException {
        Version currentVersion = cid.getVersion();
        if (currentVersion == null) {
            return null;
        }
        try {
            IInstallableUnit prevIU;
            Version newVersion;
            String newQual;
            Date lastMod = TimestampQualifierGenerator.getLastModification(cid, context);
            if (lastMod == null) {
                return currentVersion;
            }
            Map<String, ? extends Object> props = context.getProperties();
            DateFormat mf = TimestampQualifierGenerator.getDateFormat(props);
            Iterator<ComponentIdentifier> iterator = dependencies.iterator();
            while (true) {
                String qualifier;
                if (!iterator.hasNext()) {
                    newQual = mf.format(lastMod);
                    newQual = VersionHelper.getQualifier(currentVersion).replace("qualifier", newQual);
                    newVersion = VersionHelper.replaceQualifier(currentVersion, newQual);
                    prevIU = this.obtainFromReferenceRepo(cid, null);
                    if (prevIU != null) break;
                    return newVersion;
                }
                ComponentIdentifier dependency = iterator.next();
                Version depVer = dependency.getVersion();
                if (depVer == null || (qualifier = VersionHelper.getQualifier(depVer)) == null) continue;
                Date depLastMod = null;
                try {
                    depLastMod = TimestampQualifierGenerator.parseSaneDate(mf, qualifier);
                }
                catch (ParseException e) {
                    DateFormat[] dateFormatArray = commonFormatters;
                    // MONITORENTER : commonFormatters
                    int idx = 0;
                    while (idx < commonFormatters.length) {
                        try {
                            depLastMod = TimestampQualifierGenerator.parseSaneDate(commonFormatters[idx], qualifier);
                            break;
                        }
                        catch (ParseException parseException) {
                            ++idx;
                        }
                    }
                    // MONITOREXIT : dateFormatArray
                }
                if (depLastMod == null) {
                    try {
                        depVer = VersionHelper.replaceQualifier(depVer, "qualifier");
                        depLastMod = TimestampQualifierGenerator.getLastModification(new ComponentIdentifier(dependency.getName(), dependency.getComponentTypeID(), depVer), context);
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
                if (depLastMod == null || depLastMod.compareTo(lastMod) <= 0) continue;
                lastMod = depLastMod;
            }
            String buildId = prevIU.getProperty("buckminster.build.id");
            if (buildId == null) return newVersion;
            if (buildId.equals(props.get("build.id"))) {
                return newVersion;
            }
            newQual = mf.format(BuildTimestampQualifierGenerator.getBuildTimestamp(context));
            newQual = VersionHelper.getQualifier(currentVersion).replace("qualifier", newQual);
            return VersionHelper.replaceQualifier(currentVersion, newQual);
        }
        catch (MissingComponentException e) {
            return currentVersion;
        }
    }
}

