/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.generic.ui.actions;

import org.eclipse.buckminster.generic.ui.Messages;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;

public abstract class AbstractObjectAction<T>
implements IObjectActionDelegate {
    private IWorkbenchPart activePart;
    private T selected;

    public Shell getShell() {
        if (this.activePart == null) {
            throw new IllegalStateException(Messages.active_part_not_set);
        }
        return this.activePart.getSite().getShell();
    }

    public void run(IAction action) {
        if (this.activePart == null) {
            return;
        }
        IWorkbenchPartSite site = this.activePart.getSite();
        Shell shell = site.getShell();
        if (this.selected == null) {
            MessageDialog.openInformation((Shell)shell, null, (String)Messages.nothing_selected);
            return;
        }
        this.run(this.selected, this.activePart.getSite().getShell());
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selected = null;
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection s = (IStructuredSelection)selection;
        if (s.size() != 1) {
            return;
        }
        Object first = s.getFirstElement();
        this.selected = this.getType().isInstance(first) ? this.getType().cast(first) : this.adapt(first);
        action.setEnabled(this.selected != null);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.activePart = targetPart;
    }

    protected T adapt(Object object) {
        return this.getType().cast(((IAdaptable)object).getAdapter(this.getType()));
    }

    protected abstract Class<T> getType();

    protected abstract void run(T var1, Shell var2);

    protected void setSelected(T object) {
        this.selected = object;
    }

    protected boolean showConfirm(String title, String question) {
        return MessageDialog.openConfirm((Shell)this.getShell(), (String)title, (String)question);
    }

    protected void showError(String title, String message) {
        ErrorDialog.openError((Shell)this.getShell(), (String)title, (String)message, (IStatus)new Status(4, "org.eclipse.buckminster.generic.ui.actions", message));
    }

    protected void showError(String title, String message, Throwable e) {
        ErrorDialog.openError((Shell)this.getShell(), (String)title, (String)message, (IStatus)new Status(4, "org.eclipse.buckminster.generic.ui.actions", e.getMessage(), e));
    }

    protected void showMessage(String title, String message) {
        MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
    }
}

