/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.junit;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.buckminster.cmdline.Option;
import org.eclipse.buckminster.cmdline.OptionDescriptor;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.commands.Launch;
import org.eclipse.buckminster.core.helpers.FileUtils;
import org.eclipse.buckminster.junit.internal.Messages;
import org.eclipse.buckminster.junit.internal.ResultSerializer;
import org.eclipse.buckminster.junit.internal.TestListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.junit.JUnitCore;
import org.eclipse.jdt.junit.TestRunListener;
import org.xml.sax.InputSource;

public class JUnitCommand
extends Launch {
    private static final OptionDescriptor QUIET_DESCRIPTOR = new OptionDescriptor('q', "quiet", 1);
    private static final OptionDescriptor OUTPUT_DESCRIPTOR = new OptionDescriptor('o', "output", 3);
    private static final OptionDescriptor TERSE_XML_DESCRIPTOR = new OptionDescriptor(null, "terseXML", 1);
    private static final OptionDescriptor FLAT_XML_DESCRIPTOR = new OptionDescriptor(null, "flatXML", 1);
    private static final OptionDescriptor MAX_AWAIT_JUNIT_REPORT_DESCRIPTOR = new OptionDescriptor('t', "maxTimeAwaitJunitReport", 3);
    private boolean quiet;
    private String outputPath;
    private boolean terseXML;
    private boolean flatXML;
    private int maxAwaitJunitReport = 10;

    protected void getOptionDescriptors(List<OptionDescriptor> appendHere) throws Exception {
        super.getOptionDescriptors(appendHere);
        appendHere.add(QUIET_DESCRIPTOR);
        appendHere.add(OUTPUT_DESCRIPTOR);
        appendHere.add(TERSE_XML_DESCRIPTOR);
        appendHere.add(FLAT_XML_DESCRIPTOR);
        appendHere.add(MAX_AWAIT_JUNIT_REPORT_DESCRIPTOR);
    }

    protected void handleOption(Option option) throws Exception {
        super.handleOption(option);
        if (option.is(QUIET_DESCRIPTOR)) {
            this.quiet = true;
        } else if (option.is(OUTPUT_DESCRIPTOR)) {
            this.outputPath = option.getValue();
        } else if (option.is(TERSE_XML_DESCRIPTOR)) {
            this.terseXML = true;
        } else if (option.is(FLAT_XML_DESCRIPTOR)) {
            this.flatXML = true;
        } else if (option.is(MAX_AWAIT_JUNIT_REPORT_DESCRIPTOR)) {
            this.maxAwaitJunitReport = Integer.valueOf(option.getValue());
        }
    }

    protected int internalRun(IProgressMonitor monitor) throws Exception {
        TestListener listener = new TestListener(this.quiet);
        JUnitCore.addTestRunListener((TestRunListener)listener);
        try {
            int result = super.internalRun(monitor);
            if (this.outputPath != null) {
                this.exportTestRunSession(listener);
            }
            int n = result;
            return n;
        }
        finally {
            JUnitCore.removeTestRunListener((TestRunListener)listener);
        }
    }

    private void exportTestRunSession(TestListener listener) throws Exception {
        try {
            listener.waitForFinish(this.maxAwaitJunitReport, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            CorePlugin.getLogger().warning((Throwable)e, Messages.JUnitCommand_Export_interrupted, new Object[0]);
            Thread.interrupted();
        }
        File parentFile = new File(this.outputPath).getParentFile();
        if (parentFile != null) {
            FileUtils.createDirectory((File)parentFile, (IProgressMonitor)new NullProgressMonitor());
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.outputPath));
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        InputSource inputSource = new InputSource();
        SAXSource source = new SAXSource(new ResultSerializer(listener, this.getRawStdOut(), this.getRawStdErr(), this.terseXML, this.flatXML), inputSource);
        StreamResult result = new StreamResult(out);
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        try {
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        transformer.transform(source, result);
    }
}

