/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.maven.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.buckminster.maven.internal.GroupAndArtifact;
import org.eclipse.buckminster.maven.internal.GroupAndArtifactHandler;
import org.eclipse.buckminster.maven.internal.MapEntry;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.buckminster.sax.ChildHandler;
import org.eclipse.buckminster.sax.ChildPoppedListener;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class MapEntryHandler
extends GroupAndArtifactHandler
implements ChildPoppedListener {
    private GroupAndArtifactHandler aliasHandler;
    private List<GroupAndArtifact> aliases;
    private String name;

    public MapEntryHandler(AbstractHandler parent) {
        super(parent);
    }

    public void childPopped(ChildHandler child) throws SAXException {
        if (this.aliases == null) {
            this.aliases = new ArrayList<GroupAndArtifact>();
        }
        this.aliases.add(((GroupAndArtifactHandler)child).createEntry());
    }

    public ChildHandler createHandler(String uri, String localName, Attributes attrs) throws SAXException {
        GroupAndArtifactHandler ch;
        if (localName.equals("alias")) {
            if (this.aliasHandler == null) {
                this.aliasHandler = new GroupAndArtifactHandler((AbstractHandler)this);
            }
            ch = this.aliasHandler;
        } else {
            ch = super.createHandler(uri, localName, attrs);
        }
        return ch;
    }

    @Override
    public void handleAttributes(Attributes attrs) throws SAXException {
        super.handleAttributes(attrs);
        this.name = this.getStringValue(attrs, "name");
        if (this.aliases != null) {
            this.aliases.clear();
        }
    }

    @Override
    GroupAndArtifact createEntry() {
        return new MapEntry(this.name, this.getGroup(), this.getArtifact(), this.aliases);
    }

    String getName() {
        return this.name;
    }
}

