/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.runtime;

import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class BuckminsterException
extends CoreException {
    public static IStatus createStatus(String message, Object ... args) {
        return BuckminsterException.createStatus(null, message, args);
    }

    public static IStatus createStatus(Throwable cause) {
        return cause instanceof CoreException ? ((CoreException)cause).getStatus() : new Status(4, "org.eclipse.buckminster.runtime", 0, cause.getMessage(), cause);
    }

    public static IStatus createStatus(Throwable cause, String message, Object ... args) {
        if (args.length > 0) {
            message = String.format(message, args);
        }
        return new Status(4, "org.eclipse.buckminster.runtime", 0, message, cause);
    }

    public static void deeplyPrint(Throwable e, PrintStream strm, boolean stackTrace) {
        BuckminsterException.deeplyPrint(e, strm, stackTrace, 0);
    }

    public static CoreException fromMessage(String message, Object ... args) {
        return BuckminsterException.fromMessage(null, message, args);
    }

    public static CoreException fromMessage(Throwable cause, String message, Object ... args) {
        CoreException ce = new CoreException(BuckminsterException.createStatus(cause, message, args));
        if (cause != null) {
            ce.initCause(cause);
        }
        return ce;
    }

    public static Throwable unwind(Throwable t) {
        String msg;
        Throwable cause;
        Class<?> tc;
        while (!((tc = t.getClass()) != RuntimeException.class && tc != InvocationTargetException.class && tc != SAXException.class && tc != IOException.class || (cause = t.getCause()) == null || (msg = t.getMessage()) != null && !msg.equals(cause.toString()))) {
            t = cause;
        }
        return t;
    }

    public static CoreException unwindCoreException(CoreException exception) {
        IStatus status = exception.getStatus();
        while (status != null && status.getException() instanceof CoreException) {
            exception = (CoreException)status.getException();
            status = exception.getStatus();
        }
        return exception;
    }

    public static CoreException wrap(IStatus status) {
        CoreException e = new CoreException(status);
        Throwable t = status.getException();
        if (t != null) {
            e.initCause(t);
        }
        return e;
    }

    public static CoreException wrap(Throwable t) {
        if ((t = BuckminsterException.unwind(t)) instanceof CoreException) {
            return BuckminsterException.unwindCoreException((CoreException)t);
        }
        if (t instanceof OperationCanceledException || t instanceof InterruptedException) {
            return new CoreException(Status.CANCEL_STATUS);
        }
        String msg = t.toString();
        if (t instanceof SAXParseException) {
            SAXParseException se = (SAXParseException)t;
            StringBuffer bld = new StringBuffer(msg);
            bld.append(": ");
            bld.append(se.getSystemId());
            bld.append(" at line: ");
            bld.append(se.getLineNumber());
            bld.append(" column: ");
            bld.append(se.getColumnNumber());
            msg = bld.toString();
        }
        return BuckminsterException.fromMessage(t, msg, new Object[0]);
    }

    private static void appendLevelString(PrintStream strm, int level) {
        if (level > 0) {
            strm.print("[0");
            int idx = 1;
            while (idx < level) {
                strm.print('.');
                strm.print(level);
                ++idx;
            }
            strm.print(']');
        }
    }

    private static void deeplyPrint(CoreException ce, PrintStream strm, boolean stackTrace, int level) {
        BuckminsterException.appendLevelString(strm, level);
        if (stackTrace) {
            ce.printStackTrace(strm);
        }
        BuckminsterException.deeplyPrint(ce.getStatus(), strm, stackTrace, level);
    }

    private static void deeplyPrint(IStatus status, PrintStream strm, boolean stackTrace, int level) {
        BuckminsterException.appendLevelString(strm, level);
        String msg = status.getMessage();
        strm.println(msg);
        Throwable cause = status.getException();
        if (cause != null) {
            strm.print("Caused by: ");
            if (stackTrace || !msg.equals(cause.getMessage()) && !msg.equals(cause.toString())) {
                BuckminsterException.deeplyPrint(cause, strm, stackTrace, level);
            }
        }
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                BuckminsterException.deeplyPrint(children[i], strm, stackTrace, level + 1);
                ++i;
            }
        }
    }

    private static void deeplyPrint(Throwable t, PrintStream strm, boolean stackTrace, int level) {
        if (t instanceof CoreException) {
            BuckminsterException.deeplyPrint((CoreException)t, strm, stackTrace, level);
        } else {
            BuckminsterException.appendLevelString(strm, level);
            if (stackTrace) {
                t.printStackTrace(strm);
            } else {
                strm.println(t.toString());
                Throwable cause = t.getCause();
                if (cause != null) {
                    strm.print("Caused by: ");
                    BuckminsterException.deeplyPrint(cause, strm, stackTrace, level);
                }
            }
        }
    }

    protected BuckminsterException(IStatus status) {
        super(status);
    }
}

