/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.sax;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.buckminster.sax.MissingRequiredAttributeException;
import org.eclipse.buckminster.sax.TopHandler;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractHandler
extends DefaultHandler {
    private HashMap<String, String> prefixMappings;

    public static boolean getOptionalBooleanValue(Attributes attrs, String qName, boolean defaultValue) {
        String value = AbstractHandler.getOptionalStringValue(attrs, qName);
        if (value == null) {
            return defaultValue;
        }
        if ("1".equals(value)) {
            return true;
        }
        if ("0".equals(value)) {
            return false;
        }
        return "true".equalsIgnoreCase(value);
    }

    public static final double getOptionalDoubleValue(Attributes attrs, String qName, double defaultValue) {
        String value = AbstractHandler.getOptionalStringValue(attrs, qName);
        return value == null ? defaultValue : Double.parseDouble(value);
    }

    public static final int getOptionalIntValue(Attributes attrs, String qName, int defaultValue) {
        String value = AbstractHandler.getOptionalStringValue(attrs, qName);
        return value == null ? defaultValue : Integer.parseInt(value);
    }

    public static final long getOptionalLongValue(Attributes attrs, String qName, long defaultValue) {
        String value = AbstractHandler.getOptionalStringValue(attrs, qName);
        return value == null ? defaultValue : Long.parseLong(value);
    }

    public static final String getOptionalStringValue(Attributes attrs, String qName) {
        String value = attrs.getValue(qName);
        if (value != null && (value = value.trim()).length() == 0) {
            value = null;
        }
        return value;
    }

    public static final String getOptionalStringValue(Attributes attrs, String qName, String defaultValue) {
        String value = AbstractHandler.getOptionalStringValue(attrs, qName);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.prefixMappings != null) {
            this.prefixMappings.remove(prefix);
        }
    }

    public Pattern getOptionalPatternValue(Attributes attrs, String qName) throws SAXParseException {
        String value = AbstractHandler.getOptionalStringValue(attrs, qName);
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            return Pattern.compile(value);
        }
        catch (PatternSyntaxException e) {
            throw new SAXParseException("The value of attribute " + qName + " is not a valid regular expression", this.getDocumentLocator(), e);
        }
    }

    public URL getOptionalURLValue(Attributes attrs, String qName) throws SAXParseException {
        String value = AbstractHandler.getOptionalStringValue(attrs, qName);
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            return new URL(value);
        }
        catch (MalformedURLException e) {
            if (value.indexOf(32) > 0) {
                try {
                    return new URL(value.replaceAll("\\s", "%20"));
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            throw new SAXParseException("The value of attribute " + qName + " is not a valid URL", this.getDocumentLocator(), e);
        }
    }

    public String getPrefixMapping(String prefix) {
        return this.prefixMappings == null ? null : this.prefixMappings.get(prefix);
    }

    public abstract String getTAG();

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.prefixMappings == null) {
            this.prefixMappings = new HashMap();
        }
        this.prefixMappings.put(prefix, uri);
    }

    protected boolean getBooleanValue(Attributes attrs, String qName) throws MissingRequiredAttributeException {
        String value = this.getStringValue(attrs, qName);
        if ("1".equals(value)) {
            return true;
        }
        if ("0".equals(value)) {
            return false;
        }
        return "true".equalsIgnoreCase(value);
    }

    protected abstract Locator getDocumentLocator();

    protected double getDoubleValue(Attributes attrs, String qName) throws MissingRequiredAttributeException {
        return Double.parseDouble(this.getStringValue(attrs, qName));
    }

    protected int getIntValue(Attributes attrs, String qName) throws MissingRequiredAttributeException {
        return Integer.parseInt(this.getStringValue(attrs, qName));
    }

    protected long getLongValue(Attributes attrs, String qName) throws MissingRequiredAttributeException {
        return Long.parseLong(this.getStringValue(attrs, qName));
    }

    protected Pattern getPatternValue(Attributes attrs, String qName) throws SAXParseException, MissingRequiredAttributeException {
        Pattern value = this.getOptionalPatternValue(attrs, qName);
        if (value == null) {
            throw new MissingRequiredAttributeException(this.getTAG(), qName, this.getDocumentLocator());
        }
        return value;
    }

    protected String getStringValue(Attributes attrs, String qName) throws MissingRequiredAttributeException {
        String value = AbstractHandler.getOptionalStringValue(attrs, qName);
        if (value == null) {
            throw new MissingRequiredAttributeException(this.getTAG(), qName, this.getDocumentLocator());
        }
        return value;
    }

    protected abstract TopHandler getTopHandler();

    protected URL getURLValue(Attributes attrs, String qName) throws SAXParseException, MissingRequiredAttributeException {
        URL value = this.getOptionalURLValue(attrs, qName);
        if (value == null) {
            throw new MissingRequiredAttributeException(this.getTAG(), qName, this.getDocumentLocator());
        }
        return value;
    }
}

