/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.subversion;

import java.net.URI;
import java.util.Date;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.helpers.TextUtils;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.reader.CatalogReaderType;
import org.eclipse.buckminster.core.reader.ITeamReaderType;
import org.eclipse.buckminster.core.reader.ReferenceInfo;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.core.version.VersionSelector;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.buckminster.subversion.ISubversionSession;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.RepositoryProvider;

public abstract class GenericReaderType<REPO_LOCATION_TYPE, SVN_ENTRY_TYPE, SVN_REVISION_TYPE>
extends CatalogReaderType
implements ITeamReaderType {
    public ReferenceInfo extractReferenceInfo(String reference) throws CoreException {
        String[] parts = TextUtils.split((String)reference, (String)",");
        if (parts.length < 3) {
            throw BuckminsterException.fromMessage((String)NLS.bind((String)"The svn readerType cannot parse PSF project reference {0}", (Object)reference), (Object[])new Object[0]);
        }
        String repositoryLocation = parts[1];
        String module = null;
        VersionSelector selector = null;
        boolean useScheme = false;
        int trunkPos = repositoryLocation.indexOf("/trunk");
        if (trunkPos > 0) {
            int trunkEnd = trunkPos + 6;
            if (repositoryLocation.length() > trunkEnd) {
                module = repositoryLocation.substring(trunkEnd);
                repositoryLocation = repositoryLocation.substring(0, trunkPos);
                useScheme = true;
            }
        } else {
            int branchPos = repositoryLocation.indexOf("/branches/");
            if (branchPos > 0) {
                int branchNameStart = branchPos + 10;
                int branchNameEnd = repositoryLocation.indexOf(47, branchNameStart);
                if (branchNameEnd == -1) {
                    branchNameEnd = repositoryLocation.length();
                } else {
                    module = repositoryLocation.substring(branchNameEnd);
                }
                selector = VersionSelector.branch((String)repositoryLocation.substring(branchNameStart, branchNameEnd));
                repositoryLocation = repositoryLocation.substring(0, branchPos);
                useScheme = true;
            } else {
                int tagPos = repositoryLocation.indexOf("/tags/");
                if (tagPos > 0) {
                    int tagNameStart = tagPos + 6;
                    int tagNameEnd = repositoryLocation.indexOf(47, tagNameStart);
                    if (tagNameEnd == -1) {
                        tagNameEnd = repositoryLocation.length();
                    } else {
                        module = repositoryLocation.substring(tagNameEnd);
                    }
                    selector = VersionSelector.tag((String)repositoryLocation.substring(tagNameStart, tagNameEnd));
                    repositoryLocation = repositoryLocation.substring(0, tagPos);
                    useScheme = true;
                }
            }
        }
        if (useScheme) {
            StringBuilder thaUri = new StringBuilder();
            thaUri.append(repositoryLocation);
            thaUri.append("/trunk");
            if (module != null) {
                thaUri.append(module);
                thaUri.append("?moduleAfterBranch&moduleAfterTag");
            } else {
                thaUri.append("?moduleBeforeBranch&moduleBeforeTag");
            }
            repositoryLocation = thaUri.toString();
        }
        return new ReferenceInfo(repositoryLocation, selector, parts[2]);
    }

    public final URI getArtifactURL(Resolution resolution, RMContext context) throws CoreException {
        return null;
    }

    public final Date getLastModification(String repositoryLocation, VersionSelector versionSelector, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(null, 1);
        ISubversionSession<SVN_ENTRY_TYPE, SVN_REVISION_TYPE> session = this.getSession(repositoryLocation, versionSelector);
        try {
            Date date = session.getLastTimestamp();
            return date;
        }
        finally {
            session.close();
            MonitorUtils.worked((IProgressMonitor)monitor, (int)1);
            monitor.done();
        }
    }

    public final long getLastRevision(String repositoryLocation, VersionSelector versionSelector, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(null, 1);
        ISubversionSession<SVN_ENTRY_TYPE, SVN_REVISION_TYPE> session = this.getSession(repositoryLocation, versionSelector);
        try {
            long l = session.getLastChangeNumber();
            return l;
        }
        finally {
            session.close();
            MonitorUtils.worked((IProgressMonitor)monitor, (int)1);
            monitor.done();
        }
    }

    public String getSourceReference(IResource resource, IProgressMonitor monitor) throws CoreException {
        String remoteLocation = this.getRemoteLocation(resource.getLocation().toFile(), monitor);
        if (remoteLocation == null) {
            return null;
        }
        return "scm:svn:" + remoteLocation;
    }

    public final void shareProject(IProject project, Resolution cr, RMContext context, IProgressMonitor monitor) throws CoreException {
        VersionMatch vm = cr.getVersionMatch();
        String repositoryURI = this.getRemoteLocation(project.getLocation().toFile(), monitor);
        ISubversionSession<SVN_ENTRY_TYPE, SVN_REVISION_TYPE> session = this.getSession(repositoryURI, vm.getBranchOrTag(), vm.getNumericRevision(), vm.getTimestamp(), context);
        session.createCommonRoots(context);
        session = this.getSession(repositoryURI, vm.getBranchOrTag(), vm.getNumericRevision(), vm.getTimestamp(), context);
        try {
            try {
                this.updateRepositoryMap(project, session);
            }
            catch (Exception ex) {
                throw BuckminsterException.wrap((Throwable)ex);
            }
        }
        finally {
            session.close();
        }
    }

    public IStatus tag(RepositoryProvider provider, IResource[] resources, String tag, boolean recurse, IProgressMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    protected abstract REPO_LOCATION_TYPE[] getKnownRepositories(IProgressMonitor var1) throws CoreException;

    protected abstract ISubversionSession<SVN_ENTRY_TYPE, SVN_REVISION_TYPE> getSession(String var1, VersionSelector var2, long var3, Date var5, RMContext var6) throws CoreException;

    protected abstract void updateRepositoryMap(IProject var1, ISubversionSession<SVN_ENTRY_TYPE, SVN_REVISION_TYPE> var2) throws Exception;

    private ISubversionSession<SVN_ENTRY_TYPE, SVN_REVISION_TYPE> getSession(String repositoryURI, VersionSelector branchOrTag) throws CoreException {
        return this.getSession(repositoryURI, branchOrTag, -1L, null, new RMContext(null));
    }
}

