/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.subversive.internal;

import java.io.File;
import java.io.OutputStream;
import java.net.URI;
import java.util.Date;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.helpers.FileUtils;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.buckminster.core.version.VersionSelector;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.subversion.GenericCache;
import org.eclipse.buckminster.subversion.GenericRemoteReader;
import org.eclipse.buckminster.subversion.ISubversionSession;
import org.eclipse.buckminster.subversive.internal.SimpleMonitorWrapper;
import org.eclipse.buckminster.subversive.internal.SubversiveSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNConnectorException;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.connector.SVNEntry;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNRevision;

public class SubversiveRemoteFileReader
extends GenericRemoteReader<SVNEntry, SVNRevision> {
    public SubversiveRemoteFileReader(IReaderType readerType, ProviderMatch rInfo, IProgressMonitor monitor) throws CoreException {
        super(readerType, rInfo, monitor);
    }

    protected void fetchRemoteFile(URI url, SVNRevision revision, OutputStream output, IProgressMonitor subMonitor) throws Exception {
        ISVNProgressMonitor svnMon = SimpleMonitorWrapper.beginTask(subMonitor, 100);
        ISVNConnector proxy = this.getSession().getSVNProxy();
        SVNEntryRevisionReference entry = new SVNEntryRevisionReference(url.toString(), revision, revision);
        proxy.streamFileContent(entry, 2048, output, svnMon);
    }

    private SubversiveSession getSession() {
        return (SubversiveSession)this.session;
    }

    protected ISubversionSession<SVNEntry, SVNRevision> getSession(String repositoryURI, VersionSelector branchOrTag, long revision, Date timestamp, RMContext context) throws CoreException {
        return new SubversiveSession(repositoryURI, branchOrTag, revision, timestamp, context);
    }

    protected SVNEntry[] getTopEntries(IProgressMonitor monitor) throws CoreException {
        return (SVNEntry[])this.session.listFolder(this.session.getSVNUrl(), monitor);
    }

    public void innerMaterialize(IPath destination, IProgressMonitor monitor) throws CoreException {
        boolean success = false;
        File destDir = destination.toFile();
        ISVNProgressMonitor svnMon = SimpleMonitorWrapper.beginTask(monitor, 12);
        try {
            try {
                this.getSession().getSVNProxy().checkout(new SVNEntryRevisionReference(this.session.getSVNUrl().toString(), (SVNRevision)this.session.getRevision(), (SVNRevision)this.session.getRevision()), destDir.toString(), SVNDepth.INFINITY, 4L, svnMon);
                success = true;
            }
            catch (SVNConnectorException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        }
        finally {
            if (!success) {
                try {
                    FileUtils.deleteRecursive((File)destDir, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            monitor.done();
        }
    }

    protected boolean remoteFileExists(URI url, SVNRevision revision, IProgressMonitor monitor) throws CoreException {
        return this.getSession().getDirEntry(url, revision, monitor) != null;
    }

    protected String storeInCache(String fileName) throws CoreException {
        URI url = this.session.getSVNUrl(fileName);
        SVNRevision revision = (SVNRevision)this.session.getRevision();
        return GenericCache.cacheKey((URI)url, (Object)revision);
    }
}

