/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.dependency.visualizer.controls;

import java.util.ArrayList;
import org.eclipse.buckminster.ui.dependency.visualizer.Messages;
import org.eclipse.buckminster.ui.dependency.visualizer.controls.AbstractViewerSettingControl;
import org.eclipse.buckminster.ui.dependency.visualizer.controls.listener.ViewerSettingChangeEvent;
import org.eclipse.buckminster.ui.dependency.visualizer.controls.listener.ViewerSettingType;
import org.eclipse.buckminster.ui.dependency.visualizer.viewer.provider.IRelationshipProvider;
import org.eclipse.buckminster.ui.dependency.visualizer.viewer.provider.internal.AllPathsToRootRelationshipProvider;
import org.eclipse.buckminster.ui.dependency.visualizer.viewer.provider.internal.CompositeRelationshipProvider;
import org.eclipse.buckminster.ui.dependency.visualizer.viewer.provider.internal.DirectRelationshipProvider;
import org.eclipse.buckminster.ui.dependency.visualizer.viewer.provider.internal.ShortestPathToRootRelationshipProvider;
import org.eclipse.buckminster.ui.dependency.visualizer.viewer.provider.internal.UsageRelationshipProvider;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class HighlightPathControl
extends AbstractViewerSettingControl
implements SelectionListener {
    private Button dependencies;
    private Button usage;
    private IRelationshipProvider relationshipProvider;
    private Button shortestPath;
    private Button allPaths;
    private Button noPath;

    public HighlightPathControl(FormToolkit toolkit) {
        super(toolkit);
    }

    @Override
    public Control createControl(Composite parent) {
        parent = this.getWidgetToolkit().createComposite(parent);
        parent.setLayout((Layout)new GridLayout(1, true));
        this.dependencies = this.getWidgetToolkit().createButton(parent, Messages.Dependencies, 32);
        this.dependencies.setSelection(true);
        this.dependencies.addSelectionListener((SelectionListener)this);
        this.usage = this.getWidgetToolkit().createButton(parent, Messages.Usage, 32);
        this.usage.setSelection(true);
        this.usage.addSelectionListener((SelectionListener)this);
        Group pathToRootDetails = new Group(parent, 16);
        this.getWidgetToolkit().adapt((Composite)pathToRootDetails);
        pathToRootDetails.setText(Messages.PathToRoot);
        pathToRootDetails.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().applyTo((Control)pathToRootDetails);
        this.shortestPath = this.getWidgetToolkit().createButton((Composite)pathToRootDetails, Messages.Shortest, 16);
        this.shortestPath.setSelection(false);
        this.shortestPath.addSelectionListener((SelectionListener)this);
        this.allPaths = this.getWidgetToolkit().createButton((Composite)pathToRootDetails, Messages.All, 16);
        this.allPaths.setSelection(true);
        this.allPaths.addSelectionListener((SelectionListener)this);
        this.noPath = this.getWidgetToolkit().createButton((Composite)pathToRootDetails, Messages.None, 16);
        this.noPath.setSelection(false);
        this.noPath.addSelectionListener((SelectionListener)this);
        this.widgetSelected(null);
        return parent;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        IRelationshipProvider provider = this.createRelationshipProvider();
        this.fireViewerSettingsChangedEvent(new ViewerSettingChangeEvent(this, ViewerSettingType.PATH_HIGHLIGHTING, provider, this.relationshipProvider));
        this.relationshipProvider = provider;
    }

    private IRelationshipProvider createRelationshipProvider() {
        ArrayList<IRelationshipProvider> provider = new ArrayList<IRelationshipProvider>();
        if (this.dependencies.getSelection()) {
            provider.add(new DirectRelationshipProvider());
        }
        if (this.usage.getSelection()) {
            provider.add(new UsageRelationshipProvider());
        }
        if (this.shortestPath.getSelection()) {
            provider.add(new ShortestPathToRootRelationshipProvider());
        } else if (this.allPaths.getSelection()) {
            provider.add(new AllPathsToRootRelationshipProvider());
        }
        return new CompositeRelationshipProvider(provider.toArray(new IRelationshipProvider[provider.size()]));
    }
}

