/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.buckminster.ui.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public abstract class AbstractProjectAction
implements IObjectActionDelegate {
    private IProject[] selectedProjects;
    private IWorkbenchPart workbenchPart;

    public void run(IAction action) {
        block9: {
            final IProject[] projs = this.getSelectedProjects();
            try {
                if (this.wantsMonitor()) {
                    final IAction internalAction = action;
                    WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                        protected void execute(IProgressMonitor monitor) throws CoreException {
                            monitor.beginTask(internalAction.getText(), projs.length * 1000);
                            try {
                                IProject[] iProjectArray = projs;
                                int n = projs.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IProject proj = iProjectArray[n2];
                                    AbstractProjectAction.this.internalRun(proj, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1000));
                                    ++n2;
                                }
                            }
                            finally {
                                monitor.done();
                            }
                        }
                    };
                    try {
                        this.getWorkbenchPart().getSite().getWorkbenchWindow().run(true, true, (IRunnableWithProgress)op);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (InvocationTargetException ite) {
                        Throwable t = ite.getTargetException();
                        if (t instanceof CoreException) {
                            CoreException ce = (CoreException)t;
                            ErrorDialog.openError((Shell)this.getWorkbenchPart().getSite().getShell(), (String)Messages.an_error_occured_during_creation_of_the_project, null, (IStatus)ce.getStatus());
                            break block9;
                        }
                        String title = Messages.an_error_occured_during_creation_of_the_project;
                        String rawMsg = t.getLocalizedMessage();
                        if (rawMsg == null) {
                            rawMsg = t.toString();
                        }
                        MessageDialog.openError((Shell)this.getWorkbenchPart().getSite().getShell(), (String)title, (String)NLS.bind((String)Messages.internal_error_0, (Object)rawMsg));
                    }
                    break block9;
                }
                IProject[] iProjectArray = projs;
                int n = projs.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject proj = iProjectArray[n2];
                    this.internalRun(proj, null);
                    ++n2;
                }
            }
            catch (CoreException ce) {
                throw new RuntimeException(ce);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selectedProjects = null;
        if (selection == null || selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return;
        }
        ArrayList projects = new ArrayList();
        IStructuredSelection ss = (IStructuredSelection)selection;
        for (Object s : ss) {
            if (!(s instanceof IProject)) continue;
            projects.add(s);
        }
        this.selectedProjects = projects.toArray(new IProject[0]);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.workbenchPart = targetPart;
    }

    protected IProject[] getSelectedProjects() {
        return this.selectedProjects;
    }

    protected IWorkbenchPart getWorkbenchPart() {
        return this.workbenchPart;
    }

    protected abstract void internalRun(IProject var1, IProgressMonitor var2) throws CoreException;

    protected boolean wantsMonitor() {
        return true;
    }
}

