/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.editor.cspec;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.cspec.IAttribute;
import org.eclipse.buckminster.core.cspec.IPrerequisite;
import org.eclipse.buckminster.core.cspec.builder.ActionArtifactBuilder;
import org.eclipse.buckminster.core.cspec.builder.ActionBuilder;
import org.eclipse.buckminster.core.cspec.builder.ArtifactBuilder;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.builder.PrerequisiteBuilder;
import org.eclipse.buckminster.core.cspec.builder.PrerequisitesBuilder;
import org.eclipse.buckminster.core.cspec.builder.TopLevelAttributeBuilder;
import org.eclipse.buckminster.core.cspec.model.PrerequisiteAlreadyDefinedException;
import org.eclipse.buckminster.core.cspec.model.UpToDatePolicy;
import org.eclipse.buckminster.core.helpers.TextUtils;
import org.eclipse.buckminster.osgi.filter.FilterFactory;
import org.eclipse.buckminster.ui.Messages;
import org.eclipse.buckminster.ui.UiUtils;
import org.eclipse.buckminster.ui.editor.EditorUtils;
import org.eclipse.buckminster.ui.editor.cspec.ArtifactsTable;
import org.eclipse.buckminster.ui.editor.cspec.AttributesTable;
import org.eclipse.buckminster.ui.editor.cspec.CSpecEditor;
import org.eclipse.buckminster.ui.editor.cspec.CSpecEditorUtils;
import org.eclipse.buckminster.ui.editor.cspec.PathWrapper;
import org.eclipse.buckminster.ui.editor.cspec.PathsTable;
import org.eclipse.buckminster.ui.editor.cspec.PrerequisitesTable;
import org.eclipse.buckminster.ui.editor.cspec.PropertiesTable;
import org.eclipse.buckminster.ui.editor.cspec.Property;
import org.eclipse.buckminster.ui.general.editor.ValidatorException;
import org.eclipse.buckminster.ui.general.editor.simple.SimpleTableEditor;
import org.eclipse.buckminster.ui.general.editor.structured.FieldModifyEvent;
import org.eclipse.buckminster.ui.general.editor.structured.IFieldModifyListener;
import org.eclipse.buckminster.ui.general.editor.structured.TwoPagesTableEditor;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.InvalidSyntaxException;

public class ActionsTable
extends AttributesTable<ActionBuilder> {
    private Map<ActionBuilder, List<ActionArtifactBuilder>> actionArtifacts;
    private Text actorNameText;
    private Button alwaysCheck;
    private Button assignConsoleSupportCheck;
    private Text actionFilter;
    private Combo upToDatePolicy;
    private Text fileCountText;
    private Text additionalFileCountText;
    private Text prodAliasText;
    private Text prodBaseText;
    private List<Property> actorProperties = new ArrayList<Property>();
    private SimpleTableEditor<Property> actorPropertiesEditor;
    private Button pathsButton;
    private List<PathWrapper> productPaths = new ArrayList<PathWrapper>();
    private SimpleTableEditor<PathWrapper> productPathsEditor;
    private Button artifactsButton;
    private List<ArtifactBuilder> productArtifacts = new ArrayList<ArtifactBuilder>();
    private TwoPagesTableEditor<ArtifactBuilder> productArtifactsEditor;
    private List<Property> properties = new ArrayList<Property>();
    private SimpleTableEditor<Property> propertiesEditor;
    private Text prereqNameText;
    private Text prereqRebasePathText;
    private List<PrerequisiteBuilder> prerequisites = new ArrayList<PrerequisiteBuilder>();
    private SimpleTableEditor<PrerequisiteBuilder> prerequisitesEditor;

    public ActionsTable(CSpecEditor editor, List<ActionBuilder> data, Map<ActionBuilder, List<ActionArtifactBuilder>> actionArtifacts, CSpecBuilder cspec, boolean readOnly) {
        super(editor, data, cspec, readOnly);
        this.actionArtifacts = actionArtifacts;
    }

    @Override
    public void enableFields(boolean enabled) {
        super.enableFields(enabled);
        this.actorNameText.setEnabled(enabled);
        this.alwaysCheck.setEnabled(enabled);
        this.assignConsoleSupportCheck.setEnabled(enabled);
        this.actionFilter.setEnabled(enabled);
        this.upToDatePolicy.setEnabled(enabled);
        this.refreshFileCountFields();
        this.prodAliasText.setEnabled(enabled);
        this.prodBaseText.setEnabled(enabled);
        this.actorPropertiesEditor.setEnabled(enabled);
        this.pathsButton.setEnabled(enabled);
        this.productPathsEditor.setEnabled(enabled && this.pathsButton.getSelection());
        this.artifactsButton.setEnabled(enabled);
        this.productArtifactsEditor.setEnabled(enabled && this.artifactsButton.getSelection());
        this.propertiesEditor.setEnabled(enabled);
        this.prereqNameText.setEnabled(enabled);
        this.prereqRebasePathText.setEnabled(enabled);
        this.prerequisitesEditor.setEnabled(enabled);
    }

    @Override
    public void fillStack(Composite stackComposite) {
        this.addStackMapping(Messages.general, this.createGeneralStackLayer(stackComposite));
        this.addStackMapping(Messages.properties, this.createPropertiesStackLayer(stackComposite));
        this.addStackMapping(Messages.products, this.createProductsStackLayer(stackComposite));
        this.addStackMapping(Messages.documentation, this.createDocumentationStackLayer(stackComposite));
    }

    @Override
    protected ActionBuilder createNewRow() {
        return this.getCSpecBuilder().createActionBuilder();
    }

    @Override
    protected void refreshRow(ActionBuilder builder) {
        super.refreshRow(builder);
        this.actorNameText.setText(TextUtils.notNullString((Object)builder.getActorName()));
        this.alwaysCheck.setSelection(builder.isAlways());
        this.assignConsoleSupportCheck.setSelection(builder.isAssignConsoleSupport());
        this.actionFilter.setText(TextUtils.notNullString((Object)builder.getFilter()));
        this.upToDatePolicy.select(builder.getUpToDatePolicy().ordinal());
        switch (builder.getUpToDatePolicy()) {
            case COUNT: {
                this.fileCountText.setText(String.valueOf(builder.getProductFileCount()));
                this.additionalFileCountText.setText("");
                break;
            }
            case MAPPER: {
                this.fileCountText.setText("");
                this.additionalFileCountText.setText(String.valueOf(builder.getProductFileCount()));
                break;
            }
            default: {
                this.fileCountText.setText("");
                this.additionalFileCountText.setText("");
            }
        }
        this.refreshFileCountFields();
        this.prodAliasText.setText(TextUtils.notNullString((Object)builder.getProductAlias()));
        IPath prodBasePath = builder.getProductBase();
        this.prodBaseText.setText(TextUtils.notNullString((Object)(prodBasePath == null ? null : prodBasePath.toOSString())));
        CSpecEditorUtils.copyAndSortItems((Map<String, String>)builder.getActorProperties(), this.actorProperties);
        this.actorPropertiesEditor.refresh();
        CSpecEditorUtils.copyAndSortItems(builder.getProductPaths(), this.productPaths);
        this.productPathsEditor.refresh();
        CSpecEditorUtils.copyAndSortItems((Collection)this.actionArtifacts.get(builder), this.productArtifacts, CSpecEditorUtils.getAttributeComparator());
        this.createProductArtifactsCopy();
        this.productArtifactsEditor.refresh();
        this.chooseProductPathsButton(this.productPaths.size() > 0 || this.productArtifacts.size() == 0);
        CSpecEditorUtils.copyAndSortItems((Map<String, String>)builder.getProperties(), this.properties);
        this.propertiesEditor.refresh();
        PrerequisitesBuilder prereqBuilder = builder.getPrerequisitesBuilder();
        this.prereqNameText.setText(TextUtils.notNullString((Object)prereqBuilder.getName()));
        IPath rebasePath = prereqBuilder.getPrerequisiteRebase();
        this.prereqRebasePathText.setText(TextUtils.notNullString((Object)(rebasePath == null ? null : rebasePath.toOSString())));
        CSpecEditorUtils.copyAndSortItems(prereqBuilder.getPrerequisites(), this.prerequisites, CSpecEditorUtils.getPrerequisiteComparator());
        this.prerequisitesEditor.refresh();
    }

    @Override
    protected void setRowValues(ActionBuilder builder) throws ValidatorException {
        super.setRowValues(builder);
        builder.setActorName(UiUtils.trimmedValue(this.actorNameText));
        builder.setAlways(this.alwaysCheck.getSelection());
        builder.setAssignConsoleSupport(this.assignConsoleSupportCheck.getSelection());
        String filterStr = UiUtils.trimmedValue(this.actionFilter);
        if (filterStr != null) {
            try {
                builder.setFilter(FilterFactory.newInstance((String)filterStr));
            }
            catch (InvalidSyntaxException e) {
                throw new ValidatorException(e.getMessage());
            }
        } else {
            builder.setFilter(null);
        }
        builder.setUpToDatePolicy(UpToDatePolicy.values()[this.upToDatePolicy.getSelectionIndex()]);
        Text validFileCountField = null;
        switch (builder.getUpToDatePolicy()) {
            case COUNT: {
                validFileCountField = this.fileCountText;
                break;
            }
            case MAPPER: {
                validFileCountField = this.additionalFileCountText;
            }
        }
        String fileCount = UiUtils.trimmedValue(validFileCountField);
        if (fileCount != null) {
            try {
                builder.setProductFileCount(Integer.valueOf(fileCount).intValue());
            }
            catch (NumberFormatException e) {
                throw new ValidatorException(String.valueOf(Messages.invalid_number) + ": " + fileCount);
            }
        }
        builder.setProductAlias(UiUtils.trimmedValue(this.prodAliasText));
        String prodBasePathString = UiUtils.trimmedValue(this.prodBaseText);
        IPath prodBasePath = null;
        if (prodBasePathString != null) {
            prodBasePath = Path.fromOSString((String)prodBasePathString);
        }
        builder.setProductBase(prodBasePath);
        ExpandingProperties props = builder.getActorProperties();
        if (props != null) {
            props.clear();
        }
        for (Property property : this.actorProperties) {
            builder.addActorProperty(property.getKey(), property.getValue(), true);
        }
        HashSet paths = builder.getProductPaths();
        if (paths != null) {
            paths.clear();
        }
        if (this.pathsButton.getSelection()) {
            for (PathWrapper path : this.productPaths) {
                IPath p = path.getPath();
                if (p == null) continue;
                builder.addProductPath(p);
            }
        }
        this.actionArtifacts.remove(builder);
        if (this.artifactsButton.getSelection() && this.productArtifacts.size() > 0) {
            ArrayList<ActionArtifactBuilder> list = new ArrayList<ActionArtifactBuilder>();
            for (ArtifactBuilder artifactBuilder : this.productArtifacts) {
                ((ActionArtifactBuilder)artifactBuilder).setActionName(builder.getName());
                list.add((ActionArtifactBuilder)artifactBuilder);
            }
            this.actionArtifacts.put(builder, list);
        }
        if ((props = builder.getProperties()) != null) {
            props.clear();
        }
        for (Property property : this.properties) {
            builder.addProperty(property.getKey(), property.getValue(), true);
        }
        PrerequisitesBuilder prereqBuilder = builder.getPrerequisitesBuilder();
        prereqBuilder.setName(UiUtils.trimmedValue(this.prereqNameText));
        String rebasePathString = UiUtils.trimmedValue(this.prereqRebasePathText);
        IPath rebasePath = null;
        if (rebasePathString != null) {
            rebasePath = Path.fromOSString((String)rebasePathString);
        }
        prereqBuilder.setPrerequisiteRebase(rebasePath);
        List prereqs = prereqBuilder.getPrerequisites();
        if (prereqs != null) {
            prereqs.clear();
        }
        for (PrerequisiteBuilder prerequisite : this.prerequisites) {
            PrerequisiteBuilder newPrerequisite = prereqBuilder.createPrerequisiteBuilder();
            newPrerequisite.initFrom((IPrerequisite)prerequisite.createPrerequisite());
            try {
                prereqBuilder.addPrerequisite(newPrerequisite);
            }
            catch (PrerequisiteAlreadyDefinedException e) {
                throw new ValidatorException(e.getMessage());
            }
        }
    }

    void showProductArtifact(ArtifactBuilder builder) {
        ArtifactBuilder foundBuilder = null;
        for (ArtifactBuilder item : this.productArtifacts) {
            if (!item.getName().equals(builder.getName())) continue;
            foundBuilder = item;
            break;
        }
        if (foundBuilder != null) {
            this.productArtifactsEditor.setFocus();
            this.productArtifactsEditor.show(foundBuilder);
        }
    }

    private void chooseProductPathsButton(boolean choose) {
        this.pathsButton.setSelection(choose);
        this.artifactsButton.setSelection(!choose);
        if (this.pathsButton.getEnabled()) {
            this.enableProductPathsEditor(choose);
        }
    }

    private Control createGeneralStackLayer(Composite stackComposite) {
        Composite geComposite = new Composite(stackComposite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        geComposite.setLayout((Layout)layout);
        EditorUtils.createHeaderLabel(geComposite, Messages.general, 2);
        UiUtils.createGridLabel(geComposite, Messages.name_with_colon, 1, 0, 0);
        this.setNameText(UiUtils.createGridText(geComposite, 1, 0, this.isReadOnly(), 0));
        UiUtils.createGridLabel(geComposite, Messages.public_with_colon, 1, 0, 0);
        this.setPublicCheck(UiUtils.createCheckButton(geComposite, null, this.isReadOnly(), null));
        UiUtils.createGridLabel(geComposite, Messages.actor_name_with_colon, 1, 0, 0);
        this.actorNameText = UiUtils.createGridText(geComposite, 1, 0, this.isReadOnly(), 0);
        this.actorNameText.addModifyListener((ModifyListener)this.FIELD_LISTENER);
        UiUtils.createGridLabel(geComposite, Messages.always_with_colon, 1, 0, 0);
        this.alwaysCheck = UiUtils.createCheckButton(geComposite, null, this.isReadOnly(), null);
        this.alwaysCheck.addSelectionListener((SelectionListener)this.FIELD_LISTENER);
        UiUtils.createGridLabel(geComposite, Messages.assign_console_support_with_colon, 1, 0, 0);
        this.assignConsoleSupportCheck = UiUtils.createCheckButton(geComposite, null, this.isReadOnly(), null);
        this.assignConsoleSupportCheck.addSelectionListener((SelectionListener)this.FIELD_LISTENER);
        UiUtils.createGridLabel(geComposite, Messages.filter_with_colon, 1, 0, 0);
        this.actionFilter = UiUtils.createGridText(geComposite, 1, 0, this.isReadOnly(), 0);
        this.actionFilter.addModifyListener((ModifyListener)this.FIELD_LISTENER);
        UiUtils.createGridLabel(geComposite, Messages.uptodate_policy, 1, 0, 0);
        this.upToDatePolicy = UiUtils.createGridEnumCombo(geComposite, 1, 0, UpToDatePolicy.values(), this.isReadOnly(), null, this.FIELD_LISTENER, 12);
        this.addFieldModifyListener(new IFieldModifyListener(){

            @Override
            public void modifyField(FieldModifyEvent e) {
                if (e.getOriginalEvent() instanceof ModifyEvent && ((ModifyEvent)e.getOriginalEvent()).getSource() == ActionsTable.this.upToDatePolicy) {
                    ActionsTable.this.refreshFileCountFields();
                }
            }
        });
        this.fileCountText = UiUtils.createLabeledText(geComposite, Messages.file_count, this.isReadOnly(), 0);
        this.fileCountText.addModifyListener((ModifyListener)this.FIELD_LISTENER);
        this.additionalFileCountText = UiUtils.createLabeledText(geComposite, Messages.additional_file_count, this.isReadOnly(), 0);
        this.additionalFileCountText.addModifyListener((ModifyListener)this.FIELD_LISTENER);
        UiUtils.createGridLabel(geComposite, Messages.prerequisites_alias_with_colon, 1, 0, 0);
        this.prereqNameText = UiUtils.createGridText(geComposite, 1, 0, this.isReadOnly(), 0);
        this.prereqNameText.addModifyListener((ModifyListener)this.FIELD_LISTENER);
        UiUtils.createGridLabel(geComposite, Messages.prerequisites_rebase_path_with_colon, 1, 0, 0);
        this.prereqRebasePathText = UiUtils.createGridText(geComposite, 1, 0, this.isReadOnly(), 0);
        this.prereqRebasePathText.addModifyListener((ModifyListener)this.FIELD_LISTENER);
        UiUtils.createEmptyLabel(geComposite);
        UiUtils.createEmptyLabel(geComposite);
        Label label = UiUtils.createGridLabel(geComposite, Messages.prerequisites_with_colon, 1, 0, 0);
        GridData gridData = new GridData(1, 1, false, false);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        PrerequisitesTable preTable = new PrerequisitesTable(this.getCSpecEditor(), this, this.prerequisites, (TopLevelAttributeBuilder)this.createNewRow().getPrerequisitesBuilder(), this.isReadOnly());
        preTable.addTableModifyListener(this.FIELD_LISTENER);
        this.prerequisitesEditor = new SimpleTableEditor<PrerequisiteBuilder>(geComposite, preTable, null, Messages.action_prerequisite_with_dash, null, null, 0);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.prerequisitesEditor.setLayoutData(gridData);
        geComposite.setData("focusControl", (Object)this.getNameText());
        return geComposite;
    }

    private void createProductArtifactsCopy() {
        int i = 0;
        while (i < this.productArtifacts.size()) {
            ActionArtifactBuilder builder = (ActionArtifactBuilder)this.productArtifacts.get(i);
            ActionArtifactBuilder newBuilder = this.getCSpecBuilder().createActionArtifactBuilder();
            newBuilder.initFrom((IAttribute)builder.createAttribute());
            this.productArtifacts.set(i, (ArtifactBuilder)newBuilder);
            ++i;
        }
    }

    private Control createProductsStackLayer(Composite stackComposite) {
        Composite composite = new Composite(stackComposite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        EditorUtils.createHeaderLabel(composite, Messages.products, 2);
        UiUtils.createGridLabel(composite, Messages.product_alias_with_colon, 1, 0, 0);
        this.prodAliasText = UiUtils.createGridText(composite, 1, 0, this.isReadOnly(), 0);
        this.prodAliasText.addModifyListener((ModifyListener)this.FIELD_LISTENER);
        UiUtils.createGridLabel(composite, Messages.product_base_path_with_colon, 1, 0, 0);
        this.prodBaseText = UiUtils.createGridText(composite, 1, 0, this.isReadOnly(), 0);
        this.prodBaseText.addModifyListener((ModifyListener)this.FIELD_LISTENER);
        UiUtils.createEmptyLabel(composite);
        UiUtils.createEmptyLabel(composite);
        this.pathsButton = new Button(composite, 16);
        this.pathsButton.setText(Messages.product_paths_with_colon);
        GridData gridData = new GridData(1, 1, false, false);
        gridData.horizontalSpan = 2;
        this.pathsButton.setLayoutData((Object)gridData);
        this.pathsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionsTable.this.enableProductPathsEditor(true);
            }
        });
        PathsTable table = new PathsTable(this.productPaths, this.isReadOnly());
        table.addTableModifyListener(this.FIELD_LISTENER);
        this.productPathsEditor = new SimpleTableEditor<PathWrapper>(composite, table, null, Messages.action_product_path_with_dash, null, null, 0);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.productPathsEditor.setLayoutData(gridData);
        UiUtils.createEmptyLabel(composite);
        UiUtils.createEmptyLabel(composite);
        this.artifactsButton = new Button(composite, 16);
        this.artifactsButton.setText(Messages.product_artifacts);
        gridData = new GridData(1, 1, false, false);
        gridData.horizontalSpan = 2;
        this.artifactsButton.setLayoutData((Object)gridData);
        this.artifactsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionsTable.this.enableProductPathsEditor(false);
            }
        });
        ArtifactsTable artifactsTable = new ArtifactsTable(this.getCSpecEditor(), this.productArtifacts, this.getCSpecBuilder(), this.isReadOnly()){

            @Override
            protected ArtifactBuilder createNewRow() {
                return this.getCSpecBuilder().createActionArtifactBuilder();
            }
        };
        artifactsTable.addTableModifyListener(this.FIELD_LISTENER);
        this.productArtifactsEditor = new TwoPagesTableEditor<ArtifactBuilder>(composite, artifactsTable, false, null, Messages.action_product_artifact_with_dash, null, null, 0);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.productArtifactsEditor.setLayoutData(gridData);
        composite.setData("focusControl", (Object)this.prodAliasText);
        return composite;
    }

    private Control createPropertiesStackLayer(Composite stackComposite) {
        Composite composite = new Composite(stackComposite, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        EditorUtils.createHeaderLabel(composite, Messages.general_properties, 1);
        PropertiesTable table = new PropertiesTable(this.properties, this.isReadOnly());
        table.addTableModifyListener(this.FIELD_LISTENER);
        this.propertiesEditor = new SimpleTableEditor<Property>(composite, table, null, Messages.action_properties_with_dash, null, null, 0);
        UiUtils.createEmptyLabel(composite);
        EditorUtils.createHeaderLabel(composite, Messages.actor_properties, 1);
        table = new PropertiesTable(this.actorProperties, this.isReadOnly());
        table.addTableModifyListener(this.FIELD_LISTENER);
        this.actorPropertiesEditor = new SimpleTableEditor<Property>(composite, table, null, Messages.action_actor_properties_with_dash, null, null, 0);
        return composite;
    }

    private void enableProductPathsEditor(boolean enable) {
        this.productPathsEditor.setEnabled(enable);
        this.productArtifactsEditor.setEnabled(!enable);
    }

    private void refreshFileCountFields() {
        boolean fileCountEnabled = false;
        boolean additionalFileCountEnabled = false;
        if (this.upToDatePolicy.isEnabled()) {
            switch (UpToDatePolicy.values()[this.upToDatePolicy.getSelectionIndex()]) {
                case COUNT: {
                    fileCountEnabled = true;
                    break;
                }
                case MAPPER: {
                    additionalFileCountEnabled = true;
                }
            }
        }
        this.fileCountText.setEnabled(fileCountEnabled);
        this.additionalFileCountText.setEnabled(additionalFileCountEnabled);
    }
}

