/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.editor.query;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.common.model.Documentation;
import org.eclipse.buckminster.core.cspec.IComponentRequest;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.ctype.AbstractComponentType;
import org.eclipse.buckminster.core.helpers.TextUtils;
import org.eclipse.buckminster.core.query.IComponentQuery;
import org.eclipse.buckminster.core.query.builder.AdvisorNodeBuilder;
import org.eclipse.buckminster.core.query.builder.ComponentQueryBuilder;
import org.eclipse.buckminster.core.query.model.ComponentQuery;
import org.eclipse.buckminster.core.query.model.MutableLevel;
import org.eclipse.buckminster.core.query.model.SourceLevel;
import org.eclipse.buckminster.core.version.VersionSelector;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.osgi.filter.FilterFactory;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.buckminster.runtime.URLUtils;
import org.eclipse.buckminster.sax.ISaxable;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.buckminster.ui.Messages;
import org.eclipse.buckminster.ui.SaveRunnable;
import org.eclipse.buckminster.ui.UiUtils;
import org.eclipse.buckminster.ui.editor.ArtifactType;
import org.eclipse.buckminster.ui.editor.EditorUtils;
import org.eclipse.buckminster.ui.editor.IDerivedEditorInput;
import org.eclipse.buckminster.ui.editor.Properties;
import org.eclipse.buckminster.ui.editor.PropertiesModifyEvent;
import org.eclipse.buckminster.ui.editor.PropertiesModifyListener;
import org.eclipse.buckminster.ui.editor.VersionDesignator;
import org.eclipse.buckminster.ui.editor.VersionDesignatorEvent;
import org.eclipse.buckminster.ui.editor.VersionDesignatorListener;
import org.eclipse.buckminster.ui.general.editor.structured.IActivator;
import org.eclipse.buckminster.ui.internal.DynamicTableLayout;
import org.eclipse.buckminster.ui.internal.ResolveJob;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorMatchingStrategy;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.part.EditorPart;
import org.osgi.framework.InvalidSyntaxException;

public class QueryEditor
extends EditorPart
implements IEditorMatchingStrategy {
    private static final IActivator EMPTY_ACTIVATOR = new IActivator(){

        @Override
        public void activate() {
        }
    };
    private static final int DONT_SAVE = -99;
    private CTabFolder tabFolder;
    private Text componentName;
    private Combo componentType;
    private VersionDesignator versionDesignator;
    private ComponentQueryBuilder componentQuery;
    private Button enableOverride;
    private boolean hasChanges;
    private Button resolveButton;
    private Button materializeButton;
    private Button externalSaveAsButton;
    private Button moveDownButton;
    private Button moveUpButton;
    private boolean mute;
    private Combo mutableLevel;
    private Text namePattern;
    private Text filter;
    private Combo category;
    private Text overlayFolder;
    private Button overlayBrowseButton;
    private Text wantedAttributes;
    private Button prune;
    private boolean needsRefresh;
    private Button newButton;
    private TableViewer nodeTable;
    private Button removeButton;
    private Button requestURLCheckbox;
    private Text requestURL;
    private Button propertyURLCheckbox;
    private Text propertyURL;
    private Tree nodeTree;
    private Combo sourceLevel;
    private Button skipComponent;
    private Button allowCircular;
    private Composite nodesStackComposite;
    private StackLayout nodesStackLayout;
    private HashMap<String, Control> nodesHash;
    private Button useTargetPlatform;
    private Button useWorkspace;
    private Button useMaterialization;
    private Button useResolutionService;
    private Text branchTagPath;
    private Text timestamp;
    private Text revision;
    private VersionDesignator versionOverride;
    private boolean continueOnError;
    private Properties nodeProperties;
    private Text nodeDocumentation;
    private Properties properties;
    private Text shortDesc;
    private Text documentation;
    private CTabItem xmlTab;
    private Text xml;
    private CompoundModifyListener compoundModifyListener;
    private final SimpleDateFormat timestampFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance(3, 3);
    private int lastSelectedNode = -1;
    private int lastEditedNode = -1;
    private boolean suppressModifyListener = false;

    public String commitChanges(IComponentRequest[] requestRet) {
        String name = UiUtils.trimmedValue(this.componentName);
        if (name == null) {
            return Messages.the_component_must_have_a_name;
        }
        String componentCategory = null;
        int idx = this.componentType.getSelectionIndex();
        if (idx >= 0 && (componentCategory = this.componentType.getItem(idx)).length() == 0) {
            componentCategory = null;
        }
        requestRet[0] = new ComponentRequest(name, componentCategory, this.versionDesignator.getVersionDesignator());
        return null;
    }

    public void createPartControl(Composite parent) {
        Composite topComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        topComposite.setLayout((Layout)layout);
        this.tabFolder = new CTabFolder(topComposite, 1024);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        CTabItem mainTab = new CTabItem(this.tabFolder, 0);
        mainTab.setText(Messages.main);
        mainTab.setControl(this.getMainTabControl(this.tabFolder));
        final CTabItem advisorTab = new CTabItem(this.tabFolder, 0);
        advisorTab.setText(Messages.advisor_nodes);
        advisorTab.setControl(this.getAdvisorTabControl((Composite)this.tabFolder));
        CTabItem propertiesTab = new CTabItem(this.tabFolder, 0);
        propertiesTab.setText(Messages.properties);
        propertiesTab.setControl(this.getPropertiesTabControl((Composite)this.tabFolder));
        CTabItem documentationTab = new CTabItem(this.tabFolder, 0);
        documentationTab.setText(Messages.documentation);
        documentationTab.setControl(this.getDocumentationTabControl((Composite)this.tabFolder));
        this.xmlTab = new CTabItem(this.tabFolder, 0);
        this.xmlTab.setText(Messages.xml_content);
        this.xmlTab.setControl(this.getXMLTabControl((Composite)this.tabFolder));
        this.tabFolder.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (QueryEditor.this.tabFolder.getSelection() == null) {
                    QueryEditor.this.tabFolder.setSelection(0);
                }
            }
        });
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(mainTab){
            private final IActivator NODE_TAB_ACTIVATOR;
            private CTabItem lastTab;
            {
                this.NODE_TAB_ACTIVATOR = new IActivator(){

                    @Override
                    public void activate() {
                        QueryEditor.this.tabFolder.setSelection(cTabItem2);
                    }
                };
                this.lastTab = cTabItem;
            }

            public void widgetSelected(SelectionEvent e) {
                if (this.lastTab != e.item && this.lastTab == advisorTab && !QueryEditor.this.saveLastNode(this.NODE_TAB_ACTIVATOR)) {
                    return;
                }
                if (QueryEditor.this.xmlTab == e.item) {
                    if (!QueryEditor.this.commitChangesToQuery()) {
                        MessageDialog.openWarning((Shell)QueryEditor.this.getSite().getShell(), null, (String)Messages.xml_content_was_not_updated_due_to_errors);
                    } else {
                        QueryEditor.this.xml.setText(QueryEditor.this.getCQueryXML());
                    }
                }
                this.lastTab = (CTabItem)e.item;
            }
        });
        this.createActionButtons(topComposite);
    }

    public void doExternalSaveAs() {
        if (!this.commitChangesToQuery()) {
            return;
        }
        FileDialog dlg = new FileDialog(this.getSite().getShell(), 8192);
        dlg.setFilterExtensions(new String[]{"*.cquery"});
        String location = dlg.open();
        if (location == null) {
            return;
        }
        this.saveToPath((IPath)new Path(location));
    }

    public void doSave(IProgressMonitor monitor) {
        if (!this.commitChangesToQuery()) {
            return;
        }
        IEditorInput input = this.getEditorInput();
        if (input == null) {
            return;
        }
        IPath path = input instanceof ILocationProvider ? ((ILocationProvider)input).getPath((Object)input) : ((IPathEditorInput)input).getPath();
        this.saveToPath(path);
    }

    public void doSaveAs() {
        IFile original;
        if (!this.commitChangesToQuery()) {
            return;
        }
        IEditorInput input = this.getEditorInput();
        if (input == null) {
            return;
        }
        SaveAsDialog dialog = new SaveAsDialog(this.getSite().getShell());
        IFile iFile = original = input instanceof IFileEditorInput ? ((IFileEditorInput)input).getFile() : null;
        if (original != null) {
            dialog.setOriginalFile(original);
        }
        if (dialog.open() == 1) {
            return;
        }
        IPath filePath = dialog.getResult();
        if (filePath == null) {
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IFile file = workspace.getRoot().getFile(filePath);
        this.saveToPath(file.getLocation());
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof ILocationProvider || input instanceof IPathEditorInput || input instanceof IURIEditorInput)) {
            throw new PartInitException(Messages.invalid_input);
        }
        this.setSite((IWorkbenchPartSite)site);
        if (input instanceof IURIEditorInput) {
            try {
                input = EditorUtils.getExternalFileEditorInput((IURIEditorInput)input, ArtifactType.CQUERY);
            }
            catch (Exception e) {
                throw new PartInitException(Messages.unable_to_open_editor, (Throwable)e);
            }
        }
        FileInputStream stream = null;
        try {
            try {
                IPath path = input instanceof ILocationProvider ? ((ILocationProvider)input).getPath(input) : ((IPathEditorInput)input).getPath();
                File file = path.toFile();
                this.componentQuery = new ComponentQueryBuilder();
                if (file.length() == 0L) {
                    String defaultName = file.getName();
                    if (defaultName.startsWith("bmqtmp-")) {
                        defaultName = "";
                    } else {
                        int lastDot = defaultName.lastIndexOf(46);
                        if (lastDot > 0) {
                            defaultName = defaultName.substring(0, lastDot);
                        }
                    }
                    this.componentQuery.setRootRequest((IComponentRequest)new ComponentRequest(defaultName, null, null));
                } else {
                    URL contextURL;
                    stream = new FileInputStream(file);
                    try {
                        contextURL = URLUtils.normalizeToURL((String)input.getToolTipText());
                    }
                    catch (MalformedURLException e) {
                        contextURL = file.toURI().toURL();
                    }
                    this.componentQuery.initFrom((IComponentQuery)ComponentQuery.fromStream((URL)contextURL, null, (InputStream)stream, (boolean)true));
                    CorePlugin.getLogger().debug("CQUERY Context URL set to %s", new Object[]{this.componentQuery.getContextURL()});
                }
                this.needsRefresh = true;
                if (this.componentName != null) {
                    this.refreshQuery();
                }
                this.setInputWithNotify((IEditorInput)input);
                this.setPartName(input.getName());
            }
            catch (Throwable e) {
                CoreException ce = BuckminsterException.wrap((Throwable)e);
                throw new PartInitException(Messages.unable_to_open_editor, (Throwable)ce);
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(stream);
            throw throwable;
        }
        IOUtils.close((Closeable)stream);
        this.compoundModifyListener = new CompoundModifyListener();
    }

    public boolean isDirty() {
        return this.hasChanges;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public boolean matches(IEditorReference editorRef, IEditorInput input) {
        IEditorInput editorInput;
        IEditorPart part = (IEditorPart)editorRef.getPart(false);
        if (part != null && (editorInput = part.getEditorInput()) != null) {
            IEditorInput originalEditorInput;
            if (editorInput.equals(input)) {
                return true;
            }
            if (editorInput instanceof IDerivedEditorInput && (originalEditorInput = ((IDerivedEditorInput)editorInput).getOriginalInput()).equals(input)) {
                return true;
            }
        }
        return false;
    }

    public void setFocus() {
        this.tabFolder.setFocus();
        if (this.needsRefresh) {
            this.refreshQuery();
        }
    }

    private AdvisorNodeBuilder addEmptyNode() {
        AdvisorNodeBuilder node = new AdvisorNodeBuilder();
        node.setNamePattern(Pattern.compile(""));
        this.componentQuery.addAdvisorNode(node);
        return node;
    }

    private void changeNodeSelection() {
        if (!this.saveLastNode()) {
            if (this.lastSelectedNode != -1) {
                this.nodeTable.getTable().setSelection(this.lastSelectedNode);
            }
            return;
        }
        this.nodeSelectionEvent();
    }

    private boolean commitChangesToQuery() {
        if (this.nodeTable.getControl().isVisible() && !this.saveLastNode()) {
            return false;
        }
        this.componentQuery.setResourceMapURL(UiUtils.trimmedValue(this.requestURL));
        this.componentQuery.setPropertiesURL(UiUtils.trimmedValue(this.propertyURL));
        this.properties.fillProperties(this.componentQuery.getDeclaredProperties());
        String doc = UiUtils.trimmedValue(this.shortDesc);
        this.componentQuery.setShortDesc(doc);
        doc = UiUtils.trimmedValue(this.documentation);
        try {
            this.componentQuery.setDocumentation(doc == null ? null : Documentation.parse((String)doc));
        }
        catch (CoreException e) {
            MessageDialog.openError((Shell)this.getSite().getShell(), null, (String)e.getMessage());
            return false;
        }
        ComponentRequest[] requestRet = new ComponentRequest[1];
        String error = this.commitChanges((IComponentRequest[])requestRet);
        if (error != null) {
            MessageDialog.openError((Shell)this.getSite().getShell(), null, (String)error);
            return false;
        }
        this.componentQuery.setRootRequest((IComponentRequest)requestRet[0]);
        return true;
    }

    private void createActionButtons(Composite parent) {
        Composite allButtonsBox = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        allButtonsBox.setLayout((Layout)layout);
        allButtonsBox.setLayoutData((Object)new GridData(4, 4, true, false));
        UiUtils.createCheckButton(allButtonsBox, Messages.continue_on_error, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryEditor.this.continueOnError = ((Button)e.getSource()).getSelection();
            }
        });
        Composite pressButtonsBox = new Composite(allButtonsBox, 0);
        layout = new GridLayout(3, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        pressButtonsBox.setLayout((Layout)layout);
        pressButtonsBox.setLayoutData((Object)new GridData(0x1000008, 4, true, false));
        this.resolveButton = UiUtils.createPushButton(pressButtonsBox, Messages.resolve_to_wizard, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryEditor.this.loadComponent(false);
            }
        });
        this.resolveButton.setLayoutData((Object)new GridData(4, 4, false, false));
        this.materializeButton = UiUtils.createPushButton(pressButtonsBox, Messages.resolve_and_materialize, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryEditor.this.loadComponent(true);
            }
        });
        this.materializeButton.setLayoutData((Object)new GridData(4, 4, false, false));
        this.externalSaveAsButton = UiUtils.createPushButton(pressButtonsBox, Messages.external_save_as, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryEditor.this.doExternalSaveAs();
            }
        });
        this.externalSaveAsButton.setLayoutData((Object)new GridData(4, 4, false, false));
    }

    private void createButtonBox(Composite parent) {
        Composite buttonBox = new Composite(parent, 0);
        buttonBox.setLayoutData((Object)new GridData(4, 4, false, false));
        FillLayout layout = new FillLayout(512);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.spacing = 3;
        buttonBox.setLayout((Layout)layout);
        Composite buttonBox1 = new Composite(buttonBox, 0);
        layout = new FillLayout(256);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonBox1.setLayout((Layout)layout);
        Composite buttonBox2 = new Composite(buttonBox, 0);
        layout = new FillLayout(256);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonBox2.setLayout((Layout)layout);
        this.newButton = UiUtils.createPushButton(buttonBox1, Messages.new_label, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryEditor.this.newNode();
            }
        });
        this.removeButton = UiUtils.createPushButton(buttonBox1, Messages.remove, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryEditor.this.removeNode();
            }
        });
        this.moveUpButton = UiUtils.createPushButton(buttonBox2, Messages.move_up, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryEditor.this.swapAndReselect(0, -1);
            }
        });
        this.moveDownButton = UiUtils.createPushButton(buttonBox2, Messages.move_down, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryEditor.this.swapAndReselect(1, 0);
            }
        });
    }

    private void createNodeFields(Composite parent) {
        this.createNodeTree(parent);
        this.createNodeStack(parent);
    }

    private void createNodeStack(Composite parent) {
        this.nodesStackComposite = new Composite(parent, 0);
        this.nodesStackComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.nodesStackLayout = new StackLayout();
        this.nodesStackLayout.marginWidth = 0;
        this.nodesStackLayout.marginHeight = 0;
        this.nodesStackComposite.setLayout((Layout)this.nodesStackLayout);
        this.nodesHash = new HashMap();
        Composite geComposite = new Composite(this.nodesStackComposite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        geComposite.setLayout((Layout)layout);
        this.nodesHash.put(Messages.general, (Control)geComposite);
        EditorUtils.createHeaderLabel(geComposite, Messages.general, 2);
        UiUtils.createGridLabel(geComposite, Messages.name_pattern_with_colon, 1, 0, 0);
        this.namePattern = UiUtils.createGridText(geComposite, 1, 0, 0);
        this.namePattern.addModifyListener((ModifyListener)this.compoundModifyListener);
        UiUtils.createGridLabel(geComposite, Messages.matched_component_type_with_colon, 1, 0, 0);
        this.category = UiUtils.createGridCombo(geComposite, 1, 0, null, null, 76);
        this.category.setItems(AbstractComponentType.getComponentTypeIDs((boolean)true));
        this.category.addModifyListener((ModifyListener)this.compoundModifyListener);
        UiUtils.createGridLabel(geComposite, Messages.filter_with_colon, 1, 0, 0);
        this.filter = UiUtils.createGridText(geComposite, 1, 0, 0);
        this.filter.addModifyListener((ModifyListener)this.compoundModifyListener);
        UiUtils.createGridLabel(geComposite, Messages.skip_component_with_colon, 1, 0, 0);
        this.skipComponent = UiUtils.createCheckButton(geComposite, null, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryEditor.this.enableDisableSkipSensitive(false);
            }
        });
        this.skipComponent.setLayoutData((Object)new GridData(4, 4, true, false));
        this.skipComponent.addSelectionListener((SelectionListener)this.compoundModifyListener);
        UiUtils.createGridLabel(geComposite, Messages.allow_circular_dependency_with_colon, 1, 0, 0);
        this.allowCircular = UiUtils.createCheckButton(geComposite, null, null);
        this.allowCircular.addSelectionListener((SelectionListener)this.compoundModifyListener);
        Composite aqComposite = new Composite(this.nodesStackComposite, 0);
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        aqComposite.setLayout((Layout)layout);
        this.nodesHash.put(Messages.attribute_qualification, (Control)aqComposite);
        EditorUtils.createHeaderLabel(aqComposite, Messages.attribute_qualification, 2);
        UiUtils.createGridLabel(aqComposite, Messages.attributes_with_colon, 1, 0, 0);
        this.wantedAttributes = UiUtils.createGridText(aqComposite, 0, 0, 0);
        this.wantedAttributes.addModifyListener((ModifyListener)this.compoundModifyListener);
        UiUtils.createGridLabel(aqComposite, Messages.prune_according_to_attributes_with_colon, 1, 0, 0);
        this.prune = UiUtils.createCheckButton(aqComposite, null, null);
        this.prune.addSelectionListener((SelectionListener)this.compoundModifyListener);
        Composite srComposite = new Composite(this.nodesStackComposite, 0);
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        srComposite.setLayout((Layout)layout);
        this.nodesHash.put(Messages.special_requirements, (Control)srComposite);
        EditorUtils.createHeaderLabel(srComposite, Messages.special_requirements, 2);
        UiUtils.createGridLabel(srComposite, Messages.mutable_level_with_colon, 1, 0, 0);
        this.mutableLevel = UiUtils.createGridEnumCombo(srComposite, 0, 0, MutableLevel.values(), null, null, 0);
        this.mutableLevel.addModifyListener((ModifyListener)this.compoundModifyListener);
        UiUtils.createGridLabel(srComposite, Messages.source_level_with_colon, 1, 0, 0);
        this.sourceLevel = UiUtils.createGridEnumCombo(srComposite, 0, 0, SourceLevel.values(), null, null, 0);
        this.sourceLevel.addModifyListener((ModifyListener)this.compoundModifyListener);
        Composite kuComposite = new Composite(this.nodesStackComposite, 0);
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        kuComposite.setLayout((Layout)layout);
        this.nodesHash.put(Messages.resolution_scope, (Control)kuComposite);
        EditorUtils.createHeaderLabel(kuComposite, Messages.resolution_scope, 2);
        UiUtils.createGridLabel(kuComposite, Messages.target_platform_with_colon, 1, 0, 0);
        this.useTargetPlatform = UiUtils.createCheckButton(kuComposite, null, null);
        this.useTargetPlatform.addSelectionListener((SelectionListener)this.compoundModifyListener);
        UiUtils.createGridLabel(kuComposite, Messages.workspace_with_colon, 1, 0, 0);
        this.useWorkspace = UiUtils.createCheckButton(kuComposite, null, null);
        this.useWorkspace.addSelectionListener((SelectionListener)this.compoundModifyListener);
        UiUtils.createGridLabel(kuComposite, Messages.materialization_with_colon, 1, 0, 0);
        this.useMaterialization = UiUtils.createCheckButton(kuComposite, null, null);
        this.useMaterialization.addSelectionListener((SelectionListener)this.compoundModifyListener);
        UiUtils.createGridLabel(kuComposite, Messages.resolution_service_with_colon, 1, 0, 0);
        this.useResolutionService = UiUtils.createCheckButton(kuComposite, null, null);
        this.useResolutionService.addSelectionListener((SelectionListener)this.compoundModifyListener);
        Composite scComposite = new Composite(this.nodesStackComposite, 0);
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        scComposite.setLayout((Layout)layout);
        this.nodesHash.put(Messages.selection_criteria, (Control)scComposite);
        EditorUtils.createHeaderLabel(scComposite, Messages.selection_criteria, 2);
        UiUtils.createGridLabel(scComposite, Messages.branch_or_tag_path_with_colon, 1, 0, 0);
        this.branchTagPath = UiUtils.createGridText(scComposite, 1, 0, 0);
        this.branchTagPath.addModifyListener((ModifyListener)this.compoundModifyListener);
        UiUtils.createGridLabel(scComposite, Messages.timestamp_with_colon, 1, 0, 0);
        this.timestamp = UiUtils.createGridText(scComposite, 1, 0, 0);
        this.timestamp.addModifyListener((ModifyListener)this.compoundModifyListener);
        UiUtils.createGridLabel(scComposite, Messages.revision_with_colon, 1, 0, 0);
        this.revision = UiUtils.createGridText(scComposite, 1, 0, 0);
        this.revision.addModifyListener((ModifyListener)this.compoundModifyListener);
        Composite ovComposite = new Composite(this.nodesStackComposite, 0);
        layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        ovComposite.setLayout((Layout)layout);
        this.nodesHash.put(Messages.override, (Control)ovComposite);
        EditorUtils.createHeaderLabel(ovComposite, Messages.override, 3);
        UiUtils.createGridLabel(ovComposite, Messages.override_version, 1, 0, 0);
        this.enableOverride = UiUtils.createCheckButton(ovComposite, null, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = ((Button)e.getSource()).getSelection();
                QueryEditor.this.versionOverride.setEnabled(selected);
            }
        });
        this.enableOverride.addSelectionListener((SelectionListener)this.compoundModifyListener);
        UiUtils.createEmptyLabel(ovComposite);
        this.versionOverride = new VersionDesignator(ovComposite);
        this.versionOverride.addVersionDesignatorListener(this.compoundModifyListener);
        Composite ofComposite = new Composite(this.nodesStackComposite, 0);
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        ofComposite.setLayout((Layout)layout);
        this.nodesHash.put(Messages.overlay_folder, (Control)ofComposite);
        EditorUtils.createHeaderLabel(ofComposite, Messages.overlay_folder_for_prototyping, 2);
        UiUtils.createGridLabel(ofComposite, Messages.folder_with_colon, 1, 0, 0);
        this.overlayFolder = UiUtils.createGridText(ofComposite, 1, 0, 0);
        this.overlayFolder.addModifyListener((ModifyListener)this.compoundModifyListener);
        Label label = UiUtils.createEmptyLabel(ofComposite);
        label.setLayoutData((Object)new GridData(4, 4, false, false));
        this.overlayBrowseButton = new Button(ofComposite, 8);
        this.overlayBrowseButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.overlayBrowseButton.setText(Messages.browse_with_dots);
        this.overlayBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                DirectoryDialog dlg = new DirectoryDialog(QueryEditor.this.getSite().getShell());
                QueryEditor.this.overlayFolder.setText(TextUtils.notNullString((Object)dlg.open()));
            }
        });
        Composite prComposite = new Composite(this.nodesStackComposite, 0);
        layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        prComposite.setLayout((Layout)layout);
        this.nodesHash.put(Messages.properties, (Control)prComposite);
        EditorUtils.createHeaderLabel(prComposite, Messages.properties, 1);
        this.nodeProperties = new Properties(prComposite, 0);
        this.nodeProperties.setLayoutData(new GridData(4, 4, true, true));
        this.nodeProperties.addPropertiesModifyListener(this.compoundModifyListener);
        Composite docComposite = new Composite(this.nodesStackComposite, 0);
        layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        docComposite.setLayout((Layout)layout);
        this.nodesHash.put(Messages.documentation, (Control)docComposite);
        EditorUtils.createHeaderLabel(docComposite, Messages.documentation, 1);
        this.nodeDocumentation = UiUtils.createGridText(docComposite, 1, 0, 2);
        this.nodeDocumentation.setLayoutData((Object)new GridData(4, 4, true, true));
        this.nodeDocumentation.addModifyListener((ModifyListener)this.compoundModifyListener);
        this.initStackControl();
    }

    private void createNodeTableGroup(Composite parent) {
        Composite componentTableGroup = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, true);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        componentTableGroup.setLayout((Layout)gl);
        componentTableGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        Table table = new Table(componentTableGroup, 68356);
        table.setHeaderVisible(false);
        String[] columnNames = new String[]{Messages.name_pattern, Messages.component_type, Messages.filter};
        int[] columnWeights = new int[]{10, 5, 5};
        table.setHeaderVisible(true);
        DynamicTableLayout layout = new DynamicTableLayout(50);
        int idx = 0;
        while (idx < columnNames.length) {
            TableColumn tableColumn = new TableColumn(table, 16384, idx);
            tableColumn.setText(columnNames[idx]);
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(columnWeights[idx], true));
            ++idx;
        }
        table.setLayout((Layout)layout);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.nodeTable = new TableViewer(table);
        this.nodeTable.setLabelProvider((IBaseLabelProvider)new AdvisorNodeLabelProvider());
        this.nodeTable.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.nodeTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                QueryEditor.this.changeNodeSelection();
            }
        });
        this.createButtonBox(componentTableGroup);
    }

    private void createNodeTree(Composite parent) {
        this.nodeTree = new Tree(parent, 2048);
        this.nodeTree.setLayoutData((Object)new GridData(4, 4, false, true));
        this.nodeTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.item != null) {
                    TreeItem item = (TreeItem)e.item;
                    ((QueryEditor)QueryEditor.this).nodesStackLayout.topControl = (Control)QueryEditor.this.nodesHash.get(item.getText());
                    QueryEditor.this.nodesStackComposite.layout();
                }
            }
        });
        TreeItem item = new TreeItem(this.nodeTree, 0);
        item.setText(Messages.general);
        item = new TreeItem(this.nodeTree, 0);
        item.setText(Messages.attribute_qualification);
        item = new TreeItem(this.nodeTree, 0);
        item.setText(Messages.special_requirements);
        item = new TreeItem(this.nodeTree, 0);
        item.setText(Messages.resolution_scope);
        item = new TreeItem(this.nodeTree, 0);
        item.setText(Messages.selection_criteria);
        item = new TreeItem(this.nodeTree, 0);
        item.setText(Messages.override);
        item = new TreeItem(this.nodeTree, 0);
        item.setText(Messages.overlay_folder);
        item = new TreeItem(this.nodeTree, 0);
        item.setText(Messages.properties);
        item = new TreeItem(this.nodeTree, 0);
        item.setText(Messages.documentation);
    }

    private void enableDisableButtonGroup() {
        Table table = this.nodeTable.getTable();
        int top = table.getItemCount();
        int idx = table.getSelectionIndex();
        this.newButton.setText(Messages.new_label);
        this.removeButton.setEnabled(idx >= 0);
        this.moveUpButton.setEnabled(idx > 0);
        this.moveDownButton.setEnabled(idx >= 0 && idx < top - 1);
        boolean disableFields = this.getSelectionIndex() == -1;
        this.namePattern.setEnabled(!disableFields);
        this.filter.setEnabled(!disableFields);
        this.category.setEnabled(!disableFields);
        this.skipComponent.setEnabled(!disableFields);
        this.nodeDocumentation.setEnabled(!disableFields);
        this.enableDisableSkipSensitive(disableFields);
    }

    private void enableDisableSkipSensitive(boolean forceDisable) {
        boolean enableRest = !forceDisable && !this.skipComponent.getSelection();
        this.allowCircular.setEnabled(enableRest);
        this.overlayFolder.setEnabled(enableRest);
        this.overlayBrowseButton.setEnabled(enableRest);
        this.wantedAttributes.setEnabled(enableRest);
        this.prune.setEnabled(enableRest);
        this.mutableLevel.setEnabled(enableRest);
        this.sourceLevel.setEnabled(enableRest);
        this.useTargetPlatform.setEnabled(enableRest);
        this.useWorkspace.setEnabled(enableRest);
        this.useMaterialization.setEnabled(enableRest);
        this.useResolutionService.setEnabled(enableRest);
        this.branchTagPath.setEnabled(enableRest);
        this.timestamp.setEnabled(enableRest);
        this.revision.setEnabled(enableRest);
        this.enableOverride.setEnabled(enableRest);
        this.versionOverride.setEnabled(enableRest && this.enableOverride.getSelection());
        this.nodeProperties.setEnabled(enableRest);
    }

    private Control getAdvisorTabControl(Composite parent) {
        Composite tabComposite = EditorUtils.getNamedTabComposite(parent, Messages.advisor_nodes);
        Composite advisorComposite = new Composite(tabComposite, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        advisorComposite.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 4, true, true);
        advisorComposite.setLayoutData((Object)gridData);
        this.createNodeTableGroup(advisorComposite);
        this.createNodeFields(advisorComposite);
        return EditorUtils.getOptimizedControl(tabComposite);
    }

    private String getCQueryXML() {
        String cqueryXML = "";
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Utils.serialize((ISaxable)this.componentQuery.createComponentQuery(), (OutputStream)baos);
            cqueryXML = baos.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cqueryXML;
    }

    private Control getDocumentationTabControl(Composite parent) {
        Composite tabComposite = EditorUtils.getNamedTabComposite(parent, Messages.documentation);
        Composite descComposite = new Composite(tabComposite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        descComposite.setLayout((Layout)layout);
        descComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        UiUtils.createGridLabel(descComposite, Messages.short_description_with_colon, 1, 0, 0);
        this.shortDesc = UiUtils.createGridText(descComposite, 1, 0, 0, this.compoundModifyListener);
        Label label = UiUtils.createGridLabel(descComposite, Messages.documentation_with_colon, 1, 0, 0);
        label.setLayoutData((Object)new GridData(4, 1, false, false));
        this.documentation = UiUtils.createGridText(descComposite, 1, 0, 514, this.compoundModifyListener);
        this.documentation.setLayoutData((Object)new GridData(4, 4, true, true));
        return EditorUtils.getOptimizedControl(tabComposite);
    }

    private Control getMainTabControl(CTabFolder parent) {
        Composite tabComposite = EditorUtils.getNamedTabComposite((Composite)parent, Messages.main);
        Composite nameComposite = new Composite(tabComposite, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginRight = 8;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        nameComposite.setLayout((Layout)layout);
        nameComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        Label label = UiUtils.createGridLabel(nameComposite, Messages.component_name_with_colon, 1, 0, 0);
        int labelWidth = label.computeSize((int)-1, (int)-1).x + 5;
        GridData gridData = new GridData(4, 4, false, false);
        gridData.widthHint = labelWidth;
        label.setLayoutData((Object)gridData);
        this.componentName = UiUtils.createGridText(nameComposite, 2, 0, 0, this.compoundModifyListener);
        UiUtils.createGridLabel(nameComposite, Messages.component_type_with_colon, 1, 0, 0);
        this.componentType = UiUtils.createGridCombo(nameComposite, 1, 0, null, null, 76);
        this.componentType.setItems(AbstractComponentType.getComponentTypeIDs((boolean)true));
        this.componentType.addModifyListener((ModifyListener)this.compoundModifyListener);
        UiUtils.createEmptyPanel(nameComposite);
        int textWidth = this.componentType.computeSize((int)-1, (int)-1).x;
        gridData = (GridData)this.componentType.getLayoutData();
        gridData.widthHint = textWidth;
        this.componentType.setLayoutData((Object)gridData);
        Group versionGroup = new Group(tabComposite, 0);
        versionGroup.setText(Messages.version);
        layout = new GridLayout(3, false);
        versionGroup.setLayout((Layout)layout);
        versionGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.versionDesignator = new VersionDesignator((Composite)versionGroup);
        this.versionDesignator.addVersionDesignatorListener(this.compoundModifyListener);
        Label control = this.versionDesignator.getVersionDsTypeLabel();
        gridData = (GridData)control.getLayoutData();
        gridData.widthHint = labelWidth - layout.marginWidth - 3;
        control.setLayoutData((Object)gridData);
        control = this.versionDesignator.getVersionDsTypeCombo();
        gridData = (GridData)control.getLayoutData();
        gridData.widthHint = textWidth;
        control.setLayoutData((Object)gridData);
        Group propertiesGroup = new Group(tabComposite, 0x400000);
        propertiesGroup.setText(Messages.properties);
        layout = new GridLayout(2, false);
        propertiesGroup.setLayout((Layout)layout);
        propertiesGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.propertyURLCheckbox = UiUtils.createCheckButton((Composite)propertiesGroup, Messages.user_properties, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                if (!button.getSelection()) {
                    QueryEditor.this.propertyURL.setText("");
                }
            }
        });
        gridData = new GridData(1, 0x1000000, false, false);
        gridData.horizontalSpan = 2;
        this.propertyURLCheckbox.setLayoutData((Object)gridData);
        label = UiUtils.createGridLabel((Composite)propertiesGroup, Messages.properties_with_colon, 1, labelWidth - layout.marginWidth - 3, 0);
        Composite propertiesComposite = new Composite((Composite)propertiesGroup, 0);
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        propertiesComposite.setLayout((Layout)layout);
        propertiesComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.propertyURL = UiUtils.createGridText(propertiesComposite, 1, 0, 0, this.compoundModifyListener);
        Button browseButton = new Button(propertiesComposite, 8);
        browseButton.setLayoutData((Object)new GridData(4, 4, false, false));
        browseButton.setText(Messages.browse_with_dots);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                FileDialog dlg = new FileDialog(QueryEditor.this.getSite().getShell());
                dlg.setFilterExtensions(new String[]{"*.properties"});
                String name = dlg.open();
                if (name == null) {
                    return;
                }
                try {
                    QueryEditor.this.propertyURL.setText(TextUtils.notNullString((Object)new URL(name)));
                }
                catch (MalformedURLException e) {
                    try {
                        QueryEditor.this.propertyURL.setText(TextUtils.notNullString((Object)new File(name).toURI().toURL()));
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
        });
        this.propertyURLCheckbox.addSelectionListener((SelectionListener)new CheckboxSelectionListener(new Control[]{label, this.propertyURL, browseButton}));
        Group rmapGroup = new Group(tabComposite, 0x400000);
        rmapGroup.setText(Messages.resource_map);
        layout = new GridLayout(2, false);
        rmapGroup.setLayout((Layout)layout);
        rmapGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.requestURLCheckbox = UiUtils.createCheckButton((Composite)rmapGroup, Messages.use_resource_map, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                if (!button.getSelection()) {
                    QueryEditor.this.requestURL.setText("");
                }
            }
        });
        gridData = new GridData(1, 0x1000000, false, false);
        gridData.horizontalSpan = 2;
        this.requestURLCheckbox.setLayoutData((Object)gridData);
        label = UiUtils.createGridLabel((Composite)rmapGroup, Messages.rmap_url_with_colon, 1, labelWidth - layout.marginWidth - 3, 0);
        Composite rmapComposite = new Composite((Composite)rmapGroup, 0);
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        rmapComposite.setLayout((Layout)layout);
        rmapComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.requestURL = UiUtils.createGridText(rmapComposite, 1, 0, 0, this.compoundModifyListener);
        browseButton = new Button(rmapComposite, 8);
        browseButton.setLayoutData((Object)new GridData(4, 4, false, false));
        browseButton.setText(Messages.browse_with_dots);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                FileDialog dlg = new FileDialog(QueryEditor.this.getSite().getShell());
                dlg.setFilterExtensions(new String[]{"*.rmap"});
                String name = dlg.open();
                if (name == null) {
                    return;
                }
                try {
                    QueryEditor.this.requestURL.setText(TextUtils.notNullString((Object)new URL(name)));
                }
                catch (MalformedURLException e) {
                    try {
                        QueryEditor.this.requestURL.setText(TextUtils.notNullString((Object)new File(name).toURI().toURL()));
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
        });
        this.requestURLCheckbox.addSelectionListener((SelectionListener)new CheckboxSelectionListener(new Control[]{label, this.requestURL, browseButton}));
        return EditorUtils.getOptimizedControl(tabComposite);
    }

    private Control getPropertiesTabControl(Composite parent) {
        Composite tabComposite = EditorUtils.getNamedTabComposite(parent, Messages.properties);
        this.properties = new Properties(tabComposite, 0);
        this.properties.addPropertiesModifyListener(this.compoundModifyListener);
        return EditorUtils.getOptimizedControl(tabComposite);
    }

    private AdvisorNodeBuilder getSelectedNode() {
        int idx = this.nodeTable.getTable().getSelectionIndex();
        return idx >= 0 ? (AdvisorNodeBuilder)this.nodeTable.getElementAt(idx) : null;
    }

    private int getSelectionIndex() {
        return this.nodeTable.getTable().getSelectionIndex();
    }

    private Control getXMLTabControl(Composite parent) {
        Composite tabComposite = EditorUtils.getNamedTabComposite(parent, Messages.xml_content);
        Composite xmlComposite = new Composite(tabComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        xmlComposite.setLayout((Layout)layout);
        xmlComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.xml = UiUtils.createGridText(xmlComposite, 1, 0, 778, null);
        this.xml.setLayoutData((Object)new GridData(4, 4, true, true));
        return EditorUtils.getOptimizedControl(tabComposite);
    }

    private void initStackControl() {
        this.nodeTree.setSelection(this.nodeTree.getItem(0));
        this.nodesStackLayout.topControl = this.nodesHash.get(this.nodeTree.getItem(0).getText());
        this.nodesStackComposite.layout();
    }

    private void loadComponent(boolean materialize) {
        if (!this.commitChangesToQuery()) {
            return;
        }
        try {
            ResolveJob resolveJob = new ResolveJob(this.componentQuery.createComponentQuery(), materialize, this.getSite(), this.continueOnError);
            resolveJob.schedule();
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), null, null, (IStatus)e.getStatus());
        }
    }

    private void newNode() {
        if (!this.saveLastNode()) {
            return;
        }
        AdvisorNodeBuilder node = this.addEmptyNode();
        this.refreshList();
        this.selectRow(node);
        this.setDirty(true);
        this.nodeSelectionEvent();
    }

    private void nodeSelectionEvent() {
        this.updateLastNode();
        this.refreshNodeFields();
        this.enableDisableButtonGroup();
        this.initStackControl();
        this.namePattern.setFocus();
    }

    private void refreshList() {
        this.nodeTable.setInput((Object)this.componentQuery.getAdvisoryNodes());
    }

    private void refreshNodeFields() {
        try {
            this.suppressModifyListener = true;
            AdvisorNodeBuilder node = this.getSelectedNode();
            if (node == null) {
                node = new AdvisorNodeBuilder();
            }
            this.allowCircular.setSelection(node.allowCircularDependency());
            this.namePattern.setText(TextUtils.notNullString((Object)node.getNamePattern()));
            this.filter.setText(TextUtils.notNullString((Object)node.getFilter()));
            this.category.select(this.category.indexOf(TextUtils.notNullString((Object)node.getComponentTypeID())));
            this.overlayFolder.setText(TextUtils.notNullString((Object)node.getOverlayFolder()));
            this.wantedAttributes.setText(TextUtils.notNullString((Object)TextUtils.concat((Collection)node.getAttributes(), (String)",")));
            this.prune.setSelection(node.isPrune());
            this.mutableLevel.select(this.mutableLevel.indexOf(node.getMutableLevel().toString()));
            this.sourceLevel.select(this.sourceLevel.indexOf(node.getSourceLevel().toString()));
            this.skipComponent.setSelection(node.skipComponent());
            this.useTargetPlatform.setSelection(node.isUseTargetPlatform());
            this.useWorkspace.setSelection(node.isUseWorkspace());
            this.useMaterialization.setSelection(node.isUseMaterialization());
            this.useResolutionService.setSelection(node.isUseRemoteResolution());
            this.branchTagPath.setText(TextUtils.notNullString((Object)VersionSelector.toString((VersionSelector[])node.getBranchTagPath())));
            this.revision.setText(TextUtils.notNullString((Object)node.getRevision()));
            Date ts = node.getTimestamp();
            this.timestamp.setText(ts == null ? "" : this.timestampFormat.format(ts));
            VersionRange vs = node.getVersionOverride();
            boolean enableOverrideFlag = vs != null;
            this.enableOverride.setSelection(enableOverrideFlag);
            this.versionOverride.setEnabled(enableOverrideFlag);
            this.versionOverride.refreshValues(vs);
            this.nodeProperties.setProperties(node.getProperties());
            this.nodeProperties.refreshList();
            Documentation doc = node.getDocumentation();
            this.nodeDocumentation.setText(TextUtils.notNullString((Object)(doc == null ? null : doc.toString())));
        }
        finally {
            this.suppressModifyListener = false;
        }
    }

    private void refreshQuery() {
        this.setDirty(false);
        this.mute = true;
        try {
            ComponentRequest request = this.componentQuery.getRootRequest();
            this.componentName.setText(TextUtils.notNullString((Object)request.getName()));
            this.componentType.select(this.componentType.indexOf(TextUtils.notNullString((Object)request.getComponentTypeID())));
            this.versionDesignator.refreshValues(request.getVersionRange());
            String string = TextUtils.notNullString((Object)this.componentQuery.getPropertiesURL());
            this.propertyURL.setText(string);
            this.propertyURLCheckbox.setSelection(string.length() > 0);
            this.propertyURLCheckbox.notifyListeners(13, new Event());
            string = TextUtils.notNullString((Object)this.componentQuery.getResourceMapURL());
            this.requestURL.setText(string);
            this.requestURLCheckbox.setSelection(string.length() > 0);
            this.requestURLCheckbox.notifyListeners(13, new Event());
            this.properties.setProperties(this.componentQuery.getDeclaredProperties());
            this.shortDesc.setText(TextUtils.notNullString((Object)this.componentQuery.getShortDesc()));
            Documentation doc = this.componentQuery.getDocumentation();
            this.documentation.setText(TextUtils.notNullString((Object)(doc == null ? "" : doc.toString())));
            this.refreshList();
            this.properties.refreshList();
            this.needsRefresh = false;
            this.nodeSelectionEvent();
        }
        finally {
            this.mute = false;
        }
    }

    private void removeNode() {
        AdvisorNodeBuilder node = this.getSelectedNode();
        if (node != null) {
            int last_idx = this.getSelectionIndex();
            this.componentQuery.removeAdvisorNode(node);
            this.setDirty(true);
            this.lastEditedNode = -99;
            this.refreshList();
            if (this.componentQuery.getAdvisoryNodes().size() > last_idx) {
                this.nodeTable.getTable().setSelection(last_idx);
            } else if (this.componentQuery.getAdvisoryNodes().size() > 0) {
                this.nodeTable.getTable().setSelection(last_idx - 1);
            } else {
                this.nodeTable.getTable().deselectAll();
            }
            this.nodeSelectionEvent();
        }
    }

    private boolean saveLastNode() {
        return this.saveLastNode(EMPTY_ACTIVATOR);
    }

    private boolean saveLastNode(IActivator failureActivator) {
        if (this.lastEditedNode != -1 && this.lastEditedNode != -99) {
            return this.saveNode(this.lastEditedNode, failureActivator);
        }
        return true;
    }

    private boolean saveNode(int nodeIdx, IActivator failureActivator) {
        String tmp;
        AdvisorNodeBuilder node = (AdvisorNodeBuilder)this.nodeTable.getElementAt(nodeIdx);
        boolean isNewNode = false;
        if (node == null) {
            node = new AdvisorNodeBuilder();
            isNewNode = true;
        }
        boolean refreshListNeeded = false;
        String patternStr = UiUtils.trimmedValue(this.namePattern);
        String categoryStr = this.category.getItem(this.category.getSelectionIndex());
        if (categoryStr.length() == 0) {
            categoryStr = null;
        }
        String filterStr = UiUtils.trimmedValue(this.filter);
        if (patternStr == null && filterStr == null && categoryStr == null) {
            failureActivator.activate();
            MessageDialog.openError((Shell)this.getSite().getShell(), null, (String)Messages.name_pattern_component_type_or_filter_must_be_set);
            return false;
        }
        Pattern pattern = null;
        if (patternStr != null) {
            try {
                pattern = Pattern.compile(patternStr);
            }
            catch (PatternSyntaxException e) {
                failureActivator.activate();
                MessageDialog.openError((Shell)this.getSite().getShell(), null, (String)e.getMessage());
                return false;
            }
        }
        Filter nodeFilter = null;
        if (filterStr != null) {
            try {
                nodeFilter = FilterFactory.newInstance((String)filterStr);
            }
            catch (InvalidSyntaxException e) {
                failureActivator.activate();
                MessageDialog.openError((Shell)this.getSite().getShell(), null, (String)e.getMessage());
                return false;
            }
        }
        if (!(Trivial.equalsAllowNull((Object)pattern, (Object)node.getNamePattern()) && Trivial.equalsAllowNull((Object)this.category, (Object)node.getComponentTypeID()) && Trivial.equalsAllowNull((Object)nodeFilter, (Object)node.getFilter()))) {
            AdvisorNodeBuilder patternEqual = this.componentQuery.getNodeByCriteria(pattern, categoryStr, nodeFilter);
            if (patternEqual != null) {
                failureActivator.activate();
                if (!MessageDialog.openQuestion((Shell)this.getSite().getShell(), null, (String)Messages.overwrite_existing_node_with_same_criteria)) {
                    return false;
                }
                this.componentQuery.removeAdvisorNode(patternEqual);
            }
            refreshListNeeded = true;
        }
        node.setNamePattern(pattern);
        node.setFilter(nodeFilter);
        node.setComponentTypeID(categoryStr);
        node.setAllowCircularDependency(this.allowCircular.getSelection());
        boolean override = this.enableOverride.getSelection();
        VersionRange versionOverrideRange = null;
        if (override) {
            try {
                versionOverrideRange = this.versionOverride.getDirectVersionDesignator();
            }
            catch (CoreException e1) {
                failureActivator.activate();
                ErrorDialog.openError((Shell)this.getSite().getShell(), null, null, (IStatus)e1.getStatus());
                return false;
            }
        }
        try {
            tmp = UiUtils.trimmedValue(this.overlayFolder);
            node.setOverlayFolder(tmp == null ? null : URLUtils.normalizeToURL((String)tmp));
        }
        catch (Exception e) {
            failureActivator.activate();
            MessageDialog.openError((Shell)this.getSite().getShell(), null, (String)e.getMessage());
            return false;
        }
        node.setSkipComponent(this.skipComponent.getSelection());
        node.getAttributes().clear();
        tmp = UiUtils.trimmedValue(this.wantedAttributes);
        if (tmp != null) {
            String[] stringArray = tmp.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String attribute = stringArray[n2];
                node.addAttribute(attribute);
                ++n2;
            }
        }
        node.setPrune(this.prune.getSelection());
        int idx = this.mutableLevel.getSelectionIndex();
        node.setMutableLevel(idx >= 0 ? MutableLevel.values()[idx] : null);
        idx = this.sourceLevel.getSelectionIndex();
        node.setSourceLevel(idx >= 0 ? SourceLevel.values()[idx] : null);
        node.setUseTargetPlatform(this.useTargetPlatform.getSelection());
        node.setUseWorkspace(this.useWorkspace.getSelection());
        node.setUseMaterialization(this.useMaterialization.getSelection());
        node.setUseRemoteResolution(this.useResolutionService.getSelection());
        node.setBranchTagPath(VersionSelector.fromPath((String)UiUtils.trimmedValue(this.branchTagPath)));
        node.setRevision(UiUtils.trimmedValue(this.revision));
        tmp = UiUtils.trimmedValue(this.timestamp);
        if (tmp != null) {
            try {
                node.setTimestamp(this.timestampFormat.parse(tmp));
            }
            catch (ParseException e) {
                failureActivator.activate();
                MessageDialog.openError((Shell)this.getSite().getShell(), null, (String)(String.valueOf(Messages.timestamp_must_conform_to_format_with_colon) + this.timestampFormat.toPattern()));
                return false;
            }
        } else {
            node.setTimestamp(null);
        }
        node.setVersionOverride(versionOverrideRange);
        this.nodeProperties.fillProperties(node.getProperties());
        String doc = UiUtils.trimmedValue(this.nodeDocumentation);
        try {
            node.setDocumentation(doc == null ? null : Documentation.parse((String)doc));
        }
        catch (Exception e) {
            failureActivator.activate();
            MessageDialog.openError((Shell)this.getSite().getShell(), null, (String)e.getMessage());
            return false;
        }
        if (isNewNode) {
            this.componentQuery.addAdvisorNode(node);
            refreshListNeeded = true;
        }
        if (refreshListNeeded) {
            this.refreshList();
            this.nodeSelectionEvent();
        }
        this.enableDisableButtonGroup();
        return true;
    }

    private void saveToPath(IPath path) {
        try {
            SaveRunnable sr = new SaveRunnable((ISaxable)this.componentQuery.createComponentQuery(), path);
            this.getSite().getWorkbenchWindow().run(true, true, (IRunnableWithProgress)sr);
            this.setInputWithNotify(sr.getSavedInput());
            this.setDirty(false);
            this.setPartName(path.lastSegment());
            this.firePropertyChange(1);
        }
        catch (InvocationTargetException e) {
            CoreException t = BuckminsterException.wrap((Throwable)e);
            String msg = String.valueOf(Messages.unable_to_save_file_0) + path;
            CorePlugin.getLogger().error((Throwable)t, msg, new Object[0]);
            ErrorDialog.openError((Shell)this.getSite().getShell(), null, (String)msg, (IStatus)t.getStatus());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean selectRow(AdvisorNodeBuilder node) {
        int idx = this.componentQuery.getAdvisoryNodes().indexOf(node);
        if (idx == -1) {
            return false;
        }
        this.nodeTable.getTable().setSelection(idx);
        return true;
    }

    private void setDirty(boolean flag) {
        if (this.mute || this.hasChanges == flag) {
            return;
        }
        this.hasChanges = flag;
        this.firePropertyChange(257);
    }

    private void swapAndReselect(int idxOffset, int selectionOffset) {
        if (!this.saveLastNode()) {
            return;
        }
        Table table = this.nodeTable.getTable();
        int idx = table.getSelectionIndex() + idxOffset;
        if (idx <= 0) {
            return;
        }
        List nl = this.componentQuery.getAdvisoryNodes();
        if (idx >= nl.size()) {
            return;
        }
        nl.set(idx - 1, nl.set(idx, (AdvisorNodeBuilder)nl.get(idx - 1)));
        this.refreshList();
        table.select(idx + selectionOffset);
        this.nodeSelectionEvent();
        this.setDirty(true);
    }

    private void updateLastNode() {
        if (this.getSelectionIndex() != -1) {
            this.lastSelectedNode = this.getSelectionIndex();
        }
        this.lastEditedNode = this.getSelectionIndex();
    }

    class AdvisorNodeLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        AdvisorNodeLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String lbl;
            AdvisorNodeBuilder node = (AdvisorNodeBuilder)element;
            switch (columnIndex) {
                case 0: {
                    lbl = node.getNamePattern() == null ? "" : node.getNamePattern().toString();
                    break;
                }
                case 1: {
                    lbl = node.getComponentTypeID();
                    break;
                }
                case 2: {
                    lbl = node.getFilter() == null ? "" : node.getFilter().toString();
                    break;
                }
                default: {
                    lbl = null;
                }
            }
            return lbl;
        }
    }

    class CheckboxSelectionListener
    extends SelectionAdapter {
        private Control[] controlsToEnable;

        public CheckboxSelectionListener(Control[] controlsToEnable) {
            this.controlsToEnable = controlsToEnable;
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            boolean enable = button.getSelection();
            Control[] controlArray = this.controlsToEnable;
            int n = this.controlsToEnable.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.setEnabled(enable);
                ++n2;
            }
        }
    }

    class CompoundModifyListener
    implements VersionDesignatorListener,
    ModifyListener,
    PropertiesModifyListener,
    SelectionListener {
        CompoundModifyListener() {
        }

        @Override
        public void modifyProperties(PropertiesModifyEvent e) {
            if (!QueryEditor.this.suppressModifyListener) {
                QueryEditor.this.setDirty(true);
            }
        }

        public void modifyText(ModifyEvent e) {
            if (!QueryEditor.this.suppressModifyListener) {
                QueryEditor.this.setDirty(true);
            }
        }

        @Override
        public void modifyVersionDesignator(VersionDesignatorEvent e) {
            if (!QueryEditor.this.suppressModifyListener) {
                QueryEditor.this.setDirty(true);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            if (!QueryEditor.this.suppressModifyListener) {
                QueryEditor.this.setDirty(true);
            }
        }
    }
}

