/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.general.editor.simple;

import java.util.List;
import org.eclipse.buckminster.ui.UiUtils;
import org.eclipse.buckminster.ui.general.editor.IValidator;
import org.eclipse.buckminster.ui.general.editor.Table;
import org.eclipse.buckminster.ui.general.editor.TableModifyEventType;
import org.eclipse.buckminster.ui.general.editor.ValidatorException;
import org.eclipse.buckminster.ui.general.editor.simple.ISimpleTable;
import org.eclipse.buckminster.ui.general.editor.simple.IWidgetin;
import org.eclipse.buckminster.ui.general.editor.simple.WidgetWrapper;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public abstract class SimpleTable<T>
extends Table<T>
implements ISimpleTable<T> {
    private static IValidator emptyValidator = new IValidator(){

        @Override
        public void validate(Object ... arg) {
        }
    };

    public static IValidator createNotEmptyStringValidator(String exceptionMessage) {
        return new NotEmptyStringValidator(exceptionMessage);
    }

    public static IValidator getEmptyValidator() {
        return emptyValidator;
    }

    public SimpleTable(List<T> data, boolean readOnly) {
        super(data, readOnly);
    }

    @Override
    public void addRow(Object[] tableRow) throws ValidatorException {
        this.validateAllFields(tableRow);
        this.getRowValidator().validate(new Integer(-1), tableRow);
        T newTableRow = this.toRowClass(tableRow);
        this.getRows().add(newTableRow);
        this.notifyListeners(TableModifyEventType.ADD_ROW, this.getRows().size() - 1, newTableRow);
    }

    @Override
    public IWidgetin[] fillGrid(Composite parent, Object[] fieldValues) {
        ((GridLayout)parent.getLayout()).numColumns = 2;
        IWidgetin[] widgetins = new IWidgetin[this.getColumns()];
        int i = 0;
        while (i < this.getColumns()) {
            UiUtils.createGridLabel(parent, String.valueOf(this.getColumnHeaders()[i]) + ":", 1, 0, 0);
            widgetins[i] = this.getWidgetin(parent, i, fieldValues[i]);
            ++i;
        }
        return widgetins;
    }

    @Override
    public int getColumns() {
        return this.getColumnHeaders().length;
    }

    @Override
    public Object getEditorField(T t, int columnIndex) {
        Object[] array = this.toRowArray(t);
        int j = 0;
        int i = 0;
        while (i < this.getColumns()) {
            if (this.getColumnWeights()[i] != 0) {
                if (j == columnIndex) {
                    return array[i];
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    @Override
    public IValidator getFieldValidator(int idx) {
        return emptyValidator;
    }

    @Override
    public IValidator getRowValidator() {
        return emptyValidator;
    }

    @Override
    public void setRow(int row, Object[] tableRow) throws ValidatorException {
        this.validateAllFields(tableRow);
        this.getRowValidator().validate(row, tableRow);
        Object tableRowClass = this.getRows().get(row);
        this.updateRowClass(tableRowClass, tableRow);
        this.notifyListeners(TableModifyEventType.UPDATE_ROW, row, tableRowClass);
    }

    @Override
    public T toRowClass(Object[] args) throws ValidatorException {
        Object t = this.createRowClass();
        this.updateRowClass(t, args);
        return t;
    }

    protected IWidgetin getBooleanCheckBoxWidgetin(Composite parent, int idx, Boolean value) {
        return this.getBooleanCheckBoxWidgetin(parent, idx, value, Boolean.FALSE);
    }

    protected IWidgetin getBooleanCheckBoxWidgetin(Composite parent, final int idx, Boolean value, Boolean defaultValue) {
        final Button checkBox = UiUtils.createCheckButton(parent, null, this.isReadOnly(), null);
        final WidgetWrapper widgetin = new WidgetWrapper((Widget)checkBox);
        GridData data = new GridData(4, 0x1000000, false, false);
        checkBox.setLayoutData((Object)data);
        Boolean realValue = value == null ? defaultValue : value;
        checkBox.setSelection(realValue.booleanValue());
        checkBox.setData((Object)realValue);
        checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Boolean selectionValue = checkBox.getSelection();
                checkBox.setData((Object)selectionValue);
                SimpleTable.this.validateFieldInFieldListener(widgetin, SimpleTable.this.getFieldValidator(idx), selectionValue);
            }
        });
        return widgetin;
    }

    protected IWidgetin getComboWidgetin(Composite parent, final int idx, Object value, String[] items, int style) {
        final Combo combo = UiUtils.createGridCombo(parent, 0, 0, this.isReadOnly(), null, null, style);
        final WidgetWrapper widgetin = new WidgetWrapper((Widget)combo);
        combo.setItems(items);
        String stringValue = value == null ? "" : value.toString();
        combo.setText(stringValue);
        combo.setData((Object)stringValue);
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                combo.setData((Object)combo.getText());
                SimpleTable.this.validateFieldInFieldListener(widgetin, SimpleTable.this.getFieldValidator(idx), combo.getText());
            }
        });
        return widgetin;
    }

    protected IWidgetin getTextWidgetin(Composite parent, final int idx, Object value) {
        final Text text = UiUtils.createGridText(parent, 1, 0, this.isReadOnly(), 0, null);
        final WidgetWrapper widgetin = new WidgetWrapper((Widget)text);
        String stringValue = value == null ? "" : value.toString();
        text.setText(stringValue);
        text.setData((Object)stringValue);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                widgetin.setData(text.getText());
                SimpleTable.this.validateFieldInFieldListener(widgetin, SimpleTable.this.getFieldValidator(idx), text.getText());
            }
        });
        return widgetin;
    }

    protected IWidgetin getWidgetin(Composite parent, int idx, Object value) {
        return this.getTextWidgetin(parent, idx, value);
    }

    protected void validateFieldInFieldListener(IWidgetin fieldControl, IValidator fieldValidator, Object fieldValue) {
        String message = null;
        try {
            fieldValidator.validate(fieldValue);
        }
        catch (ValidatorException e1) {
            message = e1.getMessage();
        }
        Event event = new Event();
        event.text = message;
        fieldControl.notifyListeners(954814, event);
    }

    private void validateAllFields(Object[] tableRow) throws ValidatorException {
        int i = 0;
        while (i < this.getColumns()) {
            this.getFieldValidator(i).validate(tableRow[i]);
            ++i;
        }
    }

    private static class NotEmptyStringValidator
    implements IValidator {
        private String exceptionMessage;

        public NotEmptyStringValidator(String exceptionMessage) {
            this.exceptionMessage = exceptionMessage;
        }

        @Override
        public void validate(Object ... arg) throws ValidatorException {
            String string = (String)arg[0];
            if (string == null || string.length() == 0) {
                throw new ValidatorException(this.exceptionMessage);
            }
        }
    }
}

