/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.prefs;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class EnumFieldEditor
extends FieldEditor {
    private Combo combo;
    private Enum<?> value;
    private final Enum<?>[] enumValues;

    public EnumFieldEditor(String name, String labelText, Enum<?>[] enumValues, Composite parent) {
        this.enumValues = enumValues;
        this.init(name, labelText);
        this.createControl(parent);
    }

    public Combo getControl(Composite parent) {
        if (this.combo == null) {
            this.combo = new Combo(parent, 8);
            int top = this.enumValues.length;
            int idx = 0;
            while (idx < top) {
                this.combo.add(this.enumValues[idx].toString(), idx);
                ++idx;
            }
            this.combo.setFont(parent.getFont());
            this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    Enum oldValue = EnumFieldEditor.this.value;
                    EnumFieldEditor.this.value = EnumFieldEditor.this.getValueForName(EnumFieldEditor.this.combo.getText());
                    EnumFieldEditor.this.setPresentsDefaultValue(false);
                    EnumFieldEditor.this.fireValueChanged("field_editor_value", oldValue, EnumFieldEditor.this.value);
                }
            });
        }
        return this.combo;
    }

    public int getNumberOfControls() {
        return 2;
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        if (control != null) {
            ((GridData)control.getLayoutData()).horizontalSpan = numColumns - 1;
            numColumns = 1;
        }
        ((GridData)this.combo.getLayoutData()).horizontalSpan = numColumns;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        control.setLayoutData((Object)gd);
        control = this.getControl(parent);
        gd = new GridData();
        gd.horizontalSpan = numColumns;
        control.setLayoutData((Object)gd);
    }

    protected void doLoad() {
        this.updateComboForValue(this.getPreferenceStore().getInt(this.getPreferenceName()));
    }

    protected void doLoadDefault() {
        this.updateComboForValue(this.getPreferenceStore().getDefaultInt(this.getPreferenceName()));
    }

    protected void doStore() {
        if (this.value == null) {
            this.getPreferenceStore().setToDefault(this.getPreferenceName());
            return;
        }
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.value.ordinal());
    }

    protected Enum<?> getValueForName(String name) {
        int idx = this.enumValues.length;
        while (--idx >= 0) {
            Enum<?> enumValue = this.enumValues[idx];
            if (!enumValue.toString().equals(name)) continue;
            return enumValue;
        }
        return null;
    }

    protected void updateComboForValue(int ordinal) {
        int max = this.enumValues.length;
        if (ordinal < 0 || ordinal >= max) {
            if (this.enumValues.length == 0) {
                return;
            }
            this.value = this.enumValues[0];
        } else {
            this.value = this.enumValues[ordinal];
        }
        this.combo.setText(this.value.toString());
    }
}

