/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.wizards;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.commands.SetPreference;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.helpers.AccessibleByteArrayOutputStream;
import org.eclipse.buckminster.core.helpers.FileUtils;
import org.eclipse.buckminster.core.metadata.model.BillOfMaterials;
import org.eclipse.buckminster.core.mspec.builder.MaterializationSpecBuilder;
import org.eclipse.buckminster.core.mspec.model.MaterializationSpec;
import org.eclipse.buckminster.core.parser.IParserFactory;
import org.eclipse.buckminster.core.query.model.ComponentQuery;
import org.eclipse.buckminster.core.resolver.MainResolver;
import org.eclipse.buckminster.core.resolver.ResolutionContext;
import org.eclipse.buckminster.download.DownloadManager;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.buckminster.runtime.URLUtils;
import org.eclipse.buckminster.ui.Messages;
import org.eclipse.buckminster.ui.UiUtils;
import org.eclipse.buckminster.ui.wizards.AbstractQueryPage;
import org.eclipse.buckminster.ui.wizards.QueryWizard;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SelectBOMPage
extends AbstractQueryPage {
    private Label topComponentLabel;
    private Text fileNameText;
    private Text topComponent;
    private Button loadButton;
    private URL bomOrMSpecURL;

    public SelectBOMPage(IStructuredSelection selection) {
        super("");
        IPath location;
        Object selected;
        if (selection != null && selection.size() == 1 && (selected = selection.getFirstElement()) instanceof IFile && (location = ((IFile)selected).getLocation()) != null) {
            try {
                this.bomOrMSpecURL = location.toFile().toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    @Override
    public void pageIsShowing() {
        QueryWizard qw = this.getQueryWizard();
        if (this.bomOrMSpecURL != null && !qw.hasBOM()) {
            this.loadBomOrMSpec();
            if (this.bomOrMSpecURL != null) {
                this.fileNameText.setText(this.bomOrMSpecURL.toString());
            }
        }
    }

    public void setErrorMessage(String message) {
        QueryWizard qw = this.getQueryWizard();
        if (message != null) {
            this.bomOrMSpecURL = null;
            qw.resetBOM();
        }
        super.setErrorMessage(message);
        if (qw.hasBOM()) {
            if (!this.isPageComplete()) {
                try {
                    this.topComponent.setText(qw.getBOM().getViewName());
                    this.topComponentLabel.setVisible(true);
                    this.topComponent.setVisible(true);
                    this.setPageComplete(true);
                }
                catch (CoreException e) {
                    this.displayException(e);
                    qw.resetBOM();
                }
            }
        } else if (this.isPageComplete()) {
            this.topComponentLabel.setVisible(false);
            this.topComponent.setVisible(false);
            this.setPageComplete(false);
        }
    }

    @Override
    protected Composite createControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        Label lbl = new Label(composite, 0);
        lbl.setLayoutData((Object)new GridData(4, 4, false, false, 3, 1));
        lbl.setText(Messages.enter_url_of_mspec_bom_cquery);
        lbl.setToolTipText(Messages.enter_url_that_appoints_mspec_bom_cquery);
        this.fileNameText = new Text(composite, 2048);
        this.fileNameText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fileNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent me) {
                SelectBOMPage.this.setBomOrMSpecFile(UiUtils.trimmedValue((Text)me.widget));
            }
        });
        Button browseButton = UiUtils.createPushButton(composite, Messages.browse_with_dots, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                FileDialog dlg = new FileDialog(SelectBOMPage.this.getShell());
                dlg.setFilterExtensions(new String[]{"*.mspec", "*.cquery", "*.bom"});
                String name = dlg.open();
                if (name != null) {
                    SelectBOMPage.this.fileNameText.setText(name);
                }
            }
        });
        browseButton.setLayoutData((Object)new GridData(131072, 128, false, false));
        this.loadButton = UiUtils.createPushButton(composite, Messages.load, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                SelectBOMPage.this.loadBomOrMSpec();
            }
        });
        this.loadButton.setLayoutData((Object)new GridData(131072, 128, false, false));
        this.loadButton.setEnabled(false);
        this.topComponentLabel = new Label(composite, 0);
        this.topComponentLabel.setLayoutData((Object)new GridData(4, 4, false, false, 3, 1));
        this.topComponentLabel.setText(Messages.top_component_of_loaded_bom);
        this.topComponentLabel.setVisible(false);
        this.topComponent = new Text(composite, 2048);
        this.topComponent.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        this.topComponent.setEditable(false);
        this.topComponent.setVisible(false);
        this.setControl((Control)composite);
        this.setPageComplete(false);
        return composite;
    }

    void loadBomOrMSpec() {
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    URL urlToParse = SelectBOMPage.this.bomOrMSpecURL;
                    InputStream input = null;
                    monitor.beginTask(null, 100);
                    try {
                        try {
                            BillOfMaterials bom;
                            ComponentQuery cquery;
                            IPath newTpLocation;
                            MaterializationSpec mspec;
                            IParserFactory pf;
                            QueryWizard wizard;
                            AccessibleByteArrayOutputStream byteBld;
                            block16: {
                                MaterializationSpecBuilder mspecBld;
                                block15: {
                                    byteBld = new AccessibleByteArrayOutputStream();
                                    wizard = SelectBOMPage.this.getQueryWizard();
                                    mspecBld = wizard.getMaterializationSpec();
                                    DownloadManager.readInto((URL)urlToParse, null, (OutputStream)byteBld, (IProgressMonitor)MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)20));
                                    input = byteBld.getInputStream();
                                    pf = CorePlugin.getDefault().getParserFactory();
                                    mspec = null;
                                    String path = urlToParse.getPath();
                                    if (!path.endsWith(".cquery") && !path.endsWith(".bom")) {
                                        try {
                                            mspec = (MaterializationSpec)pf.getMaterializationSpecParser(true).parse(urlToParse.toString(), input);
                                        }
                                        catch (CoreException e) {
                                            if (!urlToParse.getPath().endsWith(".mspec")) break block15;
                                            throw e;
                                        }
                                    }
                                }
                                MonitorUtils.worked((IProgressMonitor)monitor, (int)5);
                                newTpLocation = null;
                                if (mspec != null) {
                                    mspecBld.initFrom(mspec);
                                    urlToParse = mspec.getResolvedURL();
                                    byteBld.reset();
                                    DownloadManager.readInto((URL)urlToParse, null, (OutputStream)byteBld, (IProgressMonitor)MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)20));
                                    newTpLocation = mspec.getInstallLocation();
                                } else {
                                    mspecBld.setURL(urlToParse.toString());
                                    MonitorUtils.worked((IProgressMonitor)monitor, (int)20);
                                }
                                input = byteBld.getInputStream();
                                cquery = null;
                                if (!urlToParse.getPath().endsWith(".bom")) {
                                    try {
                                        cquery = ComponentQuery.fromStream((URL)urlToParse, null, (InputStream)input, (boolean)true);
                                    }
                                    catch (CoreException e) {
                                        if (!urlToParse.getPath().endsWith(".cquery")) break block16;
                                        throw e;
                                    }
                                }
                            }
                            MonitorUtils.worked((IProgressMonitor)monitor, (int)5);
                            if (newTpLocation != null) {
                                SetPreference.set((String)"targetPlatformPath", (String)((String)ExpandingProperties.expand((Map)RMContext.getGlobalPropertyAdditions(), (Object)newTpLocation.toPortableString(), (int)0)));
                            }
                            if (cquery != null) {
                                ResolutionContext ctx = mspec == null ? new ResolutionContext(cquery) : new ResolutionContext(mspec, cquery);
                                MainResolver resolver = new MainResolver(ctx);
                                resolver.getContext().setContinueOnError(true);
                                bom = resolver.resolve(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)40));
                            } else {
                                input = byteBld.getInputStream();
                                bom = (BillOfMaterials)pf.getBillOfMaterialsParser(true).parse(urlToParse.toString(), input);
                                MonitorUtils.worked((IProgressMonitor)monitor, (int)40);
                            }
                            wizard.setBOM(bom);
                            MonitorUtils.worked((IProgressMonitor)monitor, (int)10);
                        }
                        catch (Throwable e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtils.close(input);
                        monitor.done();
                        throw throwable;
                    }
                    IOUtils.close((Closeable)input);
                    monitor.done();
                }
            });
            this.setErrorMessage(null);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception e) {
            this.displayException(BuckminsterException.wrap((Throwable)e));
        }
    }

    void setBomOrMSpecFile(String bomFile) {
        URL url;
        URL oldBomOrMSPecURL = this.bomOrMSpecURL;
        this.bomOrMSpecURL = null;
        if (bomFile == null) {
            this.setErrorMessage(null);
            this.loadButton.setEnabled(false);
            return;
        }
        try {
            url = URLUtils.normalizeToURL((String)bomFile);
            url = FileLocator.toFileURL((URL)url);
        }
        catch (IOException e) {
            this.setErrorMessage(Messages.invalid_url_or_filename);
            this.loadButton.setEnabled(false);
            return;
        }
        File file = FileUtils.getFile((URL)url);
        if (file == null) {
            String path = url.getPath();
            if (path == null || path.length() == 0 || path.endsWith("/")) {
                this.setErrorMessage(Messages.url_path_is_not_valid);
                this.loadButton.setEnabled(false);
            } else {
                this.bomOrMSpecURL = url;
                this.loadButton.setEnabled(true);
                this.setErrorMessage(null);
            }
        } else {
            this.loadButton.setEnabled(false);
            if (file.isFile() && file.canRead()) {
                this.bomOrMSpecURL = url;
                if (oldBomOrMSPecURL == null || !oldBomOrMSPecURL.toExternalForm().equals(this.bomOrMSpecURL.toExternalForm())) {
                    this.loadBomOrMSpec();
                }
            } else {
                this.setErrorMessage(Messages.file_does_not_exist);
            }
        }
    }
}

