/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.bytecode.transformation.asm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.javaflow.bytecode.transformation.asm.ContinuationMethodAdapter;
import org.apache.commons.javaflow.bytecode.transformation.asm.MonitoringFrame;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.SimpleVerifier;
import org.objectweb.asm.tree.analysis.SourceInterpreter;
import org.objectweb.asm.tree.analysis.SourceValue;

public class ContinuationMethodAnalyzer
extends MethodNode
implements Opcodes {
    protected final String className;
    protected final ClassVisitor cv;
    protected final MethodVisitor mv;
    protected final List<Label> labels = new ArrayList<Label>();
    protected final List<MethodInsnNode> nodes = new ArrayList<MethodInsnNode>();
    protected final List<MethodInsnNode> methods = new ArrayList<MethodInsnNode>();
    protected Analyzer analyzer;
    public int stackRecorderVar;

    public ContinuationMethodAnalyzer(String className, ClassVisitor cv, MethodVisitor mv, int access, String name, String desc, String signature, String[] exceptions) {
        super(262144, access, name, desc, signature, exceptions);
        this.className = className;
        this.cv = cv;
        this.mv = mv;
    }

    public int getIndex(AbstractInsnNode node) {
        return this.instructions.indexOf(node);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        MethodInsnNode mnode = new MethodInsnNode(opcode, owner, name, desc);
        if (opcode == 183 || "<init>".equals(name)) {
            this.methods.add(mnode);
        }
        if (this.needsFrameGuard(opcode, owner, name, desc)) {
            Label label = new Label();
            super.visitLabel(label);
            this.labels.add(label);
            this.nodes.add(mnode);
        }
        this.instructions.add((AbstractInsnNode)mnode);
    }

    public void visitEnd() {
        if (this.instructions.size() == 0 || this.labels.size() == 0) {
            this.accept(this.mv);
            return;
        }
        this.stackRecorderVar = this.maxLocals;
        try {
            this.moveNew();
            this.analyzer = new Analyzer((Interpreter)new SimpleVerifier(){

                protected Class<?> getClass(Type t) {
                    try {
                        if (t.getSort() == 9) {
                            return Class.forName(t.getDescriptor().replace('/', '.'), true, Thread.currentThread().getContextClassLoader());
                        }
                        return Class.forName(t.getClassName(), true, Thread.currentThread().getContextClassLoader());
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e.toString());
                    }
                }
            }){

                protected Frame newFrame(int nLocals, int nStack) {
                    return new MonitoringFrame(nLocals, nStack);
                }

                protected Frame newFrame(Frame src) {
                    return new MonitoringFrame(src);
                }

                public Frame[] analyze(String owner, MethodNode m) throws AnalyzerException {
                    Frame[] frames = super.analyze(owner, m);
                    for (int i = 0; i < m.instructions.size(); ++i) {
                        int opcode = m.instructions.get(i).getOpcode();
                        if (opcode != 194 && opcode != 195) continue;
                    }
                    return frames;
                }
            };
            this.analyzer.analyze(this.className, (MethodNode)this);
            this.accept(new ContinuationMethodAdapter(this));
        }
        catch (AnalyzerException ex) {
            ex.printStackTrace();
            this.accept(this.mv);
        }
    }

    void moveNew() throws AnalyzerException {
        SourceInterpreter i = new SourceInterpreter();
        Analyzer a = new Analyzer((Interpreter)i);
        a.analyze(this.className, (MethodNode)this);
        HashMap<AbstractInsnNode, MethodInsnNode> movable = new HashMap<AbstractInsnNode, MethodInsnNode>();
        Frame[] frames = a.getFrames();
        for (int j = 0; j < this.methods.size(); ++j) {
            MethodInsnNode mnode = this.methods.get(j);
            int n = this.instructions.indexOf((AbstractInsnNode)mnode);
            Frame f = frames[n];
            Type[] args = Type.getArgumentTypes((String)mnode.desc);
            SourceValue v = (SourceValue)f.getStack(f.getStackSize() - args.length - 1);
            Set insns = v.insns;
            for (AbstractInsnNode ins : insns) {
                AbstractInsnNode ins1;
                if (ins.getOpcode() == 187) {
                    movable.put(ins, mnode);
                    continue;
                }
                int n1 = this.instructions.indexOf(ins);
                if (ins.getOpcode() == 89) {
                    ins1 = this.instructions.get(n1 - 1);
                    if (ins1.getOpcode() != 187) continue;
                    movable.put(ins1, mnode);
                    continue;
                }
                if (ins.getOpcode() != 95) continue;
                ins1 = this.instructions.get(n1 - 1);
                AbstractInsnNode ins2 = this.instructions.get(n1 - 2);
                if (ins1.getOpcode() != 90 || ins2.getOpcode() != 187) continue;
                movable.put(ins2, mnode);
            }
        }
        int updateMaxStack = 0;
        for (Map.Entry e : movable.entrySet()) {
            Type type;
            int j;
            InsnList doNew;
            MethodInsnNode mnode;
            AbstractInsnNode node1 = (AbstractInsnNode)e.getKey();
            int n1 = this.instructions.indexOf(node1);
            AbstractInsnNode node2 = this.instructions.get(n1 + 1);
            AbstractInsnNode node3 = this.instructions.get(n1 + 2);
            int producer = node2.getOpcode();
            this.instructions.remove(node1);
            boolean requireDup = false;
            if (producer == 89) {
                this.instructions.remove(node2);
                requireDup = true;
            } else if (producer == 90) {
                this.instructions.remove(node2);
                this.instructions.remove(node3);
                requireDup = true;
            }
            MethodInsnNode nm = mnode = (MethodInsnNode)e.getValue();
            int varOffset = this.stackRecorderVar + 1;
            Type[] args = Type.getArgumentTypes((String)mnode.desc);
            if (args.length == 0) {
                doNew = new InsnList();
                doNew.add(node1);
                if (requireDup) {
                    doNew.add((AbstractInsnNode)new InsnNode(89));
                }
                this.instructions.insertBefore((AbstractInsnNode)nm, doNew);
                nm = doNew.getLast();
                continue;
            }
            if (args.length == 1 && args[0].getSize() == 1) {
                doNew = new InsnList();
                doNew.add(node1);
                if (requireDup) {
                    doNew.add((AbstractInsnNode)new InsnNode(89));
                    doNew.add((AbstractInsnNode)new InsnNode(93));
                    doNew.add((AbstractInsnNode)new InsnNode(88));
                    updateMaxStack = updateMaxStack < 2 ? 2 : updateMaxStack;
                } else {
                    doNew.add((AbstractInsnNode)new InsnNode(95));
                }
                this.instructions.insertBefore((AbstractInsnNode)nm, doNew);
                nm = doNew.getLast();
                continue;
            }
            if (args.length == 1 && args[0].getSize() == 2 || args.length == 2 && args[0].getSize() == 1 && args[1].getSize() == 1) {
                doNew = new InsnList();
                doNew.add(node1);
                if (requireDup) {
                    doNew.add((AbstractInsnNode)new InsnNode(89));
                    doNew.add((AbstractInsnNode)new InsnNode(94));
                    doNew.add((AbstractInsnNode)new InsnNode(88));
                    updateMaxStack = updateMaxStack < 2 ? 2 : updateMaxStack;
                } else {
                    doNew.add((AbstractInsnNode)new InsnNode(91));
                    doNew.add((AbstractInsnNode)new InsnNode(87));
                    updateMaxStack = updateMaxStack < 1 ? 1 : updateMaxStack;
                }
                this.instructions.insertBefore((AbstractInsnNode)nm, doNew);
                nm = doNew.getLast();
                continue;
            }
            doNew = new InsnList();
            for (j = args.length - 1; j >= 0; --j) {
                type = args[j];
                doNew.add((AbstractInsnNode)new VarInsnNode(type.getOpcode(54), varOffset));
                varOffset += type.getSize();
            }
            if (varOffset > this.maxLocals) {
                this.maxLocals = varOffset;
            }
            doNew.add(node1);
            if (requireDup) {
                doNew.add((AbstractInsnNode)new InsnNode(89));
            }
            for (j = 0; j < args.length; ++j) {
                type = args[j];
                doNew.add((AbstractInsnNode)new VarInsnNode(type.getOpcode(21), varOffset -= type.getSize()));
                if (type.getSort() != 10 && type.getSort() != 9) continue;
                updateMaxStack = updateMaxStack < 1 ? 1 : updateMaxStack;
                doNew.add((AbstractInsnNode)new InsnNode(1));
                doNew.add((AbstractInsnNode)new VarInsnNode(type.getOpcode(54), varOffset));
            }
            this.instructions.insertBefore((AbstractInsnNode)nm, doNew);
            nm = doNew.getLast();
        }
        this.maxStack += updateMaxStack;
    }

    boolean needsFrameGuard(int opcode, String owner, String name, String desc) {
        return opcode == 185 || opcode == 183 && !"<init>".equals(name) || opcode == 184 || opcode == 182;
    }
}

