/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.LazyFont;
import org.apache.fop.fonts.MultiByteFont;
import org.apache.fop.fonts.SingleByteFont;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.intermediate.AbstractIFPainter;
import org.apache.fop.render.intermediate.IFContext;
import org.apache.fop.render.intermediate.IFException;
import org.apache.fop.render.intermediate.IFState;
import org.apache.fop.render.intermediate.IFUtil;
import org.apache.fop.render.ps.PSBorderPainter;
import org.apache.fop.render.ps.PSDocumentHandler;
import org.apache.fop.render.ps.PSFontResource;
import org.apache.fop.render.ps.PSImageUtils;
import org.apache.fop.render.ps.PSRenderingContext;
import org.apache.fop.render.ps.PSRenderingMode;
import org.apache.fop.render.ps.PSRenderingUtil;
import org.apache.fop.traits.BorderProps;
import org.apache.fop.traits.RuleStyle;
import org.apache.fop.util.CharUtilities;
import org.apache.fop.util.HexEncoder;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageProcessingHints;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.apache.xmlgraphics.ps.PSResource;
import org.w3c.dom.Document;

public class PSPainter
extends AbstractIFPainter {
    private static Log log = LogFactory.getLog(PSPainter.class);
    private PSDocumentHandler documentHandler;
    private PSBorderPainter borderPainter;
    private boolean inTextMode = false;

    public PSPainter(PSDocumentHandler documentHandler) {
        this(documentHandler, IFState.create());
    }

    protected PSPainter(PSDocumentHandler documentHandler, IFState state) {
        this.documentHandler = documentHandler;
        this.borderPainter = new PSBorderPainter(documentHandler.gen);
        this.state = state;
    }

    protected IFContext getContext() {
        return this.documentHandler.getContext();
    }

    PSRenderingUtil getPSUtil() {
        return this.documentHandler.psUtil;
    }

    FontInfo getFontInfo() {
        return this.documentHandler.getFontInfo();
    }

    private PSGenerator getGenerator() {
        return this.documentHandler.gen;
    }

    public void startViewport(AffineTransform transform, Dimension size, Rectangle clipRect) throws IFException {
        try {
            PSGenerator generator = this.getGenerator();
            this.saveGraphicsState();
            generator.concatMatrix(PSPainter.toPoints((AffineTransform)transform));
        }
        catch (IOException ioe) {
            throw new IFException("I/O error in startViewport()", (Exception)ioe);
        }
        if (clipRect != null) {
            this.clipRect(clipRect);
        }
    }

    public void endViewport() throws IFException {
        try {
            this.restoreGraphicsState();
        }
        catch (IOException ioe) {
            throw new IFException("I/O error in endViewport()", (Exception)ioe);
        }
    }

    public void startGroup(AffineTransform transform) throws IFException {
        try {
            PSGenerator generator = this.getGenerator();
            this.saveGraphicsState();
            generator.concatMatrix(PSPainter.toPoints((AffineTransform)transform));
        }
        catch (IOException ioe) {
            throw new IFException("I/O error in startGroup()", (Exception)ioe);
        }
    }

    public void endGroup() throws IFException {
        try {
            this.restoreGraphicsState();
        }
        catch (IOException ioe) {
            throw new IFException("I/O error in endGroup()", (Exception)ioe);
        }
    }

    protected Map createDefaultImageProcessingHints(ImageSessionContext sessionContext) {
        Map hints = super.createDefaultImageProcessingHints(sessionContext);
        hints.put(ImageProcessingHints.TRANSPARENCY_INTENT, "ignore");
        return hints;
    }

    protected RenderingContext createRenderingContext() {
        PSRenderingContext psContext = new PSRenderingContext(this.getUserAgent(), this.getGenerator(), this.getFontInfo());
        return psContext;
    }

    protected void drawImageUsingImageHandler(ImageInfo info, Rectangle rect) throws ImageException, IOException {
        if (!this.getPSUtil().isOptimizeResources() || PSImageUtils.isImageInlined(info, (PSRenderingContext)this.createRenderingContext())) {
            super.drawImageUsingImageHandler(info, rect);
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Image " + info + " is embedded as a form later");
            }
            PSResource form = this.documentHandler.getFormForImage(info.getOriginalURI());
            PSImageUtils.drawForm(form, info, rect, this.getGenerator());
        }
    }

    public void drawImage(String uri, Rectangle rect) throws IFException {
        try {
            this.endTextObject();
        }
        catch (IOException ioe) {
            throw new IFException("I/O error in drawImage()", (Exception)ioe);
        }
        this.drawImageUsingURI(uri, rect);
    }

    public void drawImage(Document doc, Rectangle rect) throws IFException {
        try {
            this.endTextObject();
        }
        catch (IOException ioe) {
            throw new IFException("I/O error in drawImage()", (Exception)ioe);
        }
        this.drawImageUsingDocument(doc, rect);
    }

    public void clipRect(Rectangle rect) throws IFException {
        try {
            PSGenerator generator = this.getGenerator();
            this.endTextObject();
            generator.defineRect((double)rect.x / 1000.0, (double)rect.y / 1000.0, (double)rect.width / 1000.0, (double)rect.height / 1000.0);
            generator.writeln(generator.mapCommand("clip") + " " + generator.mapCommand("newpath"));
        }
        catch (IOException ioe) {
            throw new IFException("I/O error in clipRect()", (Exception)ioe);
        }
    }

    public void fillRect(Rectangle rect, Paint fill) throws IFException {
        if (fill == null) {
            return;
        }
        if (rect.width != 0 && rect.height != 0) {
            try {
                this.endTextObject();
                PSGenerator generator = this.getGenerator();
                if (fill != null) {
                    if (fill instanceof Color) {
                        generator.useColor((Color)fill);
                    } else {
                        throw new UnsupportedOperationException("Non-Color paints NYI");
                    }
                }
                generator.defineRect((double)rect.x / 1000.0, (double)rect.y / 1000.0, (double)rect.width / 1000.0, (double)rect.height / 1000.0);
                generator.writeln(generator.mapCommand("fill"));
            }
            catch (IOException ioe) {
                throw new IFException("I/O error in fillRect()", (Exception)ioe);
            }
        }
    }

    public void drawBorderRect(Rectangle rect, BorderProps top, BorderProps bottom, BorderProps left, BorderProps right) throws IFException {
        if (top != null || bottom != null || left != null || right != null) {
            try {
                this.endTextObject();
                if (this.getPSUtil().getRenderingMode() == PSRenderingMode.SIZE && this.hasOnlySolidBorders(top, bottom, left, right)) {
                    super.drawBorderRect(rect, top, bottom, left, right);
                } else {
                    this.borderPainter.drawBorders(rect, top, bottom, left, right);
                }
            }
            catch (IOException ioe) {
                throw new IFException("I/O error in drawBorderRect()", (Exception)ioe);
            }
        }
    }

    public void drawLine(Point start, Point end, int width, Color color, RuleStyle style) throws IFException {
        try {
            this.endTextObject();
            this.borderPainter.drawLine(start, end, width, color, style);
        }
        catch (IOException ioe) {
            throw new IFException("I/O error in drawLine()", (Exception)ioe);
        }
    }

    private Typeface getTypeface(String fontName) {
        if (fontName == null) {
            throw new NullPointerException("fontName must not be null");
        }
        Typeface tf = this.getFontInfo().getFonts().get(fontName);
        if (tf instanceof LazyFont) {
            tf = ((LazyFont)tf).getRealFont();
        }
        return tf;
    }

    protected void saveGraphicsState() throws IOException {
        this.endTextObject();
        this.getGenerator().saveGraphicsState();
    }

    protected void restoreGraphicsState() throws IOException {
        this.endTextObject();
        this.getGenerator().restoreGraphicsState();
    }

    protected void beginTextObject() throws IOException {
        if (!this.inTextMode) {
            PSGenerator generator = this.getGenerator();
            generator.saveGraphicsState();
            generator.writeln("BT");
            this.inTextMode = true;
        }
    }

    protected void endTextObject() throws IOException {
        if (this.inTextMode) {
            this.inTextMode = false;
            PSGenerator generator = this.getGenerator();
            generator.writeln("ET");
            generator.restoreGraphicsState();
        }
    }

    private String formatMptAsPt(PSGenerator gen, int value) {
        return gen.formatDouble((double)value / 1000.0);
    }

    public void drawText(int x, int y, int letterSpacing, int wordSpacing, int[][] dp, String text) throws IFException {
        try {
            if (this.state.getFontSize() == 0) {
                return;
            }
            PSGenerator generator = this.getGenerator();
            generator.useColor(this.state.getTextColor());
            this.beginTextObject();
            FontTriplet triplet = new FontTriplet(this.state.getFontFamily(), this.state.getFontStyle(), this.state.getFontWeight());
            String fontKey = this.getFontInfo().getInternalFontKey(triplet);
            if (fontKey == null) {
                throw new IFException("Font not available: " + triplet, null);
            }
            int sizeMillipoints = this.state.getFontSize();
            Typeface tf = this.getTypeface(fontKey);
            SingleByteFont singleByteFont = null;
            if (tf instanceof SingleByteFont) {
                singleByteFont = (SingleByteFont)tf;
            }
            Font font = this.getFontInfo().getFontInstance(triplet, sizeMillipoints);
            this.useFont(fontKey, sizeMillipoints);
            generator.writeln("1 0 0 -1 " + this.formatMptAsPt(generator, x) + " " + this.formatMptAsPt(generator, y) + " Tm");
            int textLen = text.length();
            int start = 0;
            if (singleByteFont != null) {
                int currentEncoding = -1;
                for (int i = 0; i < textLen; ++i) {
                    char c = text.charAt(i);
                    char mapped = tf.mapChar(c);
                    int encoding = mapped / 256;
                    if (currentEncoding == encoding) continue;
                    if (i > 0) {
                        this.writeText(text, start, i - start, letterSpacing, wordSpacing, dp, font, tf, false);
                    }
                    if (encoding == 0) {
                        this.useFont(fontKey, sizeMillipoints);
                    } else {
                        this.useFont(fontKey + "_" + Integer.toString(encoding), sizeMillipoints);
                    }
                    currentEncoding = encoding;
                    start = i;
                }
            } else {
                this.useFont(fontKey, sizeMillipoints);
            }
            this.writeText(text, start, textLen - start, letterSpacing, wordSpacing, dp, font, tf, tf instanceof MultiByteFont);
        }
        catch (IOException ioe) {
            throw new IFException("I/O error in drawText()", (Exception)ioe);
        }
    }

    private void writeText(String text, int start, int len, int letterSpacing, int wordSpacing, int[][] dp, Font font, Typeface tf, boolean multiByte) throws IOException {
        PSGenerator generator = this.getGenerator();
        int end = start + len;
        int initialSize = len;
        initialSize += initialSize / 2;
        boolean hasLetterSpacing = letterSpacing != 0;
        boolean needTJ = false;
        int lineStart = 0;
        StringBuffer accText = new StringBuffer(initialSize);
        StringBuffer sb = new StringBuffer(initialSize);
        int[] dx = IFUtil.convertDPToDX((int[][])dp);
        int dxl = dx != null ? dx.length : 0;
        for (int i = start; i < end; ++i) {
            int cw;
            char ch;
            char orgChar = text.charAt(i);
            int glyphAdjust = 0;
            if (CharUtilities.isFixedWidthSpace(orgChar)) {
                ch = font.mapChar(' ');
                cw = font.getCharWidth(orgChar);
                glyphAdjust = font.getCharWidth(ch) - cw;
            } else {
                if (wordSpacing != 0 && CharUtilities.isAdjustableSpace(orgChar)) {
                    glyphAdjust -= wordSpacing;
                }
                ch = font.mapChar(orgChar);
                cw = font.getCharWidth(orgChar);
            }
            if (dx != null && i < dxl - 1) {
                glyphAdjust -= dx[i + 1];
            }
            if (multiByte) {
                accText.append(HexEncoder.encode((char)ch));
            } else {
                char codepoint = (char)(ch % 256);
                PSGenerator.escapeChar(codepoint, accText);
            }
            if (glyphAdjust == 0) continue;
            needTJ = true;
            if (sb.length() == 0) {
                sb.append('[');
            }
            if (accText.length() > 0) {
                if (sb.length() - lineStart + accText.length() > 200) {
                    sb.append('\n');
                    lineStart = sb.length();
                }
                lineStart = this.writePostScriptString(sb, accText, multiByte, lineStart);
                sb.append(' ');
                accText.setLength(0);
            }
            sb.append(Integer.toString(glyphAdjust)).append(' ');
        }
        if (needTJ) {
            if (accText.length() > 0) {
                if (sb.length() - lineStart + accText.length() > 200) {
                    sb.append('\n');
                }
                this.writePostScriptString(sb, accText, multiByte);
            }
            if (hasLetterSpacing) {
                sb.append("] " + this.formatMptAsPt(generator, letterSpacing) + " ATJ");
            } else {
                sb.append("] TJ");
            }
        } else {
            this.writePostScriptString(sb, accText, multiByte);
            if (hasLetterSpacing) {
                StringBuffer spb = new StringBuffer();
                spb.append(this.formatMptAsPt(generator, letterSpacing)).append(" 0 ");
                sb.insert(0, spb.toString());
                sb.append(" " + generator.mapCommand("ashow"));
            } else {
                sb.append(" " + generator.mapCommand("show"));
            }
        }
        generator.writeln(sb.toString());
    }

    private void writePostScriptString(StringBuffer buffer, StringBuffer string, boolean multiByte) {
        this.writePostScriptString(buffer, string, multiByte, 0);
    }

    private int writePostScriptString(StringBuffer buffer, StringBuffer string, boolean multiByte, int lineStart) {
        buffer.append(multiByte ? (char)'<' : '(');
        int l = string.length();
        int index = 0;
        int maxCol = 200;
        buffer.append(string.substring(index, Math.min(index + maxCol, l)));
        index += maxCol;
        while (index < l) {
            if (!multiByte) {
                buffer.append('\\');
            }
            buffer.append('\n');
            lineStart = buffer.length();
            buffer.append(string.substring(index, Math.min(index + maxCol, l)));
            index += maxCol;
        }
        buffer.append(multiByte ? (char)'>' : ')');
        return lineStart;
    }

    private void useFont(String key, int size) throws IOException {
        PSFontResource res = this.documentHandler.getPSResourceForFontKey(key);
        PSGenerator generator = this.getGenerator();
        generator.useFont("/" + res.getName(), (float)size / 1000.0f);
        res.notifyResourceUsageOnPage(generator.getResourceTracker());
    }
}

