/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.util.Iterator;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.core.Ordered;

public class CustomScopeConfigurer
implements BeanFactoryPostProcessor,
Ordered {
    private int order = Integer.MAX_VALUE;
    private Map scopes;

    public void setScopes(Map scopes) {
        this.scopes = scopes;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (this.scopes != null) {
            Iterator it = this.scopes.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Object key = entry.getKey();
                if (!(key instanceof String)) {
                    throw new IllegalArgumentException("Invalid scope key [" + key + "]: only Strings allowed");
                }
                Object value = entry.getValue();
                if (!(value instanceof Scope)) {
                    throw new IllegalArgumentException("Mapped value [" + value + "] for scope key [" + key + "] is not of required type [" + Scope.class.getName() + "]");
                }
                beanFactory.registerScope((String)key, (Scope)value);
            }
        }
    }
}

