/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.util;

import java.util.Enumeration;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.castor.core.util.Assert;
import org.exolab.castor.xml.NamespacesStack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class StaxStreamHandler
extends DefaultHandler {
    private final XMLStreamWriter xmlStreamWriter;
    private NamespacesStack namespacesStack = new NamespacesStack();
    private boolean createNamespaceScope = true;

    public StaxStreamHandler(XMLStreamWriter xmlStreamWriter) {
        Assert.paramNotNull((Object)xmlStreamWriter, (String)"xmlStreamWriter");
        this.xmlStreamWriter = xmlStreamWriter;
    }

    public void startDocument() throws SAXException {
        try {
            this.xmlStreamWriter.writeStartDocument();
        }
        catch (XMLStreamException e) {
            this.convertToSAXException("Error occurred when writing the document start.", e);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.xmlStreamWriter.writeEndDocument();
            this.xmlStreamWriter.flush();
        }
        catch (XMLStreamException e) {
            this.convertToSAXException("Error occurred when writing the document end.", e);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.createNamespaceScope) {
            this.namespacesStack.addNewNamespaceScope();
            this.createNamespaceScope = false;
        }
        this.namespacesStack.addNamespace(prefix, uri);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            this.xmlStreamWriter.writeStartElement(qName);
            for (int i = 0; i < attributes.getLength(); ++i) {
                this.xmlStreamWriter.writeAttribute(attributes.getQName(i), attributes.getValue(i));
            }
            String defaultNamespace = this.namespacesStack.getDefaultNamespaceURI();
            if (defaultNamespace != null && defaultNamespace.length() > 0) {
                this.xmlStreamWriter.setDefaultNamespace(defaultNamespace);
            }
            Enumeration<String> enumeration = this.namespacesStack.getLocalNamespacePrefixes();
            while (enumeration.hasMoreElements()) {
                String prefix = enumeration.nextElement();
                this.xmlStreamWriter.writeNamespace(prefix, this.namespacesStack.getNamespaceURI(prefix));
            }
        }
        catch (XMLStreamException e) {
            this.convertToSAXException("Error occurred when writing the element start.", e);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            this.xmlStreamWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            this.convertToSAXException("Error occurred when writing the element end.", e);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        try {
            this.xmlStreamWriter.writeCharacters(ch, start, length);
        }
        catch (XMLStreamException e) {
            this.convertToSAXException("Error occurred when writing the white spaces.", e);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.xmlStreamWriter.writeCharacters(ch, start, length);
        }
        catch (XMLStreamException e) {
            this.convertToSAXException("Error occurred when writing the characters.", e);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        try {
            this.xmlStreamWriter.writeProcessingInstruction(target, data);
        }
        catch (XMLStreamException e) {
            this.convertToSAXException("Error occurred when writing the processing instruction.", e);
        }
    }

    private void convertToSAXException(String msg, XMLStreamException e) throws SAXException {
        throw new SAXException(msg, e);
    }
}

