/*
 * Decompiled with CFR 0.152.
 */
package org.passay;

import java.util.LinkedHashMap;
import java.util.Map;
import org.passay.MatchBehavior;
import org.passay.PasswordData;
import org.passay.Rule;
import org.passay.RuleResult;
import org.passay.RuleResultDetail;

public class WhitespaceRule
implements Rule {
    public static final String ERROR_CODE = "ILLEGAL_WHITESPACE";
    protected static final char[] CHARS = new char[]{'\t', '\n', '\u000b', '\f', '\r', ' '};
    protected boolean reportAllFailures;
    private final MatchBehavior matchBehavior;

    public WhitespaceRule() {
        this(MatchBehavior.Contains);
    }

    public WhitespaceRule(MatchBehavior behavior) {
        this(behavior, true);
    }

    public WhitespaceRule(MatchBehavior behavior, boolean reportAll) {
        this.matchBehavior = behavior;
        this.reportAllFailures = reportAll;
    }

    @Override
    public RuleResult validate(PasswordData passwordData) {
        RuleResult result = new RuleResult(true);
        String text = passwordData.getPassword();
        for (char c : CHARS) {
            if (!this.matchBehavior.match(text, c)) continue;
            result.setValid(false);
            result.getDetails().add(new RuleResultDetail(ERROR_CODE, this.createRuleResultDetailParameters(c)));
            if (!this.reportAllFailures) break;
        }
        return result;
    }

    protected Map<String, Object> createRuleResultDetailParameters(char c) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("whitespaceCharacter", Character.valueOf(c));
        m.put("matchBehavior", (Object)this.matchBehavior);
        return m;
    }

    public String toString() {
        return String.format("%s@%h::reportAllFailures=%s,matchBehavior=%s", new Object[]{this.getClass().getName(), this.hashCode(), this.reportAllFailures, this.matchBehavior});
    }
}

