/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.impl;

import java.util.HashMap;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.impl.Utils;
import org.zkoss.zk.ui.metainfo.ComponentInfo;
import org.zkoss.zk.ui.util.Composer;
import org.zkoss.zk.ui.util.ComposerExt;
import org.zkoss.zk.ui.util.FullComposer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiComposer<T extends Component>
implements Composer<T> {
    private final Composer<T>[] _cs;
    private boolean _fullOnly;

    public static Composer getComposer(Page page, Object[] ary) throws Exception {
        Composer[] cs;
        if (ary == null || ary.length == 0) {
            return null;
        }
        if (ary.length == 1) {
            return Utils.newComposer(page, ary[0]);
        }
        boolean ext = false;
        boolean full = false;
        if (ary instanceof Composer[]) {
            cs = (Composer[])ary;
            int j = cs.length;
            while (--j >= 0) {
                if (cs[j] instanceof ComposerExt) {
                    ext = true;
                    if (full) break;
                }
                if (!(cs[j] instanceof FullComposer)) continue;
                full = true;
                if (!ext) continue;
                break;
            }
        } else {
            cs = new Composer[ary.length];
            int j = ary.length;
            while (--j >= 0) {
                cs[j] = Utils.newComposer(page, ary[j]);
                ext = ext || cs[j] instanceof ComposerExt;
                full = full || cs[j] instanceof FullComposer;
            }
        }
        if (full) {
            if (ext) {
                return new MultiFullComposerExt(cs);
            }
            return new MultiFullComposer(cs);
        }
        if (ext) {
            return new MultiComposerExt(cs);
        }
        return new MultiComposer(cs);
    }

    public boolean setFullComposerOnly(boolean fullOnly) {
        boolean b = this._fullOnly;
        this._fullOnly = fullOnly;
        return b;
    }

    public boolean isFullComposerOnly() {
        return this._fullOnly;
    }

    private boolean shallInvoke(Composer composer) {
        return !this._fullOnly || composer instanceof FullComposer;
    }

    protected MultiComposer(Composer<T>[] cs) throws Exception {
        HashMap<String, Composer<T>> csMap = new HashMap<String, Composer<T>>();
        for (int j = 0; j < cs.length; ++j) {
            csMap.put(cs[j].getClass().toString(), cs[j]);
        }
        this._cs = csMap.values().toArray(new Composer[csMap.values().size()]);
    }

    @Override
    public void doAfterCompose(T comp) throws Exception {
        for (int j = 0; j < this._cs.length; ++j) {
            if (!this.shallInvoke(this._cs[j])) continue;
            this._cs[j].doAfterCompose(comp);
        }
    }

    public ComponentInfo doBeforeCompose(Page page, Component parent, ComponentInfo compInfo) throws Exception {
        for (int j = 0; j < this._cs.length; ++j) {
            if (!(this._cs[j] instanceof ComposerExt) || !this.shallInvoke(this._cs[j]) || (compInfo = ((ComposerExt)((Object)this._cs[j])).doBeforeCompose(page, parent, compInfo)) != null) continue;
            return null;
        }
        return compInfo;
    }

    public void doBeforeComposeChildren(T comp) throws Exception {
        for (int j = 0; j < this._cs.length; ++j) {
            if (!(this._cs[j] instanceof ComposerExt) || !this.shallInvoke(this._cs[j])) continue;
            ((ComposerExt)((Object)this._cs[j])).doBeforeComposeChildren(comp);
        }
    }

    public boolean doCatch(Throwable ex) throws Exception {
        for (int j = 0; j < this._cs.length; ++j) {
            if (!(this._cs[j] instanceof ComposerExt) || !this.shallInvoke(this._cs[j]) || !((ComposerExt)((Object)this._cs[j])).doCatch(ex)) continue;
            return true;
        }
        return false;
    }

    public void doFinally() throws Exception {
        for (int j = 0; j < this._cs.length; ++j) {
            if (!(this._cs[j] instanceof ComposerExt) || !this.shallInvoke(this._cs[j])) continue;
            ((ComposerExt)((Object)this._cs[j])).doFinally();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MultiFullComposerExt<T extends Component>
    extends MultiFullComposer<T>
    implements ComposerExt<T> {
        private MultiFullComposerExt(Composer<T>[] cs) throws Exception {
            super(cs);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MultiFullComposer<T extends Component>
    extends MultiComposer<T>
    implements FullComposer {
        private MultiFullComposer(Composer<T>[] cs) throws Exception {
            super(cs);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MultiComposerExt<T extends Component>
    extends MultiComposer<T>
    implements ComposerExt<T> {
        private MultiComposerExt(Composer<T>[] cs) throws Exception {
            super(cs);
        }
    }
}

