/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.converter;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Converter;
import org.zkoss.bind.sys.Binding;
import org.zkoss.bind.sys.PropertyBinding;
import org.zkoss.util.Locales;
import org.zkoss.util.TimeZones;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;

public class FormattedTimeConverter
implements Converter,
Serializable {
    private static final long serialVersionUID = 3505731684878632094L;

    public Object coerceToUi(Object val, Component comp, BindContext ctx) {
        String format = (String)ctx.getConverterArg("format");
        if (format == null) {
            throw new NullPointerException("format attribute not found");
        }
        Date date = (Date)val;
        return date == null ? null : FormattedTimeConverter.getLocalizedSimpleDateFormat(format).format(date);
    }

    public Object coerceToBean(Object val, Component comp, BindContext ctx) {
        String format = (String)ctx.getConverterArg("format");
        if (format == null) {
            throw new NullPointerException("format attribute not found");
        }
        String dateStr = (String)val;
        try {
            Date newDate;
            Date date = newDate = dateStr == null ? null : FormattedTimeConverter.getLocalizedSimpleDateFormat(format).parse(dateStr);
            if (newDate != null) {
                Calendar cal = Calendar.getInstance();
                cal.setTimeZone(TimeZones.getCurrent());
                cal.setTime(newDate);
                Binding b = ctx.getBinding();
                if (b instanceof PropertyBinding) {
                    int h = cal.get(11);
                    int m = cal.get(12);
                    int s = cal.get(13);
                    int ms = cal.get(14);
                    Object value = ctx.getBinder().getEvaluatorX().getValue(ctx, comp, ((PropertyBinding)b).getProperty());
                    Date oldDate = new Date();
                    if (value instanceof Date) {
                        oldDate = (Date)value;
                    } else if (value instanceof Long) {
                        cal.setTimeInMillis((Long)value);
                        oldDate = cal.getTime();
                    }
                    cal.setTime(oldDate);
                    cal.set(11, h);
                    cal.set(12, m);
                    cal.set(13, s);
                    cal.set(14, ms);
                    newDate = cal.getTime();
                }
            }
            return newDate;
        }
        catch (ParseException e) {
            throw UiException.Aide.wrap((Throwable)e);
        }
    }

    private static SimpleDateFormat getLocalizedSimpleDateFormat(String formatPtn) {
        SimpleDateFormat sdf = new SimpleDateFormat(formatPtn, Locales.getCurrent());
        sdf.setTimeZone(TimeZones.getCurrent());
        return sdf;
    }
}

