/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.awt.geom.Dimension2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.ImageMapRenderable;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRBoxContainer;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintElementIndex;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameter;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintImageArea;
import net.sf.jasperreports.engine.JRPrintImageAreaHyperlink;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.PrintPageFormat;
import net.sf.jasperreports.engine.RenderableUtil;
import net.sf.jasperreports.engine.base.JRBasePrintText;
import net.sf.jasperreports.engine.export.AbstractHtmlExporter;
import net.sf.jasperreports.engine.export.DefaultHyperlinkTargetProducerFactory;
import net.sf.jasperreports.engine.export.GenericElementHandlerEnviroment;
import net.sf.jasperreports.engine.export.GenericElementHtmlHandler;
import net.sf.jasperreports.engine.export.HtmlFontFamily;
import net.sf.jasperreports.engine.export.HtmlResourceHandler;
import net.sf.jasperreports.engine.export.HyperlinkUtil;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRHtmlExporterContext;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import net.sf.jasperreports.engine.export.JRHyperlinkTargetProducer;
import net.sf.jasperreports.engine.export.JRHyperlinkTargetProducerFactory;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.type.LineDirectionEnum;
import net.sf.jasperreports.engine.type.LineSpacingEnum;
import net.sf.jasperreports.engine.type.LineStyleEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.util.JRBoxUtil;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRTextAttribute;
import net.sf.jasperreports.engine.util.JRTypeSniffer;
import net.sf.jasperreports.engine.util.Pair;
import net.sf.jasperreports.export.ExportInterruptedException;
import net.sf.jasperreports.export.ExporterInputItem;
import net.sf.jasperreports.export.HtmlExporterConfiguration;
import net.sf.jasperreports.export.HtmlExporterOutput;
import net.sf.jasperreports.export.HtmlReportConfiguration;
import net.sf.jasperreports.export.WriterExporterOutput;
import net.sf.jasperreports.export.parameters.ParametersHtmlExporterOutput;
import net.sf.jasperreports.renderers.AreaHyperlinksRenderable;
import net.sf.jasperreports.renderers.DataRenderable;
import net.sf.jasperreports.renderers.DimensionRenderable;
import net.sf.jasperreports.renderers.Renderable;
import net.sf.jasperreports.renderers.RenderersCache;
import net.sf.jasperreports.renderers.ResourceRenderer;
import net.sf.jasperreports.renderers.util.RendererUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.tools.codec.Base64Encoder;

public class JRXhtmlExporter
extends AbstractHtmlExporter<HtmlReportConfiguration, HtmlExporterConfiguration> {
    private static final Log log = LogFactory.getLog(JRXhtmlExporter.class);
    private static final String XHTML_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.xhtml.";
    public static final String PROPERTY_IGNORE_HYPERLINK = "net.sf.jasperreports.export.xhtml.ignore.hyperlink";
    public static final String XHTML_EXPORTER_KEY = "net.sf.jasperreports.xhtml";
    protected Writer writer;
    protected Map<String, String> rendererToImagePathMap;
    protected Map<Pair<String, Rectangle>, String> imageMaps;
    protected RenderersCache renderersCache;
    protected int reportIndex;
    protected int pageIndex;
    protected List<FrameInfo> frameInfoStack;
    protected int elementIndex;
    protected int topLimit;
    protected int leftLimit;
    protected int rightLimit;
    protected int bottomLimit;
    protected JRHyperlinkTargetProducerFactory targetProducerFactory;
    protected boolean hyperlinkStarted;

    public JRXhtmlExporter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public JRXhtmlExporter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
        this.exporterContext = new ExporterContext();
        this.targetProducerFactory = new DefaultHyperlinkTargetProducerFactory(jasperReportsContext);
    }

    @Override
    protected Class<HtmlExporterConfiguration> getConfigurationInterface() {
        return HtmlExporterConfiguration.class;
    }

    @Override
    protected Class<HtmlReportConfiguration> getItemConfigurationInterface() {
        return HtmlReportConfiguration.class;
    }

    @Override
    protected void ensureOutput() {
        if (this.exporterOutput == null) {
            this.exporterOutput = new ParametersHtmlExporterOutput(this.getJasperReportsContext(), this.getParameters(), this.getCurrentJasperPrint());
        }
    }

    @Override
    public void exportReport() throws JRException {
        this.ensureJasperReportsContext();
        this.ensureInput();
        this.rendererToImagePathMap = new HashMap<String, String>();
        this.imageMaps = new HashMap<Pair<String, Rectangle>, String>();
        this.renderersCache = new RenderersCache(this.getJasperReportsContext());
        this.fontsToProcess = new HashMap();
        this.initExport();
        this.ensureOutput();
        this.writer = ((HtmlExporterOutput)this.getExporterOutput()).getWriter();
        try {
            this.exportReportToWriter();
        }
        catch (IOException e) {
            throw new JRException("export.common.output.writer.error", new Object[]{this.jasperPrint.getName()}, e);
        }
        finally {
            ((HtmlExporterOutput)this.getExporterOutput()).close();
            this.resetExportContext();
        }
    }

    @Override
    protected void initExport() {
        super.initExport();
    }

    @Override
    protected void initReport() {
        super.initReport();
    }

    protected void exportReportToWriter() throws JRException, IOException {
        HtmlExporterConfiguration configuration = (HtmlExporterConfiguration)this.getCurrentConfiguration();
        String htmlHeader = configuration.getHtmlHeader();
        String betweenPagesHtml = configuration.getBetweenPagesHtml();
        String htmlFooter = configuration.getHtmlFooter();
        if (htmlHeader == null) {
            String encoding = ((WriterExporterOutput)this.getExporterOutput()).getEncoding();
            this.writer.write("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n");
            this.writer.write("<html>\n");
            this.writer.write("<head>\n");
            this.writer.write("  <title></title>\n");
            this.writer.write("  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + encoding + "\"/>\n");
            this.writer.write("  <style type=\"text/css\">\n");
            this.writer.write("    a {text-decoration: none}\n");
            this.writer.write("  </style>\n");
            this.writer.write("</head>\n");
            this.writer.write("<body text=\"#000000\" link=\"#000000\" alink=\"#000000\" vlink=\"#000000\">\n");
            this.writer.write("<table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\">\n");
            this.writer.write("<tr><td width=\"50%\">&nbsp;</td><td align=\"center\">\n");
            this.writer.write("\n");
        } else {
            this.writer.write(htmlHeader);
        }
        List<ExporterInputItem> items = this.exporterInput.getItems();
        this.reportIndex = 0;
        while (this.reportIndex < items.size()) {
            ExporterInputItem item = items.get(this.reportIndex);
            this.setCurrentExporterInputItem(item);
            List<JRPrintPage> pages = this.jasperPrint.getPages();
            if (pages != null && pages.size() > 0) {
                JRAbstractExporter.PageRange pageRange = this.getPageRange();
                int startPageIndex = pageRange == null || pageRange.getStartPageIndex() == null ? 0 : pageRange.getStartPageIndex();
                int endPageIndex = pageRange == null || pageRange.getEndPageIndex() == null ? pages.size() - 1 : pageRange.getEndPageIndex();
                JRPrintPage page = null;
                this.pageIndex = startPageIndex;
                while (this.pageIndex <= endPageIndex) {
                    if (Thread.interrupted()) {
                        throw new ExportInterruptedException();
                    }
                    page = pages.get(this.pageIndex);
                    this.writer.write("<a name=\"JR_PAGE_ANCHOR_" + this.reportIndex + "_" + (this.pageIndex + 1) + "\"></a>\n");
                    this.exportPage(page);
                    if (this.reportIndex < items.size() - 1 || this.pageIndex < endPageIndex) {
                        if (betweenPagesHtml == null) {
                            this.writer.write("<br/>\n<br/>\n");
                        } else {
                            this.writer.write(betweenPagesHtml);
                        }
                    }
                    this.writer.write("\n");
                    ++this.pageIndex;
                }
            }
            ++this.reportIndex;
        }
        if (this.fontsToProcess != null && this.fontsToProcess.size() > 0) {
            HtmlResourceHandler fontHandler = ((HtmlExporterOutput)this.getExporterOutput()).getFontHandler() == null ? this.getFontHandler() : ((HtmlExporterOutput)this.getExporterOutput()).getFontHandler();
            for (HtmlFontFamily htmlFontFamily : this.fontsToProcess.values()) {
                this.writer.write("<link class=\"jrWebFont\" rel=\"stylesheet\" href=\"" + fontHandler.getResourcePath(htmlFontFamily.getId()) + "\">\n");
            }
        }
        this.writer.write("<!--[if IE]>\n");
        this.writer.write("<script>\n");
        this.writer.write("var links = document.querySelectorAll('link.jrWebFont');\n");
        this.writer.write("setTimeout(function(){ if (links) { for (var i = 0; i < links.length; i++) { links.item(i).href = links.item(i).href; } } }, 0);\n");
        this.writer.write("</script>\n");
        this.writer.write("<![endif]-->\n");
        if (htmlFooter == null) {
            this.writer.write("</td><td width=\"50%\">&nbsp;</td></tr>\n");
            this.writer.write("</table>\n");
            this.writer.write("</body>\n");
            this.writer.write("</html>\n");
        } else {
            this.writer.write(htmlFooter);
        }
        this.writer.flush();
    }

    protected void exportPage(JRPrintPage page) throws JRException, IOException {
        PrintPageFormat pageFormat = this.jasperPrint.getPageFormat(this.pageIndex);
        this.topLimit = pageFormat.getPageHeight();
        this.leftLimit = pageFormat.getPageWidth();
        this.rightLimit = 0;
        this.bottomLimit = 0;
        this.setPageLimits(page.getElements());
        HtmlReportConfiguration configuration = (HtmlReportConfiguration)this.getCurrentItemConfiguration();
        boolean isIgnorePageMargins = configuration.isIgnorePageMargins();
        if (!isIgnorePageMargins) {
            this.topLimit = 0;
        }
        if (!isIgnorePageMargins) {
            this.leftLimit = 0;
        }
        if (pageFormat.getPageWidth() > this.rightLimit && !isIgnorePageMargins) {
            this.rightLimit = pageFormat.getPageWidth();
        }
        if (pageFormat.getPageHeight() > this.bottomLimit && !isIgnorePageMargins) {
            this.bottomLimit = pageFormat.getPageHeight();
        }
        if (this.topLimit > this.bottomLimit) {
            this.topLimit = this.bottomLimit;
        }
        if (this.leftLimit > this.rightLimit) {
            this.leftLimit = this.rightLimit;
        }
        boolean isWhitePageBackground = configuration.isWhitePageBackground();
        this.writer.write("<div class=\"jrPage\" style=\"" + (isWhitePageBackground ? "background-color: #FFFFFF;" : "") + "position:relative;width:" + this.toSizeUnit(this.rightLimit - this.leftLimit) + ";height:" + this.toSizeUnit(this.bottomLimit - this.topLimit) + ";\">\n");
        this.frameInfoStack = new ArrayList<FrameInfo>();
        this.exportElements(page.getElements());
        this.writer.write("</div>");
        JRExportProgressMonitor progressMonitor = configuration.getProgressMonitor();
        if (progressMonitor != null) {
            progressMonitor.afterPageExport();
        }
    }

    protected void exportElements(List<JRPrintElement> elements) throws IOException, JRException {
        if (elements != null && elements.size() > 0) {
            for (int i = 0; i < elements.size(); ++i) {
                this.elementIndex = i;
                JRPrintElement element = elements.get(i);
                if (this.filter != null && !this.filter.isToExport(element)) continue;
                if (element instanceof JRPrintLine) {
                    this.exportLine((JRPrintLine)element);
                    continue;
                }
                if (element instanceof JRPrintRectangle) {
                    this.exportRectangle((JRPrintRectangle)element);
                    continue;
                }
                if (element instanceof JRPrintEllipse) {
                    this.exportRectangle((JRPrintEllipse)element);
                    continue;
                }
                if (element instanceof JRPrintImage) {
                    this.exportImage((JRPrintImage)element);
                    continue;
                }
                if (element instanceof JRPrintText) {
                    this.exportText((JRPrintText)element);
                    continue;
                }
                if (element instanceof JRPrintFrame) {
                    this.exportFrame((JRPrintFrame)element);
                    continue;
                }
                if (!(element instanceof JRGenericPrintElement)) continue;
                this.exportGenericElement((JRGenericPrintElement)element);
            }
        }
    }

    protected void exportLine(JRPrintLine line) throws IOException {
        this.writer.write("<span");
        this.appendId(line);
        StringBuilder styleBuilder = new StringBuilder();
        this.appendPositionStyle((JRPrintElement)line, line.getLinePen(), styleBuilder);
        this.appendSizeStyle((JRPrintElement)line, line.getLinePen(), styleBuilder);
        this.appendBackcolorStyle(line, styleBuilder);
        String side = null;
        float ratio = line.getWidth() / line.getHeight();
        side = ratio > 1.0f ? (line.getDirectionValue() == LineDirectionEnum.TOP_DOWN ? "top" : "bottom") : (line.getDirectionValue() == LineDirectionEnum.TOP_DOWN ? "left" : "right");
        this.appendPen(styleBuilder, line.getLinePen(), side);
        if (styleBuilder.length() > 0) {
            this.writer.write(" style=\"");
            this.writer.write(styleBuilder.toString());
            this.writer.write("\"");
        }
        this.writer.write("></span>\n");
    }

    protected void exportRectangle(JRPrintGraphicElement element) throws IOException {
        this.writer.write("<span");
        this.appendId(element);
        StringBuilder styleBuilder = new StringBuilder();
        this.appendPositionStyle((JRPrintElement)element, element.getLinePen(), styleBuilder);
        this.appendSizeStyle((JRPrintElement)element, element.getLinePen(), styleBuilder);
        this.appendBackcolorStyle(element, styleBuilder);
        this.appendPen(styleBuilder, element.getLinePen(), null);
        if (styleBuilder.length() > 0) {
            this.writer.write(" style=\"");
            this.writer.write(styleBuilder.toString());
            this.writer.write("\"");
        }
        this.writer.write("></span>\n");
    }

    protected void exportStyledText(JRPrintText printText, JRStyledText styledText, String tooltip) throws IOException {
        Locale locale = this.getTextLocale(printText);
        LineSpacingEnum lineSpacing = printText.getParagraph().getLineSpacing();
        Float lineSpacingSize = printText.getParagraph().getLineSpacingSize();
        float lineSpacingFactor = printText.getLineSpacingFactor();
        Color backcolor = printText.getBackcolor();
        String text = styledText.getText();
        int runLimit = 0;
        AttributedCharacterIterator iterator = styledText.getAttributedString().getIterator();
        boolean first = true;
        boolean startedSpan = false;
        while (runLimit < styledText.length() && (runLimit = iterator.getRunLimit()) <= styledText.length()) {
            if (first && runLimit < styledText.length() && tooltip != null) {
                startedSpan = true;
                this.writer.write("<span title=\"");
                this.writer.write(JRStringUtil.xmlEncode(tooltip));
                this.writer.write("\">");
                tooltip = null;
            }
            first = false;
            this.exportStyledTextRun(iterator.getAttributes(), text.substring(iterator.getIndex(), runLimit), tooltip, locale, lineSpacing, lineSpacingSize, lineSpacingFactor, backcolor);
            iterator.setIndex(runLimit);
        }
        if (startedSpan) {
            this.writer.write("</span>");
        }
    }

    protected void exportStyledTextRun(Map<AttributedCharacterIterator.Attribute, Object> attributes, String text, String tooltip, Locale locale, LineSpacingEnum lineSpacing, Float lineSpacingSize, float lineSpacingFactor, Color backcolor) throws IOException {
        Color runBackcolor;
        boolean localHyperlink = false;
        JRPrintHyperlink hyperlink = (JRPrintHyperlink)attributes.get(JRTextAttribute.HYPERLINK);
        if (!this.hyperlinkStarted && hyperlink != null) {
            this.startHyperlink(hyperlink);
            localHyperlink = true;
        }
        boolean isBold = TextAttribute.WEIGHT_BOLD.equals(attributes.get(TextAttribute.WEIGHT));
        boolean isItalic = TextAttribute.POSTURE_OBLIQUE.equals(attributes.get(TextAttribute.POSTURE));
        String fontFamily = this.resolveFontFamily(attributes, locale);
        this.writer.write("<span style=\"font-family: ");
        this.writer.write(fontFamily);
        this.writer.write("; ");
        Color forecolor = (Color)attributes.get(TextAttribute.FOREGROUND);
        if (!this.hyperlinkStarted || !Color.black.equals(forecolor)) {
            this.writer.write("color: ");
            this.writer.write(JRColorUtil.getCssColor(forecolor));
            this.writer.write("; ");
        }
        if ((runBackcolor = (Color)attributes.get(TextAttribute.BACKGROUND)) != null && !runBackcolor.equals(backcolor)) {
            this.writer.write("background-color: ");
            this.writer.write(JRColorUtil.getCssColor(runBackcolor));
            this.writer.write("; ");
        }
        this.writer.write("font-size: ");
        this.writer.write(this.toSizeUnit(((Float)attributes.get(TextAttribute.SIZE)).floatValue()));
        this.writer.write(";");
        switch (lineSpacing) {
            default: {
                if (lineSpacingFactor == 0.0f) {
                    this.writer.write(" line-height: 1; *line-height: normal;");
                    break;
                }
                this.writer.write(" line-height: " + lineSpacingFactor + ";");
                break;
            }
            case ONE_AND_HALF: {
                if (lineSpacingFactor == 0.0f) {
                    this.writer.write(" line-height: 1.5;");
                    break;
                }
                this.writer.write(" line-height: " + lineSpacingFactor + ";");
                break;
            }
            case DOUBLE: {
                if (lineSpacingFactor == 0.0f) {
                    this.writer.write(" line-height: 2.0;");
                    break;
                }
                this.writer.write(" line-height: " + lineSpacingFactor + ";");
                break;
            }
            case PROPORTIONAL: {
                if (lineSpacingSize == null) break;
                this.writer.write(" line-height: " + lineSpacingSize.floatValue() + ";");
                break;
            }
            case AT_LEAST: 
            case FIXED: {
                if (lineSpacingSize == null) break;
                this.writer.write(" line-height: " + lineSpacingSize.floatValue() + "px;");
            }
        }
        if (isBold) {
            this.writer.write(" font-weight: bold;");
        }
        if (isItalic) {
            this.writer.write(" font-style: italic;");
        }
        if (TextAttribute.UNDERLINE_ON.equals(attributes.get(TextAttribute.UNDERLINE))) {
            this.writer.write(" text-decoration: underline;");
        }
        if (TextAttribute.STRIKETHROUGH_ON.equals(attributes.get(TextAttribute.STRIKETHROUGH))) {
            this.writer.write(" text-decoration: line-through;");
        }
        if (TextAttribute.SUPERSCRIPT_SUPER.equals(attributes.get(TextAttribute.SUPERSCRIPT))) {
            this.writer.write(" vertical-align: super;");
        } else if (TextAttribute.SUPERSCRIPT_SUB.equals(attributes.get(TextAttribute.SUPERSCRIPT))) {
            this.writer.write(" vertical-align: sub;");
        }
        this.writer.write("\"");
        if (tooltip != null) {
            this.writer.write(" title=\"");
            this.writer.write(JRStringUtil.xmlEncode(tooltip));
            this.writer.write("\"");
        }
        this.writer.write(">");
        this.writer.write(JRStringUtil.htmlEncode(text));
        this.writer.write("</span>");
        if (localHyperlink) {
            this.endHyperlink();
        }
    }

    protected void exportText(JRPrintText text) throws IOException {
        JRStyledText styledText = this.getStyledText(text);
        int textLength = 0;
        if (styledText != null) {
            textLength = styledText.length();
        }
        if (text.getAnchorName() != null) {
            this.writer.write("<a name=\"");
            this.writer.write(text.getAnchorName());
            this.writer.write("\"></a>");
        }
        this.writer.write("<div");
        this.appendId(text);
        if (text.getRunDirectionValue() == RunDirectionEnum.RTL) {
            this.writer.write(" dir=\"rtl\"");
        }
        StringBuilder styleBuilder = new StringBuilder();
        StringBuilder divStyleBuilder = new StringBuilder();
        String rotationValue = null;
        if (text.getRotationValue() == RotationEnum.NONE) {
            this.appendPositionStyle((JRPrintElement)text, text, divStyleBuilder);
            this.appendSizeStyle((JRPrintElement)text, text, divStyleBuilder);
            this.appendBorderStyle(text.getLineBox(), divStyleBuilder);
            this.appendPositionStyle(text.getLineBox().getLeftPadding() - this.getInsideBorderOffset(text.getLineBox().getLeftPen().getLineWidth().floatValue(), false), text.getLineBox().getTopPadding() - this.getInsideBorderOffset(text.getLineBox().getTopPen().getLineWidth().floatValue(), false), styleBuilder);
            this.appendSizeStyle(text.getWidth() - text.getLineBox().getLeftPadding() - text.getLineBox().getRightPadding(), text.getHeight() - text.getLineBox().getTopPadding() - text.getLineBox().getBottomPadding(), styleBuilder);
        } else {
            JRBasePrintText rotatedText = new JRBasePrintText(text.getDefaultStyleProvider());
            rotatedText.setUUID(text.getUUID());
            rotatedText.setX(text.getX());
            rotatedText.setY(text.getY());
            rotatedText.setWidth(text.getWidth());
            rotatedText.setHeight(text.getHeight());
            rotatedText.copyBox(text.getLineBox());
            JRBoxUtil.rotate(rotatedText.getLineBox(), text.getRotationValue());
            int rotationIE = 0;
            int rotationAngle = 0;
            int translateX = 0;
            int translateY = 0;
            switch (text.getRotationValue()) {
                case LEFT: {
                    translateX = -(text.getHeight() - text.getLineBox().getTopPadding() - text.getLineBox().getBottomPadding() - (text.getWidth() - text.getLineBox().getLeftPadding() - text.getLineBox().getRightPadding())) / 2;
                    translateY = (text.getHeight() - text.getLineBox().getTopPadding() - text.getLineBox().getBottomPadding() - (text.getWidth() - text.getLineBox().getLeftPadding() - text.getLineBox().getRightPadding())) / 2;
                    rotatedText.setWidth(text.getHeight());
                    rotatedText.setHeight(text.getWidth());
                    rotationIE = 3;
                    rotationAngle = -90;
                    rotationValue = "left";
                    break;
                }
                case RIGHT: {
                    translateX = -(text.getHeight() - text.getLineBox().getTopPadding() - text.getLineBox().getBottomPadding() - (text.getWidth() - text.getLineBox().getLeftPadding() - text.getLineBox().getRightPadding())) / 2;
                    translateY = (text.getHeight() - text.getLineBox().getTopPadding() - text.getLineBox().getBottomPadding() - (text.getWidth() - text.getLineBox().getLeftPadding() - text.getLineBox().getRightPadding())) / 2;
                    rotatedText.setWidth(text.getHeight());
                    rotatedText.setHeight(text.getWidth());
                    rotationIE = 1;
                    rotationAngle = 90;
                    rotationValue = "right";
                    break;
                }
                case UPSIDE_DOWN: {
                    rotationIE = 2;
                    rotationAngle = 180;
                    rotationValue = "upsideDown";
                    break;
                }
            }
            this.appendPositionStyle((JRPrintElement)text, text, divStyleBuilder);
            this.appendSizeStyle((JRPrintElement)text, text, divStyleBuilder);
            this.appendBorderStyle(text.getLineBox(), divStyleBuilder);
            this.appendPositionStyle(text.getLineBox().getLeftPadding() - this.getInsideBorderOffset(text.getLineBox().getLeftPen().getLineWidth().floatValue(), false), text.getLineBox().getTopPadding() - this.getInsideBorderOffset(text.getLineBox().getTopPen().getLineWidth().floatValue(), false), styleBuilder);
            this.appendSizeStyle(rotatedText.getWidth() - rotatedText.getLineBox().getLeftPadding() - rotatedText.getLineBox().getRightPadding(), rotatedText.getHeight() - rotatedText.getLineBox().getTopPadding() - rotatedText.getLineBox().getBottomPadding(), styleBuilder);
            styleBuilder.append("-webkit-transform: translate(" + translateX + "px," + translateY + "px) ");
            styleBuilder.append("rotate(" + rotationAngle + "deg); ");
            styleBuilder.append("-moz-transform: translate(" + translateX + "px," + translateY + "px) ");
            styleBuilder.append("rotate(" + rotationAngle + "deg); ");
            styleBuilder.append("-ms-transform: translate(" + translateX + "px," + translateY + "px) ");
            styleBuilder.append("rotate(" + rotationAngle + "deg); ");
            styleBuilder.append("-o-transform: translate(" + translateX + "px," + translateY + "px) ");
            styleBuilder.append("rotate(" + rotationAngle + "deg); ");
            styleBuilder.append("filter: progid:DXImageTransform.Microsoft.BasicImage(rotation=" + rotationIE + "); ");
        }
        this.appendBackcolorStyle(text, divStyleBuilder);
        String verticalAlignment = "top";
        switch (text.getVerticalTextAlign()) {
            case BOTTOM: {
                verticalAlignment = "bottom";
                break;
            }
            case MIDDLE: {
                verticalAlignment = "middle";
                break;
            }
            default: {
                verticalAlignment = "top";
            }
        }
        String horizontalAlignment = "left";
        if (textLength > 0) {
            switch (text.getHorizontalTextAlign()) {
                case RIGHT: {
                    horizontalAlignment = "right";
                    break;
                }
                case CENTER: {
                    horizontalAlignment = "center";
                    break;
                }
                case JUSTIFIED: {
                    horizontalAlignment = "justify";
                    break;
                }
                default: {
                    horizontalAlignment = "left";
                }
            }
            styleBuilder.append("text-align: ");
            styleBuilder.append(horizontalAlignment);
            styleBuilder.append(";");
            styleBuilder.append(" display:table;");
        }
        if (((HtmlReportConfiguration)this.getCurrentItemConfiguration()).isWrapBreakWord().booleanValue()) {
            styleBuilder.append("word-wrap: break-word; ");
        }
        styleBuilder.append("text-indent: " + text.getParagraph().getFirstLineIndent() + "px; ");
        if (text.getLineBreakOffsets() != null) {
            styleBuilder.append("white-space: nowrap; ");
        }
        divStyleBuilder.append("overflow: hidden;");
        if (divStyleBuilder.length() > 0) {
            this.writer.write(" style=\"");
            this.writer.write(divStyleBuilder.toString());
            this.writer.write("\"");
        }
        this.writer.write("><span");
        if (rotationValue != null) {
            this.writer.write(" class=\"rotated\" data-rotation=\"" + rotationValue + "\"");
        }
        if (styleBuilder.length() > 0) {
            this.writer.write(" style=\"");
            this.writer.write(styleBuilder.toString());
            this.writer.write("\"");
        }
        this.writer.write(">");
        this.writer.write("<span style=\"display:table-cell;vertical-align:");
        this.writer.write(verticalAlignment);
        this.writer.write(";\">");
        this.startHyperlink(text);
        if (textLength > 0) {
            this.exportStyledText(text, styledText, text.getHyperlinkTooltip());
        }
        this.endHyperlink();
        this.writer.write("</span>");
        this.writer.write("</span></div>\n");
    }

    protected boolean startHyperlink(JRPrintHyperlink link) throws IOException {
        String href = this.getHyperlinkURL(link);
        if (href != null) {
            this.writer.write("<a href=\"");
            this.writer.write(href);
            this.writer.write("\"");
            String target = this.getHyperlinkTarget(link);
            if (target != null) {
                this.writer.write(" target=\"");
                this.writer.write(target);
                this.writer.write("\"");
            }
            if (link.getHyperlinkTooltip() != null) {
                this.writer.write(" title=\"");
                this.writer.write(JRStringUtil.xmlEncode(link.getHyperlinkTooltip()));
                this.writer.write("\"");
            }
            this.writer.write(">");
        }
        this.hyperlinkStarted = href != null;
        return this.hyperlinkStarted;
    }

    protected String getHyperlinkTarget(JRPrintHyperlink link) {
        String target;
        block10: {
            JRHyperlinkTargetProducer producer;
            block9: {
                target = null;
                producer = this.targetProducerFactory.getHyperlinkTargetProducer(link.getLinkTarget());
                if (producer != null) break block9;
                switch (link.getHyperlinkTargetValue()) {
                    case BLANK: {
                        target = "_blank";
                        break;
                    }
                    case PARENT: {
                        target = "_parent";
                        break;
                    }
                    case TOP: {
                        target = "_top";
                        break;
                    }
                    case CUSTOM: {
                        List<JRPrintHyperlinkParameter> parameters;
                        boolean paramFound = false;
                        List<JRPrintHyperlinkParameter> list = parameters = link.getHyperlinkParameters() == null ? null : link.getHyperlinkParameters().getParameters();
                        if (parameters != null) {
                            for (JRPrintHyperlinkParameter parameter : parameters) {
                                if (!link.getLinkTarget().equals(parameter.getName())) continue;
                                target = parameter.getValue() == null ? null : parameter.getValue().toString();
                                paramFound = true;
                                break;
                            }
                        }
                        if (!paramFound) {
                            target = link.getLinkTarget();
                            break;
                        } else {
                            break;
                        }
                    }
                }
                break block10;
            }
            target = producer.getHyperlinkTarget(link);
        }
        return target;
    }

    protected String getHyperlinkURL(JRPrintHyperlink link) {
        String href;
        block13: {
            JRHyperlinkProducer customHandler;
            block14: {
                href = null;
                Boolean ignoreHyperlink = HyperlinkUtil.getIgnoreHyperlink(PROPERTY_IGNORE_HYPERLINK, link);
                if (ignoreHyperlink == null) {
                    ignoreHyperlink = this.getPropertiesUtil().getBooleanProperty(this.jasperPrint, PROPERTY_IGNORE_HYPERLINK, false);
                }
                if (ignoreHyperlink.booleanValue()) break block13;
                customHandler = this.getHyperlinkProducer(link);
                if (customHandler != null) break block14;
                switch (link.getHyperlinkTypeValue()) {
                    case REFERENCE: {
                        if (link.getHyperlinkReference() != null) {
                            href = link.getHyperlinkReference();
                            break;
                        }
                        break block13;
                    }
                    case LOCAL_ANCHOR: {
                        if (link.getHyperlinkAnchor() != null) {
                            href = "#" + link.getHyperlinkAnchor();
                            break;
                        }
                        break block13;
                    }
                    case LOCAL_PAGE: {
                        if (link.getHyperlinkPage() != null) {
                            href = "#JR_PAGE_ANCHOR_" + this.reportIndex + "_" + link.getHyperlinkPage().toString();
                            break;
                        }
                        break block13;
                    }
                    case REMOTE_ANCHOR: {
                        if (link.getHyperlinkReference() != null && link.getHyperlinkAnchor() != null) {
                            href = link.getHyperlinkReference() + "#" + link.getHyperlinkAnchor();
                            break;
                        }
                        break block13;
                    }
                    case REMOTE_PAGE: {
                        if (link.getHyperlinkReference() != null && link.getHyperlinkPage() != null) {
                            href = link.getHyperlinkReference() + "#" + "JR_PAGE_ANCHOR_" + "0_" + link.getHyperlinkPage().toString();
                            break;
                        }
                        break block13;
                    }
                }
                break block13;
            }
            href = customHandler.getHyperlink(link);
        }
        return href;
    }

    protected void endHyperlink() throws IOException {
        if (this.hyperlinkStarted) {
            this.writer.write("</a>");
        }
        this.hyperlinkStarted = false;
    }

    protected boolean appendBorderStyle(JRLineBox box, StringBuilder styleBuilder) {
        boolean addedToStyle = false;
        if (box != null) {
            LineStyleEnum tps = box.getTopPen().getLineStyleValue();
            LineStyleEnum lps = box.getLeftPen().getLineStyleValue();
            LineStyleEnum bps = box.getBottomPen().getLineStyleValue();
            LineStyleEnum rps = box.getRightPen().getLineStyleValue();
            float tpw = box.getTopPen().getLineWidth().floatValue();
            float lpw = box.getLeftPen().getLineWidth().floatValue();
            float bpw = box.getBottomPen().getLineWidth().floatValue();
            float rpw = box.getRightPen().getLineWidth().floatValue();
            if (0.0f < tpw && tpw < 1.0f) {
                tpw = 1.0f;
            }
            if (0.0f < lpw && lpw < 1.0f) {
                lpw = 1.0f;
            }
            if (0.0f < bpw && bpw < 1.0f) {
                bpw = 1.0f;
            }
            if (0.0f < rpw && rpw < 1.0f) {
                rpw = 1.0f;
            }
            Color tpc = box.getTopPen().getLineColor();
            if (tps == lps && tps == bps && tps == rps && tpw == lpw && tpw == bpw && tpw == rpw && tpc.equals(box.getLeftPen().getLineColor()) && tpc.equals(box.getBottomPen().getLineColor()) && tpc.equals(box.getRightPen().getLineColor())) {
                addedToStyle |= this.appendPen(styleBuilder, box.getTopPen(), null);
            } else {
                addedToStyle |= this.appendPen(styleBuilder, box.getTopPen(), "top");
                addedToStyle |= this.appendPen(styleBuilder, box.getLeftPen(), "left");
                addedToStyle |= this.appendPen(styleBuilder, box.getBottomPen(), "bottom");
                addedToStyle |= this.appendPen(styleBuilder, box.getRightPen(), "right");
            }
            Integer tp = box.getTopPadding();
            Integer lp = box.getLeftPadding();
            Integer bp = box.getBottomPadding();
            Integer rp = box.getRightPadding();
            if (tp == lp && tp == bp && tp == rp) {
                addedToStyle |= this.appendPadding(styleBuilder, tp, null);
            } else {
                addedToStyle |= this.appendPadding(styleBuilder, box.getTopPadding(), "top");
                addedToStyle |= this.appendPadding(styleBuilder, box.getLeftPadding(), "left");
                addedToStyle |= this.appendPadding(styleBuilder, box.getBottomPadding(), "bottom");
                addedToStyle |= this.appendPadding(styleBuilder, box.getRightPadding(), "right");
            }
        }
        return addedToStyle;
    }

    protected int getInsideBorderOffset(float borderWidth, boolean small) {
        int intBorderWidth = (int)borderWidth;
        if (0.0f < borderWidth && borderWidth < 1.0f) {
            intBorderWidth = 1;
        }
        return intBorderWidth / 2 + (small ? 0 : intBorderWidth % 2);
    }

    protected void appendSizeStyle(JRPrintElement element, JRBoxContainer boxContainer, StringBuilder styleBuilder) {
        JRLineBox box;
        int widthDiff = 0;
        int heightDiff = 0;
        JRLineBox jRLineBox = box = boxContainer == null ? null : boxContainer.getLineBox();
        if (box != null) {
            widthDiff = box.getLeftPadding() + box.getRightPadding() + this.getInsideBorderOffset(box.getLeftPen().getLineWidth().floatValue(), false) + this.getInsideBorderOffset(box.getRightPen().getLineWidth().floatValue(), true);
            heightDiff = box.getTopPadding() + box.getBottomPadding() + this.getInsideBorderOffset(box.getTopPen().getLineWidth().floatValue(), false) + this.getInsideBorderOffset(box.getBottomPen().getLineWidth().floatValue(), true);
        }
        int width = element.getWidth() - widthDiff;
        int height = element.getHeight() - heightDiff;
        this.appendSizeStyle(width < 0 ? 0 : width, height < 0 ? 0 : height, styleBuilder);
    }

    protected void appendSizeStyle(JRPrintElement element, JRPen pen, StringBuilder styleBuilder) {
        int diff = 0;
        if (pen != null) {
            diff = this.getInsideBorderOffset(pen.getLineWidth().floatValue(), false) + this.getInsideBorderOffset(pen.getLineWidth().floatValue(), true);
        }
        this.appendSizeStyle(element.getWidth() - diff, element.getHeight() - diff, styleBuilder);
    }

    protected void appendSizeStyle(int width, int height, StringBuilder styleBuilder) {
        styleBuilder.append("width:");
        styleBuilder.append(this.toSizeUnit(width));
        styleBuilder.append(";");
        styleBuilder.append("height:");
        styleBuilder.append(this.toSizeUnit(height));
        styleBuilder.append(";");
    }

    protected void appendPositionStyle(JRPrintElement element, JRBoxContainer boxContainer, StringBuilder styleBuilder) {
        JRLineBox box;
        int leftOffset = 0;
        int topOffset = 0;
        JRLineBox jRLineBox = box = boxContainer == null ? null : boxContainer.getLineBox();
        if (box != null) {
            leftOffset = this.getInsideBorderOffset(box.getLeftPen().getLineWidth().floatValue(), true);
            topOffset = this.getInsideBorderOffset(box.getTopPen().getLineWidth().floatValue(), true);
        }
        FrameInfo frameInfo = this.frameInfoStack.size() == 0 ? null : this.frameInfoStack.get(this.frameInfoStack.size() - 1);
        this.appendPositionStyle(element.getX() - leftOffset - (frameInfo == null ? this.leftLimit : frameInfo.leftInsideBorderOffset), element.getY() - topOffset - (frameInfo == null ? this.topLimit : frameInfo.topInsideBorderOffset), styleBuilder);
    }

    protected void appendPositionStyle(JRPrintElement element, JRPen pen, StringBuilder styleBuilder) {
        int offset = 0;
        if (pen != null) {
            offset = this.getInsideBorderOffset(pen.getLineWidth().floatValue(), true);
        }
        FrameInfo frameInfo = this.frameInfoStack.size() == 0 ? null : this.frameInfoStack.get(this.frameInfoStack.size() - 1);
        this.appendPositionStyle(element.getX() - offset - (frameInfo == null ? this.leftLimit : frameInfo.leftInsideBorderOffset), element.getY() - offset - (frameInfo == null ? this.topLimit : frameInfo.topInsideBorderOffset), styleBuilder);
    }

    protected void appendPositionStyle(int x, int y, StringBuilder styleBuilder) {
        styleBuilder.append("position:absolute;");
        styleBuilder.append("left:");
        styleBuilder.append(this.toSizeUnit(x));
        styleBuilder.append(";");
        styleBuilder.append("top:");
        styleBuilder.append(this.toSizeUnit(y));
        styleBuilder.append(";");
    }

    protected void appendBackcolorStyle(JRPrintElement element, StringBuilder styleBuilder) {
        if (element.getModeValue() == ModeEnum.OPAQUE) {
            styleBuilder.append("background-color: ");
            styleBuilder.append(JRColorUtil.getCssColor(element.getBackcolor()));
            styleBuilder.append("; ");
        }
    }

    protected void exportImage(JRPrintImage image) throws JRException, IOException {
        Renderable renderer;
        this.writer.write("<span");
        this.appendId(image);
        float xAlignFactor = 0.0f;
        switch (image.getHorizontalImageAlign()) {
            case RIGHT: {
                xAlignFactor = 1.0f;
                break;
            }
            case CENTER: {
                xAlignFactor = 0.5f;
                break;
            }
            default: {
                xAlignFactor = 0.0f;
            }
        }
        float yAlignFactor = 0.0f;
        switch (image.getVerticalImageAlign()) {
            case BOTTOM: {
                yAlignFactor = 1.0f;
                break;
            }
            case MIDDLE: {
                yAlignFactor = 0.5f;
                break;
            }
            default: {
                yAlignFactor = 0.0f;
            }
        }
        StringBuilder styleBuilder = new StringBuilder();
        this.appendPositionStyle((JRPrintElement)image, image, styleBuilder);
        this.appendSizeStyle((JRPrintElement)image, image, styleBuilder);
        this.appendBackcolorStyle(image, styleBuilder);
        boolean addedToStyle = this.appendBorderStyle(image.getLineBox(), styleBuilder);
        if (!addedToStyle) {
            this.appendPen(styleBuilder, image.getLinePen(), null);
        }
        if (styleBuilder.length() > 0) {
            this.writer.write(" style=\"");
            this.writer.write(styleBuilder.toString());
            this.writer.write("\"");
        }
        this.writer.write(">");
        if (image.getAnchorName() != null) {
            this.writer.write("<a name=\"");
            this.writer.write(image.getAnchorName());
            this.writer.write("\"></a>");
        }
        if ((renderer = image.getRenderer()) != null) {
            int availableImageHeight;
            boolean hasAreaHyperlinks = renderer instanceof ImageMapRenderable && ((ImageMapRenderable)renderer).hasImageAreaHyperlinks();
            boolean hasHyperlinks = false;
            if (hasAreaHyperlinks) {
                hasHyperlinks = true;
                this.hyperlinkStarted = false;
            } else {
                hasHyperlinks = this.startHyperlink(image);
            }
            int availableImageWidth = image.getWidth() - image.getLineBox().getLeftPadding() - image.getLineBox().getRightPadding();
            if (availableImageWidth < 0) {
                availableImageWidth = 0;
            }
            if ((availableImageHeight = image.getHeight() - image.getLineBox().getTopPadding() - image.getLineBox().getBottomPadding()) < 0) {
                availableImageHeight = 0;
            }
            this.writer.write("<img");
            String imagePath = null;
            boolean isLazy = RendererUtil.isLazy(renderer);
            if (isLazy) {
                imagePath = RendererUtil.getResourceLocation(renderer);
            } else {
                boolean isEmbedImage;
                if (renderer instanceof ResourceRenderer) {
                    renderer = this.renderersCache.getLoadedRenderer((ResourceRenderer)renderer);
                }
                if (!(isEmbedImage = this.isEmbedImage(image)) && renderer instanceof DataRenderable && this.rendererToImagePathMap.containsKey(renderer.getId())) {
                    imagePath = this.rendererToImagePathMap.get(renderer.getId());
                } else if (isEmbedImage) {
                    DataRenderable dataRenderer = this.getRendererUtil().getDataRenderable(renderer, new Dimension(availableImageWidth, availableImageHeight), ModeEnum.OPAQUE == image.getModeValue() ? image.getBackcolor() : null);
                    byte[] imageData = dataRenderer.getData(this.jasperReportsContext);
                    String imageMimeType = this.getRendererUtil().isSvgData(imageData) ? "image/svg+xml" : JRTypeSniffer.getImageTypeValue(imageData).getMimeType();
                    ByteArrayInputStream bais = new ByteArrayInputStream(imageData);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    Base64Encoder encoder = new Base64Encoder(bais, baos);
                    encoder.process();
                    imagePath = "data:" + imageMimeType + ";base64," + new String(baos.toByteArray(), "UTF-8");
                } else {
                    HtmlResourceHandler imageHandler;
                    HtmlResourceHandler htmlResourceHandler = imageHandler = this.getImageHandler() == null ? ((HtmlExporterOutput)this.getExporterOutput()).getImageHandler() : this.getImageHandler();
                    if (imageHandler != null) {
                        DataRenderable dataRenderer = this.getRendererUtil().getDataRenderable(renderer, new Dimension(availableImageWidth, availableImageHeight), ModeEnum.OPAQUE == image.getModeValue() ? image.getBackcolor() : null);
                        byte[] imageData = dataRenderer.getData(this.jasperReportsContext);
                        String fileExtension = this.getRendererUtil().isSvgData(imageData) ? "svg" : JRTypeSniffer.getImageTypeValue(imageData).getFileExtension();
                        String imageName = JRXhtmlExporter.getImageName(this.getElementIndex(), fileExtension);
                        imageHandler.handleResource(imageName, imageData);
                        imagePath = imageHandler.getResourcePath(imageName);
                        if (dataRenderer == renderer) {
                            this.rendererToImagePathMap.put(renderer.getId(), imagePath);
                        }
                    }
                }
            }
            String imageMapName = null;
            List<JRPrintImageAreaHyperlink> imageMapAreas = null;
            if (hasAreaHyperlinks) {
                Rectangle renderingArea = new Rectangle(image.getWidth(), image.getHeight());
                if (renderer instanceof DataRenderable) {
                    imageMapName = this.imageMaps.get(new Pair<String, Rectangle>(renderer.getId(), renderingArea));
                }
                if (imageMapName == null) {
                    Renderable originalRenderer = image.getRenderer();
                    imageMapName = "map_" + this.getElementIndex().toString();
                    imageMapAreas = ((AreaHyperlinksRenderable)((Object)originalRenderer)).getImageAreaHyperlinks(renderingArea);
                    if (renderer instanceof DataRenderable) {
                        this.imageMaps.put(new Pair<String, Rectangle>(renderer.getId(), renderingArea), imageMapName);
                    }
                }
            }
            this.writer.write(" src=\"");
            if (imagePath != null) {
                this.writer.write(imagePath);
            }
            this.writer.write("\"");
            ScaleImageEnum scaleImage = image.getScaleImageValue();
            switch (scaleImage) {
                case FILL_FRAME: {
                    int leftDiff = 0;
                    int topDiff = 0;
                    int widthDiff = 0;
                    int heightDiff = 0;
                    JRLineBox box = image.getLineBox();
                    if (box != null) {
                        leftDiff = box.getLeftPadding();
                        topDiff = box.getTopPadding();
                        widthDiff = this.getInsideBorderOffset(box.getLeftPen().getLineWidth().floatValue(), false) + this.getInsideBorderOffset(box.getRightPen().getLineWidth().floatValue(), true);
                        heightDiff = this.getInsideBorderOffset(box.getTopPen().getLineWidth().floatValue(), false) + this.getInsideBorderOffset(box.getBottomPen().getLineWidth().floatValue(), true);
                    }
                    this.writer.write(" style=\"position:absolute;left:");
                    this.writer.write(this.toSizeUnit(leftDiff));
                    this.writer.write(";top:");
                    this.writer.write(this.toSizeUnit(topDiff));
                    this.writer.write(";width:");
                    this.writer.write(this.toSizeUnit(availableImageWidth - widthDiff));
                    this.writer.write(";height:");
                    this.writer.write(this.toSizeUnit(availableImageHeight - heightDiff));
                    this.writer.write("\"");
                    break;
                }
                case CLIP: {
                    Dimension2D dimension;
                    Renderable tmpRenderer;
                    double normalWidth = availableImageWidth;
                    double normalHeight = availableImageHeight;
                    if (!isLazy && (tmpRenderer = RenderableUtil.getInstance(this.jasperReportsContext).getOnErrorRendererForDimension(this.renderersCache, renderer, image.getOnErrorTypeValue())) instanceof DimensionRenderable && (dimension = ((DimensionRenderable)((Object)tmpRenderer)).getDimension(this.jasperReportsContext)) != null) {
                        normalWidth = dimension.getWidth();
                        normalHeight = dimension.getHeight();
                    }
                    int leftDiff = 0;
                    int topDiff = 0;
                    int widthDiff = 0;
                    int heightDiff = 0;
                    JRLineBox box = image.getLineBox();
                    if (box != null) {
                        leftDiff = box.getLeftPadding();
                        topDiff = box.getTopPadding();
                        widthDiff = this.getInsideBorderOffset(box.getLeftPen().getLineWidth().floatValue(), false) + this.getInsideBorderOffset(box.getRightPen().getLineWidth().floatValue(), true);
                        heightDiff = this.getInsideBorderOffset(box.getTopPen().getLineWidth().floatValue(), false) + this.getInsideBorderOffset(box.getBottomPen().getLineWidth().floatValue(), true);
                    }
                    this.writer.write(" style=\"position:absolute;left:");
                    this.writer.write(this.toSizeUnit((int)((double)leftDiff + (double)xAlignFactor * ((double)(availableImageWidth - widthDiff) - normalWidth))));
                    this.writer.write(";top:");
                    this.writer.write(this.toSizeUnit((int)((double)topDiff + (double)yAlignFactor * ((double)(availableImageHeight - heightDiff) - normalHeight))));
                    this.writer.write(";width:");
                    this.writer.write(this.toSizeUnit((int)normalWidth));
                    this.writer.write(";height:");
                    this.writer.write(this.toSizeUnit((int)normalHeight));
                    this.writer.write(";clip:rect(");
                    this.writer.write(this.toSizeUnit((int)((double)yAlignFactor * (normalHeight - (double)availableImageHeight + (double)heightDiff))));
                    this.writer.write(",");
                    this.writer.write(this.toSizeUnit((int)((double)xAlignFactor * normalWidth + (double)((1.0f - xAlignFactor) * (float)(availableImageWidth - widthDiff)))));
                    this.writer.write(",");
                    this.writer.write(this.toSizeUnit((int)((double)yAlignFactor * normalHeight + (double)((1.0f - yAlignFactor) * (float)(availableImageHeight - heightDiff)))));
                    this.writer.write(",");
                    this.writer.write(this.toSizeUnit((int)((double)xAlignFactor * (normalWidth - (double)availableImageWidth + (double)widthDiff))));
                    this.writer.write(")\"");
                    break;
                }
                default: {
                    Dimension2D dimension;
                    Renderable tmpRenderer;
                    double normalWidth = availableImageWidth;
                    double normalHeight = availableImageHeight;
                    if (!isLazy && (tmpRenderer = RenderableUtil.getInstance(this.jasperReportsContext).getOnErrorRendererForDimension(this.renderersCache, renderer, image.getOnErrorTypeValue())) instanceof DimensionRenderable && (dimension = ((DimensionRenderable)((Object)tmpRenderer)).getDimension(this.jasperReportsContext)) != null) {
                        normalWidth = dimension.getWidth();
                        normalHeight = dimension.getHeight();
                    }
                    int leftDiff = 0;
                    int topDiff = 0;
                    int widthDiff = 0;
                    int heightDiff = 0;
                    JRLineBox box = image.getLineBox();
                    if (box != null) {
                        leftDiff = box.getLeftPadding();
                        topDiff = box.getTopPadding();
                        widthDiff = this.getInsideBorderOffset(box.getLeftPen().getLineWidth().floatValue(), false) + this.getInsideBorderOffset(box.getRightPen().getLineWidth().floatValue(), true);
                        heightDiff = this.getInsideBorderOffset(box.getTopPen().getLineWidth().floatValue(), false) + this.getInsideBorderOffset(box.getBottomPen().getLineWidth().floatValue(), true);
                    }
                    if (availableImageHeight <= 0) break;
                    double ratio = normalWidth / normalHeight;
                    if (ratio > (double)availableImageWidth / (double)availableImageHeight) {
                        this.writer.write(" style=\"position:absolute;left:");
                        this.writer.write(this.toSizeUnit(leftDiff));
                        this.writer.write(";top:");
                        this.writer.write(this.toSizeUnit((int)((double)topDiff + (double)yAlignFactor * ((double)(availableImageHeight - heightDiff) - (double)(availableImageWidth - widthDiff) / ratio))));
                        this.writer.write(";width:");
                        this.writer.write(this.toSizeUnit(availableImageWidth - widthDiff));
                        this.writer.write("\"");
                        break;
                    }
                    this.writer.write(" style=\"position:absolute;left:");
                    this.writer.write(this.toSizeUnit((int)((double)leftDiff + (double)xAlignFactor * ((double)(availableImageWidth - widthDiff) - ratio * (double)(availableImageHeight - heightDiff)))));
                    this.writer.write(";top:");
                    this.writer.write(this.toSizeUnit(topDiff));
                    this.writer.write(";height:");
                    this.writer.write(this.toSizeUnit(availableImageHeight - heightDiff));
                    this.writer.write("\"");
                }
            }
            if (imageMapName != null) {
                this.writer.write(" usemap=\"#" + imageMapName + "\"");
            }
            this.writer.write(" alt=\"\"");
            if (hasHyperlinks) {
                this.writer.write(" border=\"0\"");
            }
            if (image.getHyperlinkTooltip() != null) {
                this.writer.write(" title=\"");
                this.writer.write(JRStringUtil.xmlEncode(image.getHyperlinkTooltip()));
                this.writer.write("\"");
            }
            this.writer.write("/>");
            this.endHyperlink();
            if (imageMapAreas != null) {
                this.writer.write("\n");
                this.writeImageMap(imageMapName, image, imageMapAreas);
            }
        }
        this.writer.write("</span>\n");
    }

    protected JRPrintElementIndex getElementIndex() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.frameInfoStack.size(); ++i) {
            FrameInfo frameInfo = this.frameInfoStack.get(i);
            Integer frameIndex = frameInfo.elementIndex;
            sb.append(frameIndex).append("_");
        }
        JRPrintElementIndex imageIndex = new JRPrintElementIndex(this.reportIndex, this.pageIndex, sb.append(this.elementIndex).toString());
        return imageIndex;
    }

    protected void writeImageMap(String imageMapName, JRPrintImage image, List<JRPrintImageAreaHyperlink> imageMapAreas) throws IOException {
        this.writer.write("<map name=\"" + imageMapName + "\">\n");
        ListIterator<JRPrintImageAreaHyperlink> it = imageMapAreas.listIterator(imageMapAreas.size());
        while (it.hasPrevious()) {
            JRPrintImageAreaHyperlink areaHyperlink = it.previous();
            JRPrintImageArea area = areaHyperlink.getArea();
            this.writer.write("  <area shape=\"" + JRPrintImageArea.getHtmlShape(area.getShape()) + "\"");
            this.writeImageAreaCoordinates(area.getCoordinates());
            this.writeImageAreaHyperlink(areaHyperlink.getHyperlink());
            this.writer.write("/>\n");
        }
        if (image.getHyperlinkTypeValue() != HyperlinkTypeEnum.NONE) {
            this.writer.write("  <area shape=\"default\"");
            this.writeImageAreaCoordinates(new int[]{0, 0, image.getWidth(), image.getHeight()});
            this.writeImageAreaHyperlink(image);
            this.writer.write("/>\n");
        }
        this.writer.write("</map>\n");
    }

    protected void writeImageAreaCoordinates(int[] coords) throws IOException {
        if (coords != null && coords.length > 0) {
            StringBuilder coordsEnum = new StringBuilder(coords.length * 4);
            coordsEnum.append(this.toZoom(coords[0]));
            for (int i = 1; i < coords.length; ++i) {
                coordsEnum.append(',');
                coordsEnum.append(this.toZoom(coords[i]));
            }
            this.writer.write(" coords=\"" + coordsEnum + "\"");
        }
    }

    protected void writeImageAreaHyperlink(JRPrintHyperlink hyperlink) throws IOException {
        String href = this.getHyperlinkURL(hyperlink);
        if (href == null) {
            this.writer.write(" nohref=\"nohref\"");
        } else {
            this.writer.write(" href=\"" + href + "\"");
            String target = this.getHyperlinkTarget(hyperlink);
            if (target != null) {
                this.writer.write(" target=\"");
                this.writer.write(target);
                this.writer.write("\"");
            }
        }
        if (hyperlink.getHyperlinkTooltip() != null) {
            this.writer.write(" title=\"");
            this.writer.write(JRStringUtil.xmlEncode(hyperlink.getHyperlinkTooltip()));
            this.writer.write("\"");
        }
    }

    private boolean appendPadding(StringBuilder sb, Integer padding, String side) {
        boolean addedToStyle = false;
        if (padding > 0) {
            sb.append("padding");
            if (side != null) {
                sb.append("-");
                sb.append(side);
            }
            sb.append(": ");
            sb.append(this.toSizeUnit(padding));
            sb.append("; ");
            addedToStyle = true;
        }
        return addedToStyle;
    }

    private boolean appendPen(StringBuilder sb, JRPen pen, String side) {
        boolean addedToStyle = false;
        float borderWidth = pen.getLineWidth().floatValue();
        if (0.0f < borderWidth && borderWidth < 1.0f) {
            borderWidth = 1.0f;
        }
        String borderStyle = null;
        switch (pen.getLineStyleValue()) {
            case DOUBLE: {
                borderStyle = "double";
                break;
            }
            case DOTTED: {
                borderStyle = "dotted";
                break;
            }
            case DASHED: {
                borderStyle = "dashed";
                break;
            }
            default: {
                borderStyle = "solid";
            }
        }
        if (borderWidth > 0.0f) {
            sb.append("border");
            if (side != null) {
                sb.append("-");
                sb.append(side);
            }
            sb.append(": ");
            sb.append(this.toSizeUnit((int)borderWidth));
            sb.append(" ");
            sb.append(borderStyle);
            sb.append(" ");
            sb.append(JRColorUtil.getCssColor(pen.getLineColor()));
            sb.append("; ");
            addedToStyle = true;
        }
        return addedToStyle;
    }

    private void appendId(JRPrintElement element) throws IOException {
        String dataAttr = this.getDataAttributes(element);
        if (dataAttr != null) {
            this.writer.write(dataAttr);
        }
    }

    public String getDataAttributes(JRPrintElement element) {
        String cellId;
        String columnUuid;
        String clazz;
        StringBuilder sb = new StringBuilder();
        String id = this.getPropertiesUtil().getProperty(element, "net.sf.jasperreports.export.html.id");
        if (id != null) {
            sb.append(" id=\"" + id + "\"");
        }
        if ((clazz = this.getPropertiesUtil().getProperty(element, "net.sf.jasperreports.export.html.class")) != null) {
            sb.append(" class=\"" + clazz + "\"");
        }
        if ((columnUuid = this.getPropertiesUtil().getProperty(element, "net.sf.jasperreports.export.headertoolbar.columnUUID")) != null) {
            sb.append(" data-coluuid=\"" + columnUuid + "\"");
        }
        if ((cellId = this.getPropertiesUtil().getProperty(element, "net.sf.jasperreports.export.headertoolbar.cellID")) != null) {
            sb.append(" data-cellid=\"" + cellId + "\"");
        }
        return sb.length() > 0 ? sb.toString() : null;
    }

    private void setPageLimits(List<JRPrintElement> elements) throws IOException, JRException {
        if (elements != null && elements.size() > 0) {
            for (int i = 0; i < elements.size(); ++i) {
                this.elementIndex = i;
                JRPrintElement element = elements.get(i);
                if (this.filter != null && !this.filter.isToExport(element)) continue;
                this.topLimit = element.getY() < this.topLimit ? element.getY() : this.topLimit;
                this.leftLimit = element.getX() < this.leftLimit ? element.getX() : this.leftLimit;
                this.rightLimit = element.getX() + element.getWidth() > this.rightLimit ? element.getX() + element.getWidth() : this.rightLimit;
                this.bottomLimit = element.getY() + element.getHeight() > this.bottomLimit ? element.getY() + element.getHeight() : this.bottomLimit;
            }
        }
    }

    public void exportFrame(JRPrintFrame frame) throws IOException, JRException {
        this.writer.write("<div");
        this.appendId(frame);
        StringBuilder styleBuilder = new StringBuilder();
        this.appendPositionStyle((JRPrintElement)frame, frame, styleBuilder);
        this.appendSizeStyle((JRPrintElement)frame, frame, styleBuilder);
        this.appendBackcolorStyle(frame, styleBuilder);
        this.appendBorderStyle(frame.getLineBox(), styleBuilder);
        if (styleBuilder.length() > 0) {
            this.writer.write(" style=\"");
            this.writer.write(styleBuilder.toString());
            this.writer.write("\"");
        }
        if (frame.getPropertiesMap() != null && frame.getPropertiesMap().containsProperty("net.sf.jasperreports.export.headertoolbar.tableUUID")) {
            this.writer.write(" data-uuid=\"");
            this.writer.write(frame.getPropertiesMap().getProperty("net.sf.jasperreports.export.headertoolbar.tableUUID"));
            this.writer.write("\"");
            this.writer.write(" class=\"jrtableframe\"");
        }
        this.writer.write(">\n");
        FrameInfo frameInfo = new FrameInfo();
        frameInfo.elementIndex = this.elementIndex;
        JRLineBox box = frame.getLineBox();
        if (box != null) {
            frameInfo.leftInsideBorderOffset = -box.getLeftPadding().intValue() + this.getInsideBorderOffset(box.getLeftPen().getLineWidth().floatValue(), false);
            frameInfo.topInsideBorderOffset = -box.getTopPadding().intValue() + this.getInsideBorderOffset(box.getTopPen().getLineWidth().floatValue(), false);
        }
        this.frameInfoStack.add(frameInfo);
        this.exportElements(frame.getElements());
        this.frameInfoStack.remove(this.frameInfoStack.size() - 1);
        this.writer.write("</div>\n");
    }

    protected void exportGenericElement(JRGenericPrintElement element) throws IOException {
        String htmlFragment;
        GenericElementHtmlHandler handler = (GenericElementHtmlHandler)GenericElementHandlerEnviroment.getInstance(this.getJasperReportsContext()).getElementHandler(element.getGenericType(), XHTML_EXPORTER_KEY);
        if (handler == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No XHTML generic element handler for " + element.getGenericType()));
            }
        } else if (handler.toExport(element) && (htmlFragment = handler.getHtmlFragment((JRHtmlExporterContext)this.exporterContext, element)) != null) {
            this.writer.write(htmlFragment);
        }
    }

    public Map<JRExporterParameter, Object> getExportParameters() {
        return this.parameters;
    }

    @Override
    public String getExporterPropertiesPrefix() {
        return XHTML_EXPORTER_PROPERTIES_PREFIX;
    }

    public JasperPrint getExportedReport() {
        return this.jasperPrint;
    }

    public String toSizeUnit(float size) {
        Number number = Float.valueOf(this.toZoom(size));
        if ((float)((Number)number).intValue() == ((Number)number).floatValue()) {
            number = ((Number)number).intValue();
        }
        return String.valueOf(number) + ((HtmlReportConfiguration)this.getCurrentItemConfiguration()).getSizeUnit().getName();
    }

    public String toSizeUnit(int size) {
        return this.toSizeUnit((float)size);
    }

    public float toZoom(float size) {
        float zoom = 1.0f;
        Float zoomRatio = ((HtmlReportConfiguration)this.getCurrentItemConfiguration()).getZoomRatio();
        if (zoomRatio != null && (zoom = zoomRatio.floatValue()) <= 0.0f) {
            throw new JRRuntimeException("export.common.invalid.zoom.ratio", new Object[]{Float.valueOf(zoom)});
        }
        return zoom * size;
    }

    public int toZoom(int size) {
        return (int)this.toZoom((float)size);
    }

    @Override
    public String getExporterKey() {
        return XHTML_EXPORTER_KEY;
    }

    private static class FrameInfo {
        protected int elementIndex;
        protected int leftInsideBorderOffset;
        protected int topInsideBorderOffset;

        private FrameInfo() {
        }
    }

    protected class ExporterContext
    extends JRAbstractExporter.BaseExporterContext
    implements JRHtmlExporterContext {
        protected ExporterContext() {
        }

        @Override
        public String getExportPropertiesPrefix() {
            return JRXhtmlExporter.XHTML_EXPORTER_PROPERTIES_PREFIX;
        }

        @Override
        public String getHyperlinkURL(JRPrintHyperlink link) {
            return JRXhtmlExporter.this.getHyperlinkURL(link);
        }
    }
}

