/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.au.http;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.zkoss.lang.Generics;
import org.zkoss.util.media.Media;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuRequests;
import org.zkoss.zk.au.AuService;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.UploadEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadInfoService
implements AuService,
Serializable {
    private UploadInfoService() {
    }

    private static Media[] parseResult(List<Media> result) {
        if (result != null) {
            Iterator<Media> it = result.iterator();
            while (it.hasNext()) {
                byte[] bs;
                String nm;
                Media media = it.next();
                if (media == null || !media.inMemory() || !media.isBinary() || (nm = media.getName()) != null && nm.length() != 0 || (bs = media.getByteData()) != null && bs.length != 0) continue;
                it.remove();
            }
            if (!result.isEmpty()) {
                return result.toArray(new Media[result.size()]);
            }
        }
        return null;
    }

    @Override
    public boolean service(AuRequest request, boolean everError) {
        if ("updateResult".equals(request.getCommand())) {
            Map<String, Object> data = request.getData();
            Desktop desktop = request.getDesktop();
            String uuid = (String)request.getData().get("wid");
            Component comp = desktop.getComponentByUuidIfAny(uuid);
            String sid = (String)request.getData().get("sid");
            if (comp == null) {
                Map percent = Generics.cast((Map)((Map)desktop.getAttribute("org.zkoss.zk.upload.percent")));
                Map size = Generics.cast((Map)((Map)desktop.getAttribute("org.zkoss.zk.upload.size")));
                String key = uuid + '_' + sid;
                if (percent != null) {
                    percent.remove(key);
                    size.put(key, "Upload Aborted");
                }
                return false;
            }
            List result = Generics.cast((List)((List)AuRequests.getUpdateResult(request)));
            Events.postEvent(new UploadEvent("onUpload", comp, UploadInfoService.parseResult(result)));
            Map percent = (Map)desktop.getAttribute("org.zkoss.zk.upload.percent");
            Map size = (Map)desktop.getAttribute("org.zkoss.zk.upload.size");
            String key = uuid + '_' + sid;
            percent.remove(key);
            size.remove(key);
            return true;
        }
        return false;
    }

    public static class DesktopInit
    implements org.zkoss.zk.ui.util.DesktopInit {
        public void init(Desktop desktop, Object request) {
            desktop.addListener(new UploadInfoService());
        }
    }
}

