/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.impl;

import java.io.Serializable;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.impl.SimpleDesktopCache;
import org.zkoss.zk.ui.sys.DesktopCache;
import org.zkoss.zk.ui.sys.DesktopCacheProvider;

public class GlobalDesktopCacheProvider
implements DesktopCacheProvider,
Serializable {
    private static final String ATTR_CACHE = "javax.zkoss.zk.desktop-cache";
    private static final long serialVersionUID = 20060622L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DesktopCache getDesktopCache(Session sess) {
        WebApp wapp = sess.getWebApp();
        DesktopCache dc = (DesktopCache)wapp.getAttribute(ATTR_CACHE);
        if (dc == null) {
            GlobalDesktopCacheProvider globalDesktopCacheProvider = this;
            synchronized (globalDesktopCacheProvider) {
                dc = (DesktopCache)wapp.getAttribute(ATTR_CACHE);
                if (dc == null) {
                    dc = new SimpleDesktopCache(sess.getWebApp().getConfiguration());
                    wapp.setAttribute(ATTR_CACHE, dc);
                }
            }
        }
        return dc;
    }

    public void sessionDestroyed(Session sess) {
    }

    public void sessionWillPassivate(Session sess) {
        DesktopCache dc = (DesktopCache)sess.getAttribute(ATTR_CACHE);
        if (dc != null) {
            dc.sessionWillPassivate(sess);
        }
    }

    public void sessionDidActivate(Session sess) {
        DesktopCache dc = (DesktopCache)sess.getAttribute(ATTR_CACHE);
        if (dc != null) {
            dc.sessionDidActivate(sess);
        }
    }

    public void start(WebApp wapp) {
    }

    public void stop(WebApp wapp) {
        DesktopCache dc = (DesktopCache)wapp.getAttribute(ATTR_CACHE);
        if (dc != null) {
            wapp.removeAttribute(ATTR_CACHE);
            dc.stop();
        }
    }
}

