/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.metainfo;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.zkoss.lang.Objects;
import org.zkoss.util.ArraysX;
import org.zkoss.util.resource.Location;
import org.zkoss.zk.ui.metainfo.Annotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationMap
implements Cloneable,
Serializable {
    private Map<String, Map<String, List<Annotation>>> _annots;

    public boolean isEmpty() {
        return this._annots == null || this._annots.isEmpty();
    }

    public Annotation getAnnotation(String propName, String annotName) {
        List<Annotation> ans;
        Map<String, List<Annotation>> anmap;
        if (this._annots != null && (anmap = this._annots.get(propName)) != null && (ans = anmap.get(annotName)) != null) {
            if (ans.size() == 1) {
                return ans.get(0);
            }
            AnnotImpl ai = new AnnotImpl(annotName, null);
            for (Annotation an : ans) {
                if (ai._loc == null) {
                    ai._loc = an.getLocation();
                }
                ai.addAttributes(an);
            }
            return ai;
        }
        return null;
    }

    public Collection<Annotation> getAnnotations(String propName, String annotName) {
        List<Annotation> ans;
        Map<String, List<Annotation>> anmap;
        if (this._annots != null && (anmap = this._annots.get(propName)) != null && (ans = anmap.get(annotName)) != null) {
            return ans;
        }
        return Collections.emptyList();
    }

    public Collection<Annotation> getAnnotations(String propName) {
        Map<String, List<Annotation>> anmap;
        if (this._annots != null && (anmap = this._annots.get(propName)) != null) {
            LinkedList<Annotation> dst = new LinkedList<Annotation>();
            for (List<Annotation> ans : anmap.values()) {
                dst.addAll(ans);
            }
            return dst;
        }
        return Collections.emptyList();
    }

    public List<String> getAnnotatedPropertiesBy(String annotName) {
        if (this._annots != null) {
            LinkedList<String> list = new LinkedList<String>();
            for (Map.Entry<String, Map<String, List<Annotation>>> me : this._annots.entrySet()) {
                Map<String, List<Annotation>> anmap;
                String propName = me.getKey();
                if (propName == null || !(anmap = me.getValue()).containsKey(annotName)) continue;
                list.add(propName);
            }
            return list;
        }
        return Collections.emptyList();
    }

    public List<String> getAnnotatedProperties() {
        LinkedList<String> list = new LinkedList<String>();
        if (this._annots != null) {
            for (String propName : this._annots.keySet()) {
                if (propName == null) continue;
                list.add(propName);
            }
        }
        return list;
    }

    public void addAll(AnnotationMap src) {
        if (src != null && !src.isEmpty()) {
            this.initAnnots();
            for (Map.Entry<String, Map<String, List<Annotation>>> me : src._annots.entrySet()) {
                String propName = me.getKey();
                Map<String, List<Annotation>> anmap = this._annots.get(propName);
                if (anmap == null) {
                    anmap = new LinkedHashMap<String, List<Annotation>>(4);
                    this._annots.put(propName, anmap);
                }
                AnnotationMap.addAllAns(anmap, me.getValue());
            }
        }
    }

    private static void addAllAns(Map<String, List<Annotation>> anmap, Map<String, List<Annotation>> srcanmap) {
        for (Map.Entry<String, List<Annotation>> me : srcanmap.entrySet()) {
            String annotName = me.getKey();
            List<Annotation> ans = anmap.get(annotName);
            if (ans == null) {
                ans = new LinkedList<Annotation>();
                anmap.put(annotName, ans);
            }
            ans.addAll((Collection<Annotation>)me.getValue());
        }
    }

    public void addAnnotation(String propName, String annotName, Map<String, String[]> annotAttrs, Location loc) {
        List<Annotation> ans;
        this.initAnnots();
        Map<String, List<Annotation>> anmap = this._annots.get(propName);
        if (anmap == null) {
            anmap = new LinkedHashMap<String, List<Annotation>>(4);
            this._annots.put(propName, anmap);
        }
        if ((ans = anmap.get(annotName)) == null) {
            ans = new LinkedList<Annotation>();
            anmap.put(annotName, ans);
        }
        ans.add(new AnnotImpl(annotName, annotAttrs, loc));
    }

    private void initAnnots() {
        if (this._annots == null) {
            this._annots = new LinkedHashMap<String, Map<String, List<Annotation>>>(4);
        }
    }

    public Object clone() {
        AnnotationMap clone;
        try {
            clone = (AnnotationMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        if (this._annots != null) {
            clone._annots = new LinkedHashMap<String, Map<String, List<Annotation>>>(this._annots);
            for (Map.Entry<String, Map<String, List<Annotation>>> me : clone._annots.entrySet()) {
                LinkedHashMap<String, List<Annotation>> anmap = new LinkedHashMap<String, List<Annotation>>(4);
                AnnotationMap.addAllAns(anmap, me.getValue());
                me.setValue(anmap);
            }
        }
        return clone;
    }

    public String toString() {
        return "[annot:" + this._annots + ']';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AnnotImpl
    implements Annotation {
        private final String _name;
        private Map<String, String[]> _attrs;
        private Location _loc;

        private AnnotImpl(String name, Location loc) {
            this._name = name;
            this._loc = loc;
        }

        private AnnotImpl(String name, Map<String, String[]> attrs, Location loc) {
            this._name = name;
            this._loc = loc;
            this.addAttributes(attrs);
        }

        private void addAttribute(String name, String[] value) {
            if (name == null || name.length() == 0) {
                name = "value";
            }
            if (value == null) {
                value = new String[]{};
            }
            if (this._attrs == null) {
                this._attrs = new LinkedHashMap<String, String[]>(4);
            } else {
                Object[] oldval = this._attrs.get(name);
                if (oldval != null) {
                    value = (String[])ArraysX.concat((Object[])oldval, (Object[])value);
                }
            }
            this._attrs.put(name, value);
        }

        private void addAttributes(Map<String, String[]> attrs) {
            if (attrs != null) {
                for (Map.Entry<String, String[]> me : attrs.entrySet()) {
                    this.addAttribute(me.getKey(), me.getValue());
                }
            }
        }

        private void addAttributes(Annotation an) {
            if (an != null) {
                this.addAttributes(((AnnotImpl)an)._attrs);
            }
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public Map<String, String[]> getAttributes() {
            if (this._attrs != null) {
                return this._attrs;
            }
            return Collections.emptyMap();
        }

        @Override
        public String getAttribute(String name) {
            if (this._attrs != null) {
                String[] val = this._attrs.get(name);
                return val != null && val.length > 0 ? val[0] : null;
            }
            return null;
        }

        @Override
        public String[] getAttributeValues(String name) {
            return this._attrs != null ? this._attrs.get(name) : null;
        }

        @Override
        public Location getLocation() {
            return this._loc;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer().append('@').append(this._name).append('(');
            if (this._attrs != null) {
                boolean first = true;
                for (Map.Entry<String, String[]> me : this._attrs.entrySet()) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(me.getKey()).append('=').append(Objects.toString((Object)me.getValue()));
                }
            }
            return sb.append(')').toString();
        }
    }
}

