/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.sys;

import java.util.LinkedList;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.ShadowElement;
import org.zkoss.zk.ui.ShadowElementCtrl;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.sys.ComponentCtrl;

public class ShadowElementsCtrl {
    private static final ThreadLocal<Object> _shadowInfo = new ThreadLocal();
    private static final ThreadLocal<Object> _distributedIndexInfo = new ThreadLocal();

    public static final void setCurrentInfo(Object shadowInfo) {
        _shadowInfo.set(shadowInfo);
    }

    public static final Object getCurrentInfo() {
        return _shadowInfo.get();
    }

    public static final void setDistributedIndexInfo(Object indexMapInfo) {
        _distributedIndexInfo.set(indexMapInfo);
    }

    public static final Object getDistributedIndexInfo() {
        return _distributedIndexInfo.get();
    }

    public static final Component[] filterOutShadows(Component[] shadows) {
        if (shadows == null || shadows.length == 0) {
            return shadows;
        }
        int length = shadows.length;
        for (Component shadow : shadows) {
            ShadowElement se;
            if (!(shadow instanceof ShadowElement) || !(se = (ShadowElement)((Object)shadow)).getDistributedChildren().isEmpty() || !((ShadowElementCtrl)((Object)se)).isDynamicValue()) continue;
            Events.sendEvent(new Event("onBindInit", (Component)((Object)se)));
            Events.sendEvent(new Event("onBindingReady", (Component)((Object)se)));
        }
        if (length == 1) {
            if (shadows[0] instanceof ShadowElement) {
                ShadowElement se = (ShadowElement)((Object)shadows[0]);
                return se.getDistributedChildren().toArray(new Component[0]);
            }
        } else {
            ComponentCtrl pCtrl;
            Component parent = null;
            Component start = null;
            if (shadows[0] instanceof ShadowElementCtrl) {
                ShadowElementCtrl se = (ShadowElementCtrl)((Object)shadows[0]);
                start = se.getFirstInsertion();
            } else {
                start = shadows[0];
                parent = start.getParent();
            }
            if (parent instanceof ComponentCtrl && (pCtrl = (ComponentCtrl)((Object)parent)).getShadowRoots().isEmpty()) {
                return shadows;
            }
            Component end = shadows[length - 1];
            if (end instanceof ShadowElementCtrl) {
                ShadowElementCtrl se = (ShadowElementCtrl)((Object)end);
                end = se.getLastInsertion();
            }
            LinkedList<Component> list = new LinkedList<Component>();
            while (start != null) {
                list.add(start);
                if (start == end) break;
                start = start.getNextSibling();
            }
            return list.toArray(new Component[0]);
        }
        return shadows;
    }
}

