/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.proxy;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.annotation.ImmutableFields;
import org.zkoss.bind.annotation.Transient;
import org.zkoss.bind.impl.AllocUtil;
import org.zkoss.bind.proxy.FormProxyObject;
import org.zkoss.bind.proxy.ProxyHelper;
import org.zkoss.bind.xel.zel.BindELContext;
import org.zkoss.lang.Classes;
import org.zkoss.zk.ui.UiException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanProxyHandler<T>
implements MethodHandler,
Serializable {
    protected static MethodFilter BEAN_METHOD_FILTER = new MethodFilter(){

        public boolean isHandled(Method m) {
            if (m.isAnnotationPresent(Transient.class)) {
                return false;
            }
            String name = m.getName();
            if (name.startsWith("set")) {
                try {
                    String getter = BeanProxyHandler.toGetter(BeanProxyHandler.toAttrName(m));
                    Method getMethod = Classes.getMethodByObject(m.getDeclaringClass(), (String)getter, null);
                    if (getMethod.isAnnotationPresent(Transient.class)) {
                        return false;
                    }
                }
                catch (NoSuchMethodException getter) {
                    // empty catch block
                }
                return true;
            }
            if (name.startsWith("get") || name.startsWith("is") || name.equals("hashCode") || name.equals("equals")) {
                return true;
            }
            try {
                FormProxyObject.class.getMethod(m.getName(), m.getParameterTypes());
                return true;
            }
            catch (NoSuchMethodException e) {
                return false;
            }
        }
    };
    protected T _origin;
    protected Map<String, Object> _cache;
    protected Set<String> _dirtyFieldNames;

    public BeanProxyHandler(T origin) {
        this._origin = origin;
    }

    private void addCache(String key, Object value) {
        this._cache = AllocUtil.inst.putMap(this._cache, key, value);
    }

    private void addDirtyField(String field) {
        this._dirtyFieldNames = AllocUtil.inst.addSet(this._dirtyFieldNames, field);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(Object self, Method method, Method proceed, Object[] args) throws Exception {
        boolean dirty;
        block29: {
            Iterator<Map.Entry<String, Object>> i$;
            block28: {
                Iterator<Map.Entry<String, Object>> i$2;
                block27: {
                    try {
                        String mname = method.getName();
                        if (mname.equals("hashCode")) {
                            int a = this._origin != null ? (Integer)method.invoke(this._origin, args) : 0;
                            return 1147 + a;
                        }
                        if (mname.equals("equals")) {
                            boolean bl;
                            if (this._origin != null) {
                                if (this._origin instanceof FormProxyObject) {
                                    return method.invoke(((FormProxyObject)this._origin).getOriginObject(), args);
                                }
                                if (args.length != 1) return method.invoke(this._origin, args);
                                if (!(args[0] instanceof FormProxyObject)) return method.invoke(this._origin, args);
                                return method.invoke(this._origin, ((FormProxyObject)args[0]).getOriginObject());
                            }
                            if (args.length == 1 && args[0] == null) {
                                bl = true;
                                return bl;
                            }
                            bl = false;
                            return bl;
                        }
                        if (method.getDeclaringClass().isAssignableFrom(FormProxyObject.class)) {
                            if ("submitToOrigin".equals(mname)) {
                                if (this._dirtyFieldNames == null) return null;
                                if (this._origin == null) return null;
                                i$2 = this._cache.entrySet().iterator();
                                break block27;
                            }
                            if ("getOriginObject".equals(mname)) {
                                return this._origin;
                            }
                            if ("resetFromOrigin".equals(mname)) {
                                if (this._dirtyFieldNames != null) {
                                    this._dirtyFieldNames.clear();
                                }
                                if (this._cache == null) return null;
                                this._cache.clear();
                                return null;
                            }
                            if (!"isFormDirty".equals(mname)) {
                                if (!"addFormProxyObjectListener".equals(mname)) throw new IllegalAccessError("Not implemented yet for FormProxyObject interface: [" + mname + "]");
                                return null;
                            }
                            dirty = false;
                            if (this._dirtyFieldNames == null) return dirty;
                            if (this._cache == null) return dirty;
                            i$ = this._cache.entrySet().iterator();
                            break block28;
                        }
                        if (mname.startsWith("get")) {
                            if (this._origin == null) {
                                return null;
                            }
                            String attr = BeanProxyHandler.toAttrName(method);
                            if (this._cache != null && this._cache.containsKey(attr)) {
                                return this._cache.get(attr);
                            }
                            Object value = method.invoke(this._origin, args);
                            if (value == null) return value;
                            if (this._origin.getClass().getAnnotation(ImmutableFields.class) == null && !(self instanceof ImmutableFields)) {
                                value = ProxyHelper.createProxyIfAny(value, method.getAnnotations());
                            }
                            this.addCache(attr, value);
                            if (!(value instanceof FormProxyObject)) return value;
                            this.addDirtyField(attr);
                            return value;
                        }
                        if (!mname.startsWith("is")) {
                            String attrName = BeanProxyHandler.toAttrName(method);
                            this.addCache(attrName, args[0]);
                            this.addDirtyField(attrName);
                            return null;
                        }
                        if (this._origin == null) {
                            return false;
                        }
                        String attr = BeanProxyHandler.toAttrName(method, 2);
                        if (this._cache == null) return method.invoke(this._origin, args);
                        if (!this._cache.containsKey(attr)) return method.invoke(this._origin, args);
                        return this._cache.get(attr);
                    }
                    catch (Exception e) {
                        throw UiException.Aide.wrap((Throwable)e);
                    }
                }
                while (true) {
                    if (!i$2.hasNext()) {
                        this._dirtyFieldNames.clear();
                        return null;
                    }
                    Map.Entry<String, Object> me = i$2.next();
                    Object value = me.getValue();
                    if (value instanceof FormProxyObject) {
                        ((FormProxyObject)value).submitToOrigin((BindContext)args[0]);
                        continue;
                    }
                    if (!this._dirtyFieldNames.contains(me.getKey())) continue;
                    String setter = BeanProxyHandler.toSetter(me.getKey());
                    try {
                        Method m = Classes.getMethodByObject(this._origin.getClass(), (String)setter, (Object[])new Object[]{value});
                        m.invoke(this._origin, Classes.coerce(m.getParameterTypes()[0], (Object)value));
                        BindELContext.addNotifys(m, this._origin, me.getKey(), value, (BindContext)args[0]);
                    }
                    catch (NoSuchMethodException e) {
                        throw UiException.Aide.wrap((Throwable)e);
                    }
                }
            }
            while (i$.hasNext()) {
                Map.Entry<String, Object> me = i$.next();
                Object value = me.getValue();
                if (value instanceof FormProxyObject) {
                    if (!((FormProxyObject)value).isFormDirty()) continue;
                    dirty = true;
                    return dirty;
                }
                if (!this._dirtyFieldNames.contains(me.getKey())) {
                    continue;
                }
                break block29;
            }
            return dirty;
        }
        dirty = true;
        return dirty;
    }

    protected static String toSetter(String attr) {
        return BeanProxyHandler.capitalize("set", attr);
    }

    protected static String toGetter(String attr) {
        return BeanProxyHandler.capitalize("get", attr);
    }

    protected static String capitalize(String prefix, String attr) {
        return prefix + Character.toUpperCase(attr.charAt(0)) + attr.substring(1);
    }

    protected static String toAttrName(Method method, int prefix) {
        String name = method.getName();
        String attrName = name.substring(prefix, name.length());
        return new StringBuilder(attrName.length()).append(Character.toLowerCase(attrName.charAt(0))).append(attrName.substring(1)).toString();
    }

    protected static String toAttrName(Method method) {
        return BeanProxyHandler.toAttrName(method, 3);
    }
}

