
(function () {
	function _colspan(c) { 
		var v = zk.Widget.$(c)._colspan;
		return v ? v : 1;
	}
	
	function _onSizeLater(wgt) {		
		var parent = wgt.parent,
			bdfaker = parent.ebdfaker;
		
		
		if (parent.eheadtbl && parent._nativebar) {
			var cells = parent._getFirstRowCells(parent.eheadrows),
				totalcols = cells.length,
				cellsSize = totalcols,
				columns = wgt._columns,
				leftWidth = 0;
			
			
			if (!cells || cellsSize <= 0) {
				
				return;
			}
			
			
			for (var hdcol = parent.ehdfaker.firstChild; hdcol; hdcol = hdcol.nextSibling) {
				var style = hdcol.style;
				if (style.visibility == 'hidden' || style.display == 'none' )
					totalcols -= 1;
			}
			for (var i = 0; i < columns; i++)
					leftWidth += cells[i].offsetWidth;
			
			parent._deleteFakeRow(parent.eheadrows);
			
			wgt.$n('cave').style.width = jq.px0(leftWidth);
			var scroll = wgt.$n('scrollX'),
				width = parent.$n('body').offsetWidth;
			
			
			parent.$n('frozen').style.width = jq.px0(width);
			width -= leftWidth;
			scroll.style.width = jq.px0(width);
			var scrollScale = totalcols - columns - 1; 
			scroll.firstChild.style.width = jq.px0(width + 50 * scrollScale);
			wgt.syncScroll();
		}
	}
	

zul.mesh.Frozen = zk.$extends(zul.Widget, {
	_start: 0,
	_scrollScale: 0,
	$define: {
    	
    	
		columns: [function(v) {
			return v < 0 ? 0 : v;
		}, function(v) {
			if (this._columns) {
				if (this.desktop) {
					this.onSize();
					this.syncScroll();
				}
			} else this.rerender();
		}],
		
		
		start: function () {
			this.syncScroll();
		}
	},
	
	syncScroll: function () {
		var p = this.parent;
		if (p && p._nativebar) {
			var scroll = this.$n('scrollX');
			if (scroll)
				scroll.scrollLeft = this._start * 50;
		}
	},

	
	syncScrollByParentBody: function () {
		var p = this.parent,
			ebody,
			l;
    	if (p && p._nativebar && (ebody = p.ebody) && (l = ebody.scrollLeft) > 0) {
    		var scroll = this.$n('scrollX');
        	if (scroll) {
        		var scrollScale = l / (ebody.scrollWidth - ebody.clientWidth);
        		scroll.scrollLeft = Math.ceil(scrollScale * (scroll.scrollWidth - scroll.clientWidth));
        	}
		}
	},

	bind_: function () {
		this.$supers(zul.mesh.Frozen, 'bind_', arguments);
		var p = this.parent,
			body = p.$n('body'),
			foot = p.$n('foot');

		if (p._nativebar) {
			
			zWatch.listen({onSize: this});
			var scroll = this.$n('scrollX'),
				scrollbarWidth = jq.scrollbarWidth();
			
			this.$n().style.height = this.$n('cave').style.height = scroll.style.height
				 = scroll.firstChild.style.height = jq.px0(zk.ie ? scrollbarWidth + 1 : scrollbarWidth);
			p._currentLeft = 0;
			this.domListen_(scroll, 'onScroll');

			var head = p.$n('head');
			if (head)
				this.domListen_(head, 'onScroll', '_doHeadScroll');
			
		} else {
			
			this._shallSyncScale = true;
		}
		
		zWatch.listen({onResponse: this});
		if (body)
			jq(body).addClass('z-word-nowrap');
		if (foot)
			jq(foot).addClass('z-word-nowrap');
	},
	unbind_: function () {
		var p = this.parent,
			body = p.$n('body'),
			foot = p.$n('foot'),
			head = p.$n('head');
		
		if (p._nativebar) {
			this.domUnlisten_(this.$n('scrollX'), 'onScroll');
			p.unlisten({onScroll: this.proxy(this._onScroll)});
			zWatch.unlisten({onSize: this});

			if (head)
				this.domUnlisten_(head, 'onScroll', '_doHeadScroll');
		} else {
			this._shallSyncScale = false;
		}
		
		zWatch.unlisten({onResponse: this});
		if (body)
			jq(body).removeClass('z-word-nowrap');
		if (foot)
			jq(foot).removeClass('z-word-nowrap');
		this.$supers(zul.mesh.Frozen, 'unbind_', arguments);
	},
	
	onResponse: function () {
		if (this.parent._nativebar) {
			
			this._syncFrozenNow();
		} else if (this._shallSyncScale) {
			var hdfaker = this.parent.ehdfaker;
			if (hdfaker) {
				this._scrollScale = 
					hdfaker.childNodes.length - this._columns - 1;
			}
			this._shallSyncScale = false;
		}
	},
	onSize: function () {
		if (!this._columns)
			return;
		var self = this;
		self._syncFrozen(); 
		
		
		var p = this.parent, 
			phead = p.head, 
			firstHdcell, fhcs;
		if (p._nativebar && phead) {
			
			
			var n = phead.$n();
			firstHdcell = n? (n.cells? n.cells[0]: null) : null;
			
			if (firstHdcell) {
				fhcs = firstHdcell.style;
				if (!fhcs.height)
					fhcs.height = firstHdcell.offsetHeight+'px';
			}
		}
		
		
		setTimeout(function () {
			_onSizeLater(self);
			self._syncFrozenNow();
		});
	},
	_syncFrozen: function () { 
		this._shallSync = true;
	},
	_syncFrozenNow: function () {
		var num = this._start;
		if (this._shallSync && num)
			this._doScrollNow(num, true);
		
		this._shallSync = false;
	},
	beforeParentChanged_: function (p) {
		
		
		if (this.desktop && this._lastScale) 
			this._doScroll(0);
		
		this.$supers('beforeParentChanged_', arguments);
	},
	_onScroll: function (evt) {
		if (!evt.data || !zk.currentFocus)
			return;
		
		var p = this.parent,
			td,
			frozen = this,
			fn = function () {
				var cf = zk.currentFocus;
				if (cf) {
					td = p.getFocusCell(cf.$n());
					if (td && (index = td.cellIndex - frozen._columns) >= 0) {
						frozen.setStart(index);
						p.ebody.scrollLeft = 0;

						if (p.ehead)
							p.ehead.scrollLeft = 0;
					}
				}
			};
		if (p) {
			if (zk.ie < 11)
				setTimeout(fn, 0);
			else
				fn();
		}
		evt.stop();
	},
	_doHeadScroll: function (evt) {
		var head = evt.domTarget,
			num = Math.ceil(head.scrollLeft / 50);
		
		if (!head.scrollLeft || this._lastScale == num)
			return;
		evt.data = head.scrollLeft;
		this._onScroll(evt);
	},
	_doScroll: function (n) {
		var p = this.parent, num;
		if (p._nativebar)
			num = Math.ceil(this.$n('scrollX').scrollLeft / 50);
		else
			num = Math.ceil(n);
		if (this._lastScale == num)
			return;
		this._lastScale = num;
		this._doScrollNow(num);
		this.smartUpdate('start', num);
		this._start = num;
	},
	_doScrollNow: function (num, force) {
		var totalWidth = 0,
			mesh = this.parent,
			cnt = num,
			rows = mesh.ebodyrows,
			c = this._columns;

		if (mesh.head) {
			
			var totalCols = mesh.head.nChildren,
				hdrows = mesh.eheadrows.rows,
				
				hdcells = mesh.head.$n().cells,
				hdcol = mesh.ehdfaker.firstChild,
				ftrows = mesh.foot ? mesh.efootrows : null,
				ftcells = ftrows ? ftrows.rows[0].cells : null;
			
			for (var faker, i = 0; hdcol && i < totalCols; hdcol = hdcol.nextSibling, i++) {
				if (hdcol.style.width.indexOf('px') == -1) {
					var sw = hdcol.style.width = jq.px0(hdcells[i].offsetWidth),
						wgt = zk.Widget.$(hdcol);
					if (!wgt.$instanceof(zul.mesh.HeadWidget)) {
						if ((faker = wgt.$n('bdfaker')))
							faker.style.width = sw;
						if ((faker = wgt.$n('ftfaker')))
							faker.style.width = sw;
					}
				}
			}
			
			for (var i = c, faker; i < totalCols; i++) {
				var n = hdcells[i],
					hdWgt = zk.Widget.$(n),
					isVisible = hdWgt && hdWgt.isVisible(),
					shallUpdate = false,
					cellWidth;
				
				
				var style = n.style;
				if (style.visibility == 'hidden' || style.display == 'none' )
					continue; 
				
				if (cnt-- <= 0) { 
					var wd = isVisible ? 
							(zk.ie ? Math.max(jq(n).width(), 0) : n.offsetWidth) 
							: 0,
						nativebar = mesh._nativebar;
					
					if (force || (wd < 1)) {
						cellWidth = hdWgt._origWd || jq.px(wd);
						
						
						if ((wd > 1) && (faker = jq('#' + n.id + '-hdfaker')[0]) && faker.style.width)
							cellWidth = faker.style.width;
						hdWgt._origWd = null;
						shallUpdate = true;
					}
				} else if (force ||
						 
						((zk.ie ? Math.max(jq(n).width(), 0) : n.offsetWidth) != 0)) { 
					faker = jq('#' + n.id + '-hdfaker')[0];
					
					if (faker.style.width && zk.parseInt(faker.style.width) > 1)
						hdWgt._origWd = faker.style.width
					cellWidth = '0px';
					shallUpdate = true;
				}
				
				
				if ((zk.chrome || zk.safari) && cellWidth && (parseInt(cellWidth) == 0))
					cellWidth = '0.1px';
				
				if (force || shallUpdate) {
					if ((faker = jq('#' + n.id + '-hdfaker')[0]))
						faker.style.width = cellWidth;
					if ((faker = jq('#' + n.id + '-bdfaker')[0]) && isVisible)
						faker.style.width = cellWidth;
					if ((faker = jq('#' + n.id + '-ftfaker')[0]))
						faker.style.width = cellWidth;

					
					
					
					
					
					
					
					
					
					hdcells[i].style.width = cellWidth;
					
					if (ftcells) {
						
						
						
						
						
						
						if (ftcells.length > i)
							ftcells[i].style.width = cellWidth;
					}
				}
			}
			
			hdcol = mesh.ehdfaker.firstChild;
			for (var i = 0; hdcol && i < totalCols; hdcol = hdcol.nextSibling, i++) {
				if (hdcol.style.display != 'none')
					totalWidth += zk.parseInt(hdcol.style.width);
			}
		}
		
		
		var headtbl, bodytbl, foottbl;
		if (headtbl = mesh.eheadtbl)
			headtbl.style.width = jq.px(totalWidth);
		if (bodytbl = mesh.ebodytbl)
			bodytbl.style.width = jq.px(totalWidth);
		if (foottbl = mesh.efoottbl)
			foottbl.style.width = jq.px(totalWidth);

		mesh._restoreFocus();
		
		
		if (zk.ie8_) {
			zk(mesh).redoCSS();
		} else if (zk.ie9_) {
			var n = mesh.$n();
			n.className += ' ';
			if (n.offsetHeight);
			n.className.trim();
		}
	}
});

})();