/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.xel.impl;

import org.zkoss.web.servlet.xel.RequestContext;
import org.zkoss.web.servlet.xel.RequestContexts;
import org.zkoss.xel.Expression;
import org.zkoss.xel.ExpressionFactory;
import org.zkoss.xel.Expressions;
import org.zkoss.xel.FunctionMapper;
import org.zkoss.xel.VariableResolver;
import org.zkoss.xel.XelContext;
import org.zkoss.xel.XelException;
import org.zkoss.xel.util.DualFunctionMapper;
import org.zkoss.xel.util.SimpleXelContext;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.sys.ExecutionCtrl;
import org.zkoss.zk.ui.sys.ExecutionsCtrl;
import org.zkoss.zk.xel.Evaluator;
import org.zkoss.zk.xel.impl.ExecutionResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleEvaluator
implements Evaluator {
    private transient ExpressionFactory _expf;
    private final Class<? extends ExpressionFactory> _expfcls;
    private final FunctionMapper _mapper;

    public SimpleEvaluator(FunctionMapper mapper, Class<? extends ExpressionFactory> expfcls) {
        this._expfcls = expfcls;
        this._mapper = mapper;
    }

    public Expression parseExpression(String expression, Class expectedType) throws XelException {
        return this.getExpressionFactory().parseExpression(this.newXelContext(null), expression, expectedType);
    }

    @Override
    public Object evaluate(Page page, Expression expression) throws XelException {
        return expression.evaluate(this.newXelContext(page));
    }

    @Override
    public Object evaluate(Component comp, Expression expression) throws XelException {
        return expression.evaluate(this.newXelContext(comp));
    }

    public Class<? extends ExpressionFactory> getExpressionFactoryClass() {
        return this._expfcls;
    }

    protected ExpressionFactory getExpressionFactory() {
        if (this._expf == null) {
            this._expf = Expressions.newExpressionFactory(this._expfcls);
        }
        return this._expf;
    }

    protected XelContext newXelContext(Object ref) {
        FunctionMapper mapper = this.getFunctionMapper(ref);
        VariableResolver resolver = this.getVariableResolver(ref);
        return new SimpleXelContext(resolver, mapper);
    }

    public FunctionMapper getFunctionMapper(Object ref) {
        ExecutionCtrl execCtrl;
        if (ref instanceof Component) {
            ref = ((Component)ref).getPage();
        }
        if (ref == null && (execCtrl = ExecutionsCtrl.getCurrentCtrl()) != null) {
            ref = execCtrl.getCurrentPage();
        }
        return DualFunctionMapper.combine((FunctionMapper)(ref instanceof Page ? ((Page)ref).getFunctionMapper() : null), (FunctionMapper)this._mapper);
    }

    public VariableResolver getVariableResolver(Object ref) {
        Execution exec = Executions.getCurrent();
        VariableResolver resolver = exec.getVariableResolver();
        if (resolver == null) {
            RequestContext rc = RequestContexts.getCurrent();
            if (rc != null) {
                resolver = rc.getVariableResolver();
            }
            if (resolver == null) {
                return null;
            }
        }
        if (resolver instanceof ExecutionResolver) {
            ((ExecutionResolver)resolver).setSelf(ref);
        }
        return resolver;
    }
}

