
(function () {
zk.gapi.GOOGLE_API_LOADING_TIMEOUT = 10000; 
zk.gapi.loadAPIs = function (wgt, callback, msg, timeout) {
	var opts = {};
	opts['condition'] = function () {return window.google && window.google.load;};
	opts['callback'] = function () {callback(); delete zk.gapi.LOADING;};
	opts['message'] = msg;
	if (!opts.condition()) {
		zk.gapi.waitUntil(wgt, opts);
		if (!zk.gapi.LOADING) { 
			zk.gapi.LOADING = true;
			if (!opts.condition())
				zk.loadScript('http://www.google.com/jsapi?key=' + zk.googleAPIkey);
		}
	} else
		callback();
};
zk.gapi.waitUntil = function (wgt, opts) {
	opts.inittime = opts.inittime || new Date().getTime();
	opts.timeout = opts.timeout || zk.gapi.GOOGLE_API_LOADING_TIMEOUT;
	initMask(wgt, opts);
	waitUntil(wgt, opts);
};
function waitUntil(wgt, opts) {
	if (!opts.condition()) {
		var timestamp0 = new Date().getTime();
		if ((timestamp0 - opts.inittime) < opts.timeout) {
			setTimeout(function () {waitUntil(wgt, opts);}, 100);
			return;
		}
	}
	opts.callback();
	clearMask(wgt, opts);
}
function initMask(wgt, opts) {
	var opt = {};
	opt['anchor'] = wgt;
	if (opts.message) opt['message'] = opts.message;
	opts['_mask'] = new zk.eff.Mask(opt);
}
function clearMask(wgt, opts) {
	if (opts._mask)
		opts._mask.destroy();
}
})();
