/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.metainfo;

import java.util.Map;
import org.zkoss.lang.Classes;
import org.zkoss.xel.FunctionMapper;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.metainfo.ArgumentInfo;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.xel.Evaluator;
import org.zkoss.zk.xel.ExValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionMapperInfo
extends ArgumentInfo {
    private Object _mapper;

    public FunctionMapperInfo(Class<? extends FunctionMapper> cls, Map<String, String> args) {
        super(args);
        FunctionMapperInfo.checkClass(cls);
        this._mapper = cls;
    }

    public FunctionMapperInfo(Class<? extends FunctionMapper> cls) {
        this(cls, null);
    }

    private static void checkClass(Class<?> cls) {
        if (!FunctionMapper.class.isAssignableFrom(cls)) {
            throw new UiException(FunctionMapper.class + " must be implemented: " + cls);
        }
    }

    public FunctionMapperInfo(String clsnm, Map<String, String> args) throws ClassNotFoundException {
        super(args);
        if (clsnm == null || clsnm.length() == 0) {
            throw new IllegalArgumentException("empty");
        }
        if (clsnm.indexOf("${") < 0) {
            if (clsnm.indexOf(46) >= 0) {
                try {
                    Class cls = Classes.forNameByThread((String)clsnm);
                    FunctionMapperInfo.checkClass(cls);
                    this._mapper = cls;
                }
                catch (ClassNotFoundException ex) {
                    throw new ClassNotFoundException("Class not found: " + clsnm, ex);
                }
            } else {
                this._mapper = clsnm;
            }
        } else {
            this._mapper = new ExValue(clsnm, String.class);
        }
    }

    public FunctionMapperInfo(String clsnm) throws ClassNotFoundException {
        this(clsnm, null);
    }

    public FunctionMapperInfo(FunctionMapper mapper) {
        super(null);
        if (mapper == null) {
            throw new IllegalArgumentException("null");
        }
        this._mapper = mapper;
    }

    public FunctionMapper newFunctionMapper(PageDefinition pgdef, Page page) throws Exception {
        return this.newFunctionMapper(pgdef.getEvaluator(), page);
    }

    public FunctionMapper newFunctionMapper(Evaluator eval, Page page) throws Exception {
        Class<?> cls;
        if (this._mapper instanceof FunctionMapper) {
            return (FunctionMapper)this._mapper;
        }
        String clsnm = null;
        if (this._mapper instanceof ExValue) {
            clsnm = (String)((ExValue)this._mapper).getValue(eval, page);
            if (clsnm == null || clsnm.length() == 0) {
                return null;
            }
        } else if (this._mapper instanceof String) {
            clsnm = (String)this._mapper;
        }
        if (clsnm != null) {
            try {
                cls = page != null ? page.resolveClass(clsnm) : Classes.forNameByThread((String)clsnm);
                FunctionMapperInfo.checkClass(cls);
            }
            catch (ClassNotFoundException ex) {
                throw new ClassNotFoundException("Class not found: " + clsnm + " (" + this._mapper + ")", ex);
            }
            if (clsnm.equals(this._mapper)) {
                this._mapper = cls;
            }
        } else {
            cls = (Class<?>)this._mapper;
        }
        return (FunctionMapper)this.newInstance(cls, eval, page);
    }

    public String toString() {
        return "[function-mapper " + this._mapper + "]";
    }
}

