/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.util.resource;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.util.resource.Loader;
import org.zkoss.web.util.resource.ResourceInfo;
import org.zkoss.web.util.resource.ServletContextLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResourceLoader<V>
implements Loader<ResourceInfo, V> {
    private static final Logger log = LoggerFactory.getLogger(ResourceLoader.class);

    protected ResourceLoader() {
    }

    protected abstract V parse(String var1, File var2, Object var3) throws Exception;

    protected abstract V parse(String var1, URL var2, Object var3) throws Exception;

    public boolean shallCheck(ResourceInfo src, long expiredMillis) {
        return expiredMillis > 0L;
    }

    public long getLastModified(ResourceInfo src) {
        if (src.url != null) {
            try {
                long v = src.url.openConnection().getLastModified();
                return v != -1L ? v : 0L;
            }
            catch (Throwable ex) {
                return -1L;
            }
        }
        long v = src.file.lastModified();
        return v == -1L ? 0L : (v == 0L ? -1L : v);
    }

    public V load(ResourceInfo src) throws Exception {
        if (src.url != null) {
            return this.parse(src.path, src.url, src.extra);
        }
        if (!src.file.exists() && src.extra != null && ((ServletContextLocator)src.extra).getResourceAsStream(src.path) == null) {
            if (log.isDebugEnabled()) {
                log.debug("Not found: " + src.file);
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("Loading " + src.file);
        }
        try {
            return this.parse(src.path, src.file, src.extra);
        }
        catch (FileNotFoundException ex) {
            return null;
        }
    }
}

