/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.awt.Color;
import java.awt.font.TextAttribute;
import java.io.Writer;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.base.JRBasePrintText;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.engine.fonts.FontInfo;
import net.sf.jasperreports.engine.fonts.FontUtil;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.engine.util.JRStringUtil;

public class XlsxRunHelper
extends BaseHelper {
    public static final String COLOR_NONE = "none";
    private String exporterKey;

    public XlsxRunHelper(JasperReportsContext jasperReportsContext, Writer writer, String exporterKey) {
        super(jasperReportsContext, writer);
        this.exporterKey = exporterKey;
    }

    public void export(JRStyle style, Map<AttributedCharacterIterator.Attribute, Object> attributes, String text, Locale locale) {
        this.export(style, attributes, text, locale, null);
    }

    public void export(JRStyle style, Map<AttributedCharacterIterator.Attribute, Object> attributes, String text, Locale locale, String invalidCharReplacement) {
        if (text != null) {
            this.write("<r>\n");
            this.exportProps(this.getAttributes(style), attributes, locale);
            this.write("<t xml:space=\"preserve\">");
            this.write(JRStringUtil.xmlEncode(text, invalidCharReplacement));
            this.write("</t></r>\n");
        }
    }

    public void export(JRStyle style, Map<AttributedCharacterIterator.Attribute, Object> attributes, String text, Locale locale, String invalidCharReplacement, String markup) {
        if (text != null) {
            this.write("<r>\n");
            if (markup != null && !COLOR_NONE.equals(markup)) {
                this.exportProps(this.getAttributes(style), attributes, locale);
            }
            this.write("<t xml:space=\"preserve\">");
            this.write(JRStringUtil.xmlEncode(text, invalidCharReplacement));
            this.write("</t></r>\n");
        }
    }

    public void exportProps(JRStyle style, Locale locale) {
        JRBasePrintText text = new JRBasePrintText(null);
        text.setStyle(style);
        HashMap<AttributedCharacterIterator.Attribute, Object> styledTextAttributes = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        FontUtil.getInstance(this.jasperReportsContext).getAttributesWithoutAwtFont(styledTextAttributes, text);
        styledTextAttributes.put(TextAttribute.FOREGROUND, text.getForecolor());
        if (style.getModeValue() == null || style.getModeValue() == ModeEnum.OPAQUE) {
            styledTextAttributes.put(TextAttribute.BACKGROUND, style.getBackcolor());
        }
        this.exportProps(this.getAttributes(style.getStyle()), this.getAttributes(style), locale);
    }

    public void exportProps(Map<AttributedCharacterIterator.Attribute, Object> parentAttrs, Map<AttributedCharacterIterator.Attribute, Object> attrs, Locale locale) {
        this.write("       <rPr>\n");
        Object value = attrs.get(TextAttribute.FAMILY);
        Object oldValue = parentAttrs.get(TextAttribute.FAMILY);
        boolean isOwnFont = false;
        if (value != null && !value.equals(oldValue)) {
            FontFamily family;
            String exportFont;
            String fontFamilyAttr;
            String fontFamily = fontFamilyAttr = (String)value;
            FontInfo fontInfo = FontUtil.getInstance(this.jasperReportsContext).getFontInfo(fontFamilyAttr, locale);
            if (fontInfo != null && (exportFont = (family = fontInfo.getFontFamily()).getExportFont(this.exporterKey)) != null) {
                fontFamily = exportFont;
            }
            this.write("        <rFont val=\"" + fontFamily + "\"/>\n");
            isOwnFont = true;
        }
        value = attrs.get(TextAttribute.FOREGROUND);
        oldValue = parentAttrs.get(TextAttribute.FOREGROUND);
        if (value != null && (isOwnFont || !value.equals(oldValue))) {
            this.write("        <color rgb=\"" + JRColorUtil.getColorHexa((Color)value) + "\" />\n");
        }
        value = attrs.get(TextAttribute.SIZE);
        oldValue = parentAttrs.get(TextAttribute.SIZE);
        if (value != null && (isOwnFont || !value.equals(oldValue))) {
            this.write("        <sz val=\"" + value + "\" />\n");
        }
        value = attrs.get(TextAttribute.WEIGHT);
        oldValue = parentAttrs.get(TextAttribute.WEIGHT);
        if (value != null && (isOwnFont || !value.equals(oldValue))) {
            this.write("        <b val=\"" + value.equals(TextAttribute.WEIGHT_BOLD) + "\"/>\n");
        }
        value = attrs.get(TextAttribute.POSTURE);
        oldValue = parentAttrs.get(TextAttribute.POSTURE);
        if (value != null && (isOwnFont || !value.equals(oldValue))) {
            this.write("        <i val=\"" + value.equals(TextAttribute.POSTURE_OBLIQUE) + "\"/>\n");
        }
        value = attrs.get(TextAttribute.UNDERLINE);
        oldValue = parentAttrs.get(TextAttribute.UNDERLINE);
        if (value == null && oldValue != null || value != null && (isOwnFont || !value.equals(oldValue))) {
            this.write("        <u val=\"" + (value == null ? COLOR_NONE : "single") + "\"/>\n");
        }
        value = attrs.get(TextAttribute.STRIKETHROUGH);
        oldValue = parentAttrs.get(TextAttribute.STRIKETHROUGH);
        if (value == null && oldValue != null || value != null && (isOwnFont || !value.equals(oldValue))) {
            this.write("        <strike val=\"" + (value != null) + "\"/>\n");
        }
        if (TextAttribute.SUPERSCRIPT_SUPER.equals(value = attrs.get(TextAttribute.SUPERSCRIPT))) {
            this.write("        <vertAlign val=\"superscript\" />\n");
        } else if (TextAttribute.SUPERSCRIPT_SUB.equals(value)) {
            this.write("        <vertAlign val=\"subscript\" />\n");
        }
        this.write("       </rPr>\n");
    }

    private Map<AttributedCharacterIterator.Attribute, Object> getAttributes(JRStyle style) {
        JRBasePrintText text = new JRBasePrintText(null);
        text.setStyle(style);
        HashMap<AttributedCharacterIterator.Attribute, Object> styledTextAttributes = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        FontUtil.getInstance(this.jasperReportsContext).getAttributesWithoutAwtFont(styledTextAttributes, text);
        styledTextAttributes.put(TextAttribute.FOREGROUND, text.getForecolor());
        if (text.getModeValue() == ModeEnum.OPAQUE) {
            styledTextAttributes.put(TextAttribute.BACKGROUND, text.getBackcolor());
        }
        return styledTextAttributes;
    }
}

