/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.web.util;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameter;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameters;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.JRValueStringUtils;
import net.sf.jasperreports.web.util.JacksonMapping;

public class JacksonUtil {
    private static final String OBJECT_MAPPER_CONTEXT_KEY = "net.sf.jasperreports.jackson.object.mapper";
    private JasperReportsContext jasperReportsContext;

    private JacksonUtil(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    public static JacksonUtil getInstance(JasperReportsContext jasperReportsContext) {
        return new JacksonUtil(jasperReportsContext);
    }

    private ObjectMapper getObjectMapper() {
        ObjectMapper mapper = (ObjectMapper)this.jasperReportsContext.getValue(OBJECT_MAPPER_CONTEXT_KEY);
        if (mapper == null) {
            mapper = new ObjectMapper();
            List<JacksonMapping> jacksonMappings = this.jasperReportsContext.getExtensions(JacksonMapping.class);
            for (JacksonMapping jacksonMapping : jacksonMappings) {
                JacksonUtil.register(mapper, jacksonMapping);
            }
            mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            this.jasperReportsContext.setValue(OBJECT_MAPPER_CONTEXT_KEY, mapper);
        }
        return mapper;
    }

    private static void register(ObjectMapper mapper, JacksonMapping mapping) {
        try {
            Class<?> clazz = Class.forName(mapping.getClassName());
            mapper.registerSubtypes(new NamedType[]{new NamedType(clazz, mapping.getName())});
        }
        catch (ClassNotFoundException e) {
            throw new JRRuntimeException(e);
        }
    }

    public <T> T loadObject(String jsonData, Class<T> clazz) {
        Object result = null;
        if (jsonData != null) {
            ObjectMapper mapper = this.getObjectMapper();
            try {
                result = mapper.readValue(jsonData, clazz);
            }
            catch (JsonParseException e) {
                throw new JRRuntimeException(e);
            }
            catch (JsonMappingException e) {
                throw new JRRuntimeException(e);
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
        }
        return (T)result;
    }

    public <T> List<T> loadList(String jsonData, Class<T> clazz) {
        List result = null;
        if (jsonData != null) {
            ObjectMapper mapper = this.getObjectMapper();
            try {
                result = (List)mapper.readValue(jsonData, mapper.getTypeFactory().constructParametricType(List.class, new Class[]{clazz}));
            }
            catch (JsonParseException e) {
                throw new JRRuntimeException(e);
            }
            catch (JsonMappingException e) {
                throw new JRRuntimeException(e);
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
        }
        return result;
    }

    public <T> List<T> loadAsList(String jsonData, Class<T> clazz) {
        List<T> result = null;
        if (jsonData != null) {
            String trimmedData = jsonData.trim();
            if (trimmedData.startsWith("{")) {
                result = new ArrayList<T>();
                result.add(this.loadObject(trimmedData, clazz));
            } else if (trimmedData.startsWith("[")) {
                result = this.loadList(trimmedData, clazz);
            }
        }
        return result;
    }

    public String getJsonString(Object object) {
        ObjectMapper mapper = this.getObjectMapper();
        try {
            return mapper.writeValueAsString(object);
        }
        catch (JsonGenerationException e) {
            throw new JRRuntimeException(e);
        }
        catch (JsonMappingException e) {
            throw new JRRuntimeException(e);
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
    }

    public String getEscapedJsonString(Object object) {
        return this.getJsonString(object).replaceAll("\\\"", "\\\\\\\"");
    }

    public ObjectNode hyperlinkToJsonObject(JRPrintHyperlink hyperlink) {
        ObjectNode hyperlinkNode = this.getObjectMapper().createObjectNode();
        this.addProperty(hyperlinkNode, "type", hyperlink.getLinkType());
        this.addProperty(hyperlinkNode, "typeValue", hyperlink.getHyperlinkTypeValue().getName());
        this.addProperty(hyperlinkNode, "target", hyperlink.getLinkTarget());
        this.addProperty(hyperlinkNode, "targetValue", hyperlink.getHyperlinkTargetValue().getHtmlValue(), hyperlink.getLinkTarget());
        this.addProperty(hyperlinkNode, "tooltip", hyperlink.getHyperlinkTooltip());
        this.addProperty(hyperlinkNode, "anchor", hyperlink.getHyperlinkAnchor());
        this.addProperty(hyperlinkNode, "page", String.valueOf(hyperlink.getHyperlinkPage()));
        this.addProperty(hyperlinkNode, "reference", hyperlink.getHyperlinkReference());
        JRPrintHyperlinkParameters hParams = hyperlink.getHyperlinkParameters();
        if (hParams != null && hParams.getParameters().size() > 0) {
            ObjectNode params = this.getObjectMapper().createObjectNode();
            for (JRPrintHyperlinkParameter hParam : hParams.getParameters()) {
                if (hParam.getValue() == null) continue;
                if (Collection.class.isAssignableFrom(hParam.getValue().getClass())) {
                    ArrayNode paramValues = this.getObjectMapper().createArrayNode();
                    Collection col = (Collection)hParam.getValue();
                    for (Object next : col) {
                        paramValues.add(JRValueStringUtils.serialize(next.getClass().getName(), next));
                    }
                    params.put(hParam.getName(), (JsonNode)paramValues);
                    continue;
                }
                params.put(hParam.getName(), JRValueStringUtils.serialize(hParam.getValueClass(), hParam.getValue()));
            }
            hyperlinkNode.put("params", (JsonNode)params);
        }
        return hyperlinkNode;
    }

    public void addProperty(ObjectNode objectNode, String property, String value) {
        this.addProperty(objectNode, property, value, null);
    }

    public void addProperty(ObjectNode objectNode, String property, String value, String altValue) {
        if (value != null && !value.equals("null")) {
            objectNode.put(property, value);
        } else if (altValue != null && !altValue.equals("null")) {
            objectNode.put(property, altValue);
        }
    }
}

