/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.web.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.MessageUtil;
import net.sf.jasperreports.web.util.AbstractWebResourceHandler;
import net.sf.jasperreports.web.util.LocaleResolverUtil;
import net.sf.jasperreports.web.util.SimpleWebResource;
import net.sf.jasperreports.web.util.VelocityUtil;
import net.sf.jasperreports.web.util.WebResource;
import net.sf.jasperreports.web.util.WebUtil;

public class JiveWebResourceHandler
extends AbstractWebResourceHandler {
    private String bundleName;
    private Map<String, String> keyToFileMappings;

    public JiveWebResourceHandler(String bundleName) {
        this.bundleName = bundleName;
        this.keyToFileMappings = new HashMap<String, String>();
    }

    @Override
    public WebResource getResource(JasperReportsContext jasperReportsContext, HttpServletRequest request, String resourceKey) {
        SimpleWebResource resource = null;
        if (resourceKey != null && this.keyToFileMappings.containsKey(resourceKey)) {
            WebUtil webUtil = WebUtil.getInstance(jasperReportsContext);
            byte[] bytes = null;
            try {
                Locale locale = LocaleResolverUtil.instance(jasperReportsContext).getLocale(request);
                HashMap<String, Object> contextMap = new HashMap<String, Object>();
                contextMap.put("path", request.getContextPath() + webUtil.getResourcesBasePath());
                contextMap.put("msgProvider", MessageUtil.getInstance(jasperReportsContext).getLocalizedMessageProvider(this.bundleName, locale));
                String resourceString = VelocityUtil.processTemplate(this.keyToFileMappings.get(resourceKey), contextMap);
                if (resourceString != null) {
                    bytes = resourceString.getBytes("UTF-8");
                }
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
            resource = new SimpleWebResource();
            resource.setData(bytes);
            if (resourceKey != null && resourceKey.lastIndexOf(".") != -1) {
                resource.setType(resourceKey.substring(resourceKey.lastIndexOf(".") + 1));
            }
        }
        return resource;
    }

    public void addMapping(String key, String fileClasspath) {
        this.keyToFileMappings.put(key, fileClasspath);
    }
}

