/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.client.http;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Map;
import org.eclipse.jetty.alpn.client.ALPNClientConnectionFactory;
import org.eclipse.jetty.client.AbstractHttpClientTransport;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.MultiplexConnectionPool;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.client.ProxyConfiguration;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http2.HTTP2Session;
import org.eclipse.jetty.http2.api.Session;
import org.eclipse.jetty.http2.client.HTTP2Client;
import org.eclipse.jetty.http2.client.HTTP2ClientConnectionFactory;
import org.eclipse.jetty.http2.client.http.HttpConnectionOverHTTP2;
import org.eclipse.jetty.http2.client.http.HttpDestinationOverHTTP2;
import org.eclipse.jetty.http2.frames.GoAwayFrame;
import org.eclipse.jetty.http2.frames.SettingsFrame;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.ssl.SslContextFactory;

@ManagedObject(value="The HTTP/2 client transport")
public class HttpClientTransportOverHTTP2
extends AbstractHttpClientTransport {
    private final HTTP2Client client;
    private ClientConnectionFactory connectionFactory;
    private boolean useALPN = true;

    public HttpClientTransportOverHTTP2(HTTP2Client client) {
        this.client = client;
        this.setConnectionPoolFactory(destination -> {
            HttpClient httpClient = this.getHttpClient();
            return new MultiplexConnectionPool(destination, httpClient.getMaxConnectionsPerDestination(), (Callback)destination, httpClient.getMaxRequestsQueuedPerDestination());
        });
    }

    public HTTP2Client getHTTP2Client() {
        return this.client;
    }

    @ManagedAttribute(value="The number of selectors", readonly=true)
    public int getSelectors() {
        return this.client.getSelectors();
    }

    @ManagedAttribute(value="Whether ALPN should be used when establishing connections")
    public boolean isUseALPN() {
        return this.useALPN;
    }

    public void setUseALPN(boolean useALPN) {
        this.useALPN = useALPN;
    }

    protected void doStart() throws Exception {
        if (!this.client.isStarted()) {
            HttpClient httpClient = this.getHttpClient();
            this.client.setExecutor(httpClient.getExecutor());
            this.client.setScheduler(httpClient.getScheduler());
            this.client.setByteBufferPool(httpClient.getByteBufferPool());
            this.client.setConnectTimeout(httpClient.getConnectTimeout());
            this.client.setIdleTimeout(httpClient.getIdleTimeout());
            this.client.setInputBufferSize(httpClient.getResponseBufferSize());
        }
        this.addBean(this.client);
        super.doStart();
        this.connectionFactory = new HTTP2ClientConnectionFactory();
        this.client.setClientConnectionFactory((endPoint, context) -> {
            HttpDestination destination = (HttpDestination)context.get("http.destination");
            return destination.getClientConnectionFactory().newConnection(endPoint, context);
        });
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.removeBean(this.client);
    }

    public HttpDestination newHttpDestination(Origin origin) {
        return new HttpDestinationOverHTTP2(this.getHttpClient(), origin);
    }

    public void connect(InetSocketAddress address, Map<String, Object> context) {
        HttpClient httpClient = this.getHttpClient();
        this.client.setConnectTimeout(httpClient.getConnectTimeout());
        this.client.setConnectBlocking(httpClient.isConnectBlocking());
        this.client.setBindAddress(httpClient.getBindAddress());
        SessionListenerPromise listenerPromise = new SessionListenerPromise(context);
        HttpDestinationOverHTTP2 destination = (HttpDestinationOverHTTP2)((Object)context.get("http.destination"));
        SslContextFactory sslContextFactory = null;
        if (HttpScheme.HTTPS.is(destination.getScheme())) {
            sslContextFactory = httpClient.getSslContextFactory();
        }
        this.client.connect(sslContextFactory, address, (Session.Listener)listenerPromise, (Promise)listenerPromise, context);
    }

    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        boolean ssl;
        endPoint.setIdleTimeout(this.getHttpClient().getIdleTimeout());
        ClientConnectionFactory factory = this.connectionFactory;
        HttpDestinationOverHTTP2 destination = (HttpDestinationOverHTTP2)((Object)context.get("http.destination"));
        ProxyConfiguration.Proxy proxy = destination.getProxy();
        boolean bl = ssl = proxy == null ? HttpScheme.HTTPS.is(destination.getScheme()) : proxy.isSecure();
        if (ssl && this.isUseALPN()) {
            factory = new ALPNClientConnectionFactory(this.client.getExecutor(), factory, this.client.getProtocols());
        }
        return factory.newConnection(endPoint, context);
    }

    protected HttpConnectionOverHTTP2 newHttpConnection(HttpDestination destination, Session session) {
        return new HttpConnectionOverHTTP2(destination, session);
    }

    protected void onClose(HttpConnectionOverHTTP2 connection, GoAwayFrame frame) {
        connection.close();
    }

    private class SessionListenerPromise
    extends Session.Listener.Adapter
    implements Promise<Session> {
        private final Map<String, Object> context;
        private HttpConnectionOverHTTP2 connection;

        private SessionListenerPromise(Map<String, Object> context) {
            this.context = context;
        }

        public void succeeded(Session session) {
            this.connection = HttpClientTransportOverHTTP2.this.newHttpConnection((HttpDestination)this.destination(), session);
            this.promise().succeeded((Object)this.connection);
        }

        public void failed(Throwable failure) {
            this.promise().failed(failure);
        }

        private HttpDestinationOverHTTP2 destination() {
            return (HttpDestinationOverHTTP2)((Object)this.context.get("http.destination"));
        }

        private Promise<org.eclipse.jetty.client.api.Connection> promise() {
            return (Promise)this.context.get("http.connection.promise");
        }

        public void onSettings(Session session, SettingsFrame frame) {
            Map settings = frame.getSettings();
            if (settings.containsKey(3)) {
                this.destination().setMaxRequestsPerConnection((Integer)settings.get(3));
            }
        }

        public void onClose(Session session, GoAwayFrame frame) {
            HttpClientTransportOverHTTP2.this.onClose(this.connection, frame);
        }

        public boolean onIdleTimeout(Session session) {
            return this.connection.onIdleTimeout(((HTTP2Session)session).getEndPoint().getIdleTimeout());
        }

        public void onFailure(Session session, Throwable failure) {
            HttpConnectionOverHTTP2 c = this.connection;
            if (c != null) {
                c.close(failure);
            }
        }
    }
}

