/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.parser;

import java.nio.ByteBuffer;
import java.util.function.UnaryOperator;
import org.eclipse.jetty.http2.ErrorCode;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.FrameType;
import org.eclipse.jetty.http2.frames.GoAwayFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PingFrame;
import org.eclipse.jetty.http2.frames.PriorityFrame;
import org.eclipse.jetty.http2.frames.PushPromiseFrame;
import org.eclipse.jetty.http2.frames.ResetFrame;
import org.eclipse.jetty.http2.frames.SettingsFrame;
import org.eclipse.jetty.http2.frames.WindowUpdateFrame;
import org.eclipse.jetty.http2.hpack.HpackDecoder;
import org.eclipse.jetty.http2.parser.BodyParser;
import org.eclipse.jetty.http2.parser.ContinuationBodyParser;
import org.eclipse.jetty.http2.parser.DataBodyParser;
import org.eclipse.jetty.http2.parser.GoAwayBodyParser;
import org.eclipse.jetty.http2.parser.HeaderBlockFragments;
import org.eclipse.jetty.http2.parser.HeaderBlockParser;
import org.eclipse.jetty.http2.parser.HeaderParser;
import org.eclipse.jetty.http2.parser.HeadersBodyParser;
import org.eclipse.jetty.http2.parser.PingBodyParser;
import org.eclipse.jetty.http2.parser.PriorityBodyParser;
import org.eclipse.jetty.http2.parser.PushPromiseBodyParser;
import org.eclipse.jetty.http2.parser.ResetBodyParser;
import org.eclipse.jetty.http2.parser.SettingsBodyParser;
import org.eclipse.jetty.http2.parser.WindowUpdateBodyParser;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class Parser {
    private static final Logger LOG = Log.getLogger(Parser.class);
    private final Listener listener;
    private final HeaderParser headerParser;
    private final HeaderBlockParser headerBlockParser;
    private final BodyParser[] bodyParsers;
    private boolean continuation;
    private State state = State.HEADER;

    public Parser(ByteBufferPool byteBufferPool, Listener listener, int maxDynamicTableSize, int maxHeaderSize) {
        this.listener = listener;
        this.headerParser = new HeaderParser();
        this.headerBlockParser = new HeaderBlockParser(byteBufferPool, new HpackDecoder(maxDynamicTableSize, maxHeaderSize));
        this.bodyParsers = new BodyParser[FrameType.values().length];
    }

    public void init(UnaryOperator<Listener> wrapper) {
        Listener listener = (Listener)wrapper.apply(this.listener);
        HeaderBlockFragments headerBlockFragments = new HeaderBlockFragments();
        this.bodyParsers[FrameType.DATA.getType()] = new DataBodyParser(this.headerParser, listener);
        this.bodyParsers[FrameType.HEADERS.getType()] = new HeadersBodyParser(this.headerParser, listener, this.headerBlockParser, headerBlockFragments);
        this.bodyParsers[FrameType.PRIORITY.getType()] = new PriorityBodyParser(this.headerParser, listener);
        this.bodyParsers[FrameType.RST_STREAM.getType()] = new ResetBodyParser(this.headerParser, listener);
        this.bodyParsers[FrameType.SETTINGS.getType()] = new SettingsBodyParser(this.headerParser, listener);
        this.bodyParsers[FrameType.PUSH_PROMISE.getType()] = new PushPromiseBodyParser(this.headerParser, listener, this.headerBlockParser);
        this.bodyParsers[FrameType.PING.getType()] = new PingBodyParser(this.headerParser, listener);
        this.bodyParsers[FrameType.GO_AWAY.getType()] = new GoAwayBodyParser(this.headerParser, listener);
        this.bodyParsers[FrameType.WINDOW_UPDATE.getType()] = new WindowUpdateBodyParser(this.headerParser, listener);
        this.bodyParsers[FrameType.CONTINUATION.getType()] = new ContinuationBodyParser(this.headerParser, listener, this.headerBlockParser, headerBlockFragments);
    }

    private void reset() {
        this.headerParser.reset();
        this.state = State.HEADER;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse(ByteBuffer buffer) {
        try {
            block6: while (true) {
                switch (this.state) {
                    case HEADER: {
                        if (this.parseHeader(buffer)) continue block6;
                        return;
                    }
                    case BODY: {
                        if (!this.parseBody(buffer)) return;
                        continue block6;
                    }
                }
                break;
            }
            throw new IllegalStateException();
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(x);
            }
            BufferUtil.clear((ByteBuffer)buffer);
            this.notifyConnectionFailure(ErrorCode.PROTOCOL_ERROR.code, "parser_error");
            return;
        }
    }

    protected boolean parseHeader(ByteBuffer buffer) {
        if (!this.headerParser.parse(buffer)) {
            return false;
        }
        FrameType frameType = FrameType.from(this.getFrameType());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Parsed {} frame header from {}", new Object[]{frameType, buffer});
        }
        if (this.continuation) {
            if (frameType != FrameType.CONTINUATION) {
                BufferUtil.clear((ByteBuffer)buffer);
                this.notifyConnectionFailure(ErrorCode.PROTOCOL_ERROR.code, "continuation_frame_expected");
                return false;
            }
            if (this.headerParser.hasFlag(4)) {
                this.continuation = false;
            }
        } else if (frameType == FrameType.HEADERS && !this.headerParser.hasFlag(4)) {
            this.continuation = true;
        }
        this.state = State.BODY;
        return true;
    }

    protected boolean parseBody(ByteBuffer buffer) {
        int type = this.getFrameType();
        if (type < 0 || type >= this.bodyParsers.length) {
            BufferUtil.clear((ByteBuffer)buffer);
            this.notifyConnectionFailure(ErrorCode.PROTOCOL_ERROR.code, "unknown_frame_type_" + type);
            return false;
        }
        BodyParser bodyParser = this.bodyParsers[type];
        if (this.headerParser.getLength() == 0) {
            bodyParser.emptyBody(buffer);
        } else if (!bodyParser.parse(buffer)) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Parsed {} frame body from {}", new Object[]{FrameType.from(type), buffer});
        }
        this.reset();
        return true;
    }

    protected int getFrameType() {
        return this.headerParser.getFrameType();
    }

    protected boolean hasFlag(int bit) {
        return this.headerParser.hasFlag(bit);
    }

    protected void notifyConnectionFailure(int error, String reason) {
        try {
            this.listener.onConnectionFailure(error, reason);
        }
        catch (Throwable x) {
            LOG.info("Failure while notifying listener " + this.listener, x);
        }
    }

    public static interface Listener {
        public void onData(DataFrame var1);

        public void onHeaders(HeadersFrame var1);

        public void onPriority(PriorityFrame var1);

        public void onReset(ResetFrame var1);

        public void onSettings(SettingsFrame var1);

        public void onPushPromise(PushPromiseFrame var1);

        public void onPing(PingFrame var1);

        public void onGoAway(GoAwayFrame var1);

        public void onWindowUpdate(WindowUpdateFrame var1);

        public void onConnectionFailure(int var1, String var2);

        public static class Adapter
        implements Listener {
            @Override
            public void onData(DataFrame frame) {
            }

            @Override
            public void onHeaders(HeadersFrame frame) {
            }

            @Override
            public void onPriority(PriorityFrame frame) {
            }

            @Override
            public void onReset(ResetFrame frame) {
            }

            @Override
            public void onSettings(SettingsFrame frame) {
            }

            @Override
            public void onPushPromise(PushPromiseFrame frame) {
            }

            @Override
            public void onPing(PingFrame frame) {
            }

            @Override
            public void onGoAway(GoAwayFrame frame) {
            }

            @Override
            public void onWindowUpdate(WindowUpdateFrame frame) {
            }

            @Override
            public void onConnectionFailure(int error, String reason) {
                LOG.warn("Connection failure: {}/{}", new Object[]{error, reason});
            }
        }
    }

    private static enum State {
        HEADER,
        BODY;

    }
}

