/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.eclipse.jetty.osgi.boot.utils.BundleFileLocatorHelperFactory;
import org.eclipse.jetty.osgi.boot.utils.internal.PackageAdminServiceTracker;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebInfConfiguration;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class OSGiWebInfConfiguration
extends WebInfConfiguration {
    private static final Logger LOG = Log.getLogger(WebInfConfiguration.class);
    public static final String SYS_PROP_TLD_BUNDLES = "org.eclipse.jetty.osgi.tldbundles";
    public static final String CONTAINER_BUNDLE_PATTERN = "org.eclipse.jetty.server.webapp.containerIncludeBundlePattern";
    public static final String FRAGMENT_AND_REQUIRED_BUNDLES = "org.eclipse.jetty.osgi.fragmentAndRequiredBundles";
    public static final String FRAGMENT_AND_REQUIRED_RESOURCES = "org.eclipse.jetty.osgi.fragmentAndRequiredResources";

    public void preConfigure(WebAppContext context) throws Exception {
        super.preConfigure(context);
        String tmp = (String)context.getAttribute(CONTAINER_BUNDLE_PATTERN);
        Pattern pattern = tmp == null ? null : Pattern.compile(tmp);
        ArrayList<String> names = new ArrayList<String>();
        tmp = System.getProperty(SYS_PROP_TLD_BUNDLES);
        if (tmp != null) {
            StringTokenizer tokenizer = new StringTokenizer(tmp, ", \n\r\t", false);
            while (tokenizer.hasMoreTokens()) {
                names.add(tokenizer.nextToken());
            }
        }
        HashSet<Resource> matchingResources = new HashSet<Resource>();
        if (!names.isEmpty() || pattern != null) {
            Bundle[] bundles;
            for (Bundle bundle : bundles = FrameworkUtil.getBundle(OSGiWebInfConfiguration.class).getBundleContext().getBundles()) {
                LOG.debug("Checking bundle {}:{}", new Object[]{bundle.getBundleId(), bundle.getSymbolicName()});
                if (pattern != null && pattern.matcher(bundle.getSymbolicName()).matches()) {
                    matchingResources.addAll(this.getBundleAsResource(bundle));
                }
                if (names == null || !names.contains(bundle.getSymbolicName())) continue;
                matchingResources.addAll(this.getBundleAsResource(bundle));
            }
        }
        for (Resource r : matchingResources) {
            context.getMetaData().addContainerResource(r);
        }
    }

    public void postConfigure(WebAppContext context) throws Exception {
        context.setAttribute(FRAGMENT_AND_REQUIRED_BUNDLES, null);
        context.setAttribute(FRAGMENT_AND_REQUIRED_RESOURCES, null);
        super.postConfigure(context);
    }

    protected List<Resource> findJars(WebAppContext context) throws Exception {
        Bundle[] bundles;
        ArrayList<Resource> mergedResources = new ArrayList<Resource>();
        List webInfJars = super.findJars(context);
        if (webInfJars != null) {
            mergedResources.addAll(webInfJars);
        }
        if ((bundles = PackageAdminServiceTracker.INSTANCE.getFragmentsAndRequiredBundles((Bundle)context.getAttribute("osgi-bundle"))) != null && bundles.length > 0) {
            HashSet<Resource> fragsAndReqsResources;
            HashSet<Bundle> fragsAndReqsBundles = (HashSet<Bundle>)context.getAttribute(FRAGMENT_AND_REQUIRED_BUNDLES);
            if (fragsAndReqsBundles == null) {
                fragsAndReqsBundles = new HashSet<Bundle>();
                context.setAttribute(FRAGMENT_AND_REQUIRED_BUNDLES, fragsAndReqsBundles);
            }
            if ((fragsAndReqsResources = (HashSet<Resource>)context.getAttribute(FRAGMENT_AND_REQUIRED_RESOURCES)) == null) {
                fragsAndReqsResources = new HashSet<Resource>();
                context.setAttribute(FRAGMENT_AND_REQUIRED_RESOURCES, fragsAndReqsResources);
            }
            for (Bundle b : bundles) {
                if (b.getState() == 1) continue;
                fragsAndReqsBundles.add(b);
                File f = BundleFileLocatorHelperFactory.getFactory().getHelper().getBundleInstallLocation(b);
                Resource r = Resource.newResource((URI)f.toURI());
                fragsAndReqsResources.add(r);
                mergedResources.add(r);
            }
        }
        return mergedResources;
    }

    public void configure(WebAppContext context) throws Exception {
        Set fragments;
        TreeMap<String, Resource> patchResourcesPath = new TreeMap<String, Resource>();
        TreeMap<String, Resource> appendedResourcesPath = new TreeMap<String, Resource>();
        Bundle bundle = (Bundle)context.getAttribute("osgi-bundle");
        if (bundle != null && (fragments = (Set)context.getAttribute(FRAGMENT_AND_REQUIRED_BUNDLES)) != null && !fragments.isEmpty()) {
            for (Bundle frag : fragments) {
                String key;
                String fragFolder = (String)frag.getHeaders().get("Jetty-WarFragmentFolderPath");
                String patchFragFolder = (String)frag.getHeaders().get("Jetty-WarPatchFragmentFolderPath");
                if (fragFolder != null) {
                    URL fragUrl = frag.getEntry(fragFolder);
                    if (fragUrl == null) {
                        throw new IllegalArgumentException("Unable to locate " + fragFolder + " inside  the fragment '" + frag.getSymbolicName() + "'");
                    }
                    fragUrl = BundleFileLocatorHelperFactory.getFactory().getHelper().getLocalURL(fragUrl);
                    key = fragFolder.startsWith("/") ? fragFolder.substring(1) : fragFolder;
                    appendedResourcesPath.put(key + ";" + frag.getSymbolicName(), Resource.newResource((URL)fragUrl));
                }
                if (patchFragFolder == null) continue;
                URL patchFragUrl = frag.getEntry(patchFragFolder);
                if (patchFragUrl == null) {
                    throw new IllegalArgumentException("Unable to locate " + patchFragUrl + " inside fragment '" + frag.getSymbolicName() + "'");
                }
                patchFragUrl = BundleFileLocatorHelperFactory.getFactory().getHelper().getLocalURL(patchFragUrl);
                key = patchFragFolder.startsWith("/") ? patchFragFolder.substring(1) : patchFragFolder;
                patchResourcesPath.put(key + ";" + frag.getSymbolicName(), Resource.newResource((URL)patchFragUrl));
            }
            if (!appendedResourcesPath.isEmpty()) {
                context.setAttribute("org.eclipse.jetty.resources", new HashSet(appendedResourcesPath.values()));
            }
        }
        super.configure(context);
        if (!patchResourcesPath.isEmpty()) {
            Resource[] resources = new Resource[1 + patchResourcesPath.size()];
            ResourceCollection mergedResources = new ResourceCollection(patchResourcesPath.values().toArray(new Resource[patchResourcesPath.size()]));
            System.arraycopy(patchResourcesPath.values().toArray(new Resource[patchResourcesPath.size()]), 0, resources, 0, patchResourcesPath.size());
            resources[resources.length - 1] = context.getBaseResource();
            context.setBaseResource((Resource)new ResourceCollection(resources));
        }
    }

    private List<Resource> getBundleAsResource(Bundle bundle) throws Exception {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        File file = BundleFileLocatorHelperFactory.getFactory().getHelper().getBundleInstallLocation(bundle);
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                if (f.getName().endsWith(".jar") && f.isFile()) {
                    resources.add(Resource.newResource((File)f));
                    continue;
                }
                if (!f.isDirectory() || !f.getName().equals("lib")) continue;
                for (File f2 : file.listFiles()) {
                    if (!f2.getName().endsWith(".jar") || !f2.isFile()) continue;
                    resources.add(Resource.newResource((File)f));
                }
            }
            resources.add(Resource.newResource((File)file));
        } else {
            resources.add(Resource.newResource((File)file));
        }
        return resources;
    }
}

