/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot.internal.serverfactory;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jetty.osgi.boot.internal.serverfactory.ServerInstanceWrapper;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class JettyServerServiceTracker
implements ServiceListener {
    private static Logger LOG = Log.getLogger((String)JettyServerServiceTracker.class.getName());
    private Map<ServiceReference, ServerInstanceWrapper> _indexByServiceReference = new HashMap<ServiceReference, ServerInstanceWrapper>();

    public void stop() {
        for (ServerInstanceWrapper wrapper : this._indexByServiceReference.values()) {
            try {
                wrapper.stop();
            }
            catch (Throwable t) {
                LOG.warn(t);
            }
        }
    }

    public void serviceChanged(ServiceEvent ev) {
        ServiceReference sr = ev.getServiceReference();
        switch (ev.getType()) {
            case 2: 
            case 4: {
                ServerInstanceWrapper instance = this.unregisterInIndex(ev.getServiceReference());
                if (instance != null) {
                    try {
                        instance.stop();
                    }
                    catch (Exception e) {
                        LOG.warn((Throwable)e);
                    }
                }
                if (ev.getType() == 4) break;
            }
            case 1: {
                try {
                    Bundle contributor = sr.getBundle();
                    Server server = (Server)contributor.getBundleContext().getService(sr);
                    ServerInstanceWrapper wrapper = this.registerInIndex(server, sr);
                    Properties props = new Properties();
                    for (String key : sr.getPropertyKeys()) {
                        Object value = sr.getProperty(key);
                        props.put(key, value);
                    }
                    wrapper.start(server, props);
                    break;
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                }
            }
        }
    }

    private ServerInstanceWrapper registerInIndex(Server server, ServiceReference sr) {
        String name = (String)sr.getProperty("managedServerName");
        if (name == null) {
            throw new IllegalArgumentException("The property managedServerName is mandatory");
        }
        ServerInstanceWrapper wrapper = new ServerInstanceWrapper(name);
        this._indexByServiceReference.put(sr, wrapper);
        return wrapper;
    }

    private ServerInstanceWrapper unregisterInIndex(ServiceReference sr) {
        ServerInstanceWrapper handler = this._indexByServiceReference.remove(sr);
        if (handler == null) {
            LOG.warn("Unknown Jetty Server ServiceReference: ", new Object[]{sr});
            return null;
        }
        return handler;
    }
}

