/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.net.CookieStore;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.AsyncContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.InputStreamContentProvider;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.HttpCookieStore;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.QueuedThreadPool;

public class ProxyServlet
extends HttpServlet {
    private static final Set<String> HOP_HEADERS = new HashSet<String>();
    private final Set<String> _whiteList = new HashSet<String>();
    private final Set<String> _blackList = new HashSet<String>();
    protected Logger _log;
    private String _hostHeader;
    private String _viaHost;
    private HttpClient _client;
    private long _timeout;

    public void init() throws ServletException {
        this._log = this.createLogger();
        ServletConfig config = this.getServletConfig();
        this._hostHeader = config.getInitParameter("hostHeader");
        this._viaHost = config.getInitParameter("viaHost");
        if (this._viaHost == null) {
            this._viaHost = ProxyServlet.viaHost();
        }
        try {
            String blackList;
            this._client = this.createHttpClient();
            this.getServletContext().setAttribute(config.getServletName() + ".HttpClient", (Object)this._client);
            String whiteList = config.getInitParameter("whiteList");
            if (whiteList != null) {
                this.getWhiteListHosts().addAll(this.parseList(whiteList));
            }
            if ((blackList = config.getInitParameter("blackList")) != null) {
                this.getBlackListHosts().addAll(this.parseList(blackList));
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public String getViaHost() {
        return this._viaHost;
    }

    public long getTimeout() {
        return this._timeout;
    }

    public void setTimeout(long timeout) {
        this._timeout = timeout;
    }

    public Set<String> getWhiteListHosts() {
        return this._whiteList;
    }

    public Set<String> getBlackListHosts() {
        return this._blackList;
    }

    protected static String viaHost() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException x) {
            return "localhost";
        }
    }

    protected HttpClient getHttpClient() {
        return this._client;
    }

    protected Logger createLogger() {
        String servletName = this.getServletConfig().getServletName();
        servletName = servletName.replace('-', '.');
        if (((Object)((Object)this)).getClass().getPackage() != null && !servletName.startsWith(((Object)((Object)this)).getClass().getPackage().getName())) {
            servletName = ((Object)((Object)this)).getClass().getName() + "." + servletName;
        }
        return Log.getLogger((String)servletName);
    }

    public void destroy() {
        block2: {
            try {
                this._client.stop();
            }
            catch (Exception x) {
                if (!this._log.isDebugEnabled()) break block2;
                this._log.debug((Throwable)x);
            }
        }
    }

    protected HttpClient createHttpClient() throws ServletException {
        Executor executor;
        ServletConfig config = this.getServletConfig();
        HttpClient client = this.newHttpClient();
        client.setFollowRedirects(false);
        client.setCookieStore((CookieStore)new HttpCookieStore.Empty());
        String value = config.getInitParameter("maxThreads");
        if (value == null || "-".equals(value)) {
            executor = (Executor)this.getServletContext().getAttribute("org.eclipse.jetty.server.Executor");
            if (executor == null) {
                throw new IllegalStateException("No server executor for proxy");
            }
        } else {
            QueuedThreadPool qtp = new QueuedThreadPool(Integer.parseInt(value));
            String servletName = config.getServletName();
            int dot = servletName.lastIndexOf(46);
            if (dot >= 0) {
                servletName = servletName.substring(dot + 1);
            }
            qtp.setName(servletName);
            executor = qtp;
        }
        client.setExecutor(executor);
        value = config.getInitParameter("maxConnections");
        if (value == null) {
            value = "256";
        }
        client.setMaxConnectionsPerDestination(Integer.parseInt(value));
        value = config.getInitParameter("idleTimeout");
        if (value == null) {
            value = "30000";
        }
        client.setIdleTimeout(Long.parseLong(value));
        value = config.getInitParameter("timeout");
        if (value == null) {
            value = "60000";
        }
        this._timeout = Long.parseLong(value);
        value = config.getInitParameter("requestBufferSize");
        if (value != null) {
            client.setRequestBufferSize(Integer.parseInt(value));
        }
        if ((value = config.getInitParameter("responseBufferSize")) != null) {
            client.setResponseBufferSize(Integer.parseInt(value));
        }
        try {
            client.start();
            client.getContentDecoderFactories().clear();
            return client;
        }
        catch (Exception x) {
            throw new ServletException((Throwable)x);
        }
    }

    protected HttpClient newHttpClient() {
        return new HttpClient();
    }

    private Set<String> parseList(String list) {
        String[] hosts;
        HashSet<String> result = new HashSet<String>();
        for (String host : hosts = list.split(",")) {
            if ((host = host.trim()).length() == 0) continue;
            result.add(host);
        }
        return result;
    }

    public boolean validateDestination(String host, int port) {
        String hostPort = host + ":" + port;
        if (!this._whiteList.isEmpty() && !this._whiteList.contains(hostPort)) {
            if (this._log.isDebugEnabled()) {
                this._log.debug("Host {}:{} not whitelisted", new Object[]{host, port});
            }
            return false;
        }
        if (!this._blackList.isEmpty() && this._blackList.contains(hostPort)) {
            if (this._log.isDebugEnabled()) {
                this._log.debug("Host {}:{} blacklisted", new Object[]{host, port});
            }
            return false;
        }
        return true;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int requestId = this.getRequestId(request);
        URI rewrittenURI = this.rewriteURI(request);
        if (this._log.isDebugEnabled()) {
            StringBuffer uri = request.getRequestURL();
            if (request.getQueryString() != null) {
                uri.append("?").append(request.getQueryString());
            }
            if (this._log.isDebugEnabled()) {
                this._log.debug("{} rewriting: {} -> {}", new Object[]{requestId, uri, rewrittenURI});
            }
        }
        if (rewrittenURI == null) {
            this.onRewriteFailed(request, response);
            return;
        }
        Request proxyRequest = this._client.newRequest(rewrittenURI).method(request.getMethod()).version(HttpVersion.fromString((String)request.getProtocol()));
        HashSet<String> hopHeaders = null;
        Enumeration connectionHeaders = request.getHeaders(HttpHeader.CONNECTION.asString());
        while (connectionHeaders.hasMoreElements()) {
            String[] values;
            String value = (String)connectionHeaders.nextElement();
            for (String name : values = value.split(",")) {
                name = name.trim().toLowerCase(Locale.ENGLISH);
                if (hopHeaders == null) {
                    hopHeaders = new HashSet<String>();
                }
                hopHeaders.add(name);
            }
        }
        boolean hasContent = request.getContentLength() > 0 || request.getContentType() != null;
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            String lowerHeaderName = headerName.toLowerCase(Locale.ENGLISH);
            if (HttpHeader.TRANSFER_ENCODING.is(headerName)) {
                hasContent = true;
            }
            if (this._hostHeader != null && HttpHeader.HOST.is(headerName) || HOP_HEADERS.contains(lowerHeaderName) || hopHeaders != null && hopHeaders.contains(lowerHeaderName)) continue;
            Enumeration headerValues = request.getHeaders(headerName);
            while (headerValues.hasMoreElements()) {
                String headerValue = (String)headerValues.nextElement();
                if (headerValue == null) continue;
                proxyRequest.header(headerName, headerValue);
            }
        }
        if (this._hostHeader != null) {
            proxyRequest.header(HttpHeader.HOST, this._hostHeader);
        }
        this.addViaHeader(proxyRequest);
        this.addXForwardedHeaders(proxyRequest, request);
        AsyncContext asyncContext = request.startAsync();
        asyncContext.setTimeout(0L);
        proxyRequest.timeout(this.getTimeout(), TimeUnit.MILLISECONDS);
        if (hasContent) {
            proxyRequest.content(this.proxyRequestContent(proxyRequest, request));
        }
        this.customizeProxyRequest(proxyRequest, request);
        if (this._log.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder(request.getMethod());
            builder.append(" ").append(request.getRequestURI());
            String query = request.getQueryString();
            if (query != null) {
                builder.append("?").append(query);
            }
            builder.append(" ").append(request.getProtocol()).append("\r\n");
            Enumeration headerNames2 = request.getHeaderNames();
            while (headerNames2.hasMoreElements()) {
                String headerName = (String)headerNames2.nextElement();
                builder.append(headerName).append(": ");
                Enumeration headerValues = request.getHeaders(headerName);
                while (headerValues.hasMoreElements()) {
                    String headerValue = (String)headerValues.nextElement();
                    if (headerValue != null) {
                        builder.append(headerValue);
                    }
                    if (!headerValues.hasMoreElements()) continue;
                    builder.append(",");
                }
                builder.append("\r\n");
            }
            builder.append("\r\n");
            this._log.debug("{} proxying to upstream:{}{}{}{}", new Object[]{requestId, System.lineSeparator(), builder, proxyRequest, System.lineSeparator(), proxyRequest.getHeaders().toString().trim()});
        }
        proxyRequest.send((Response.CompleteListener)this.newProxyResponseListener(request, response));
    }

    protected ContentProvider proxyRequestContent(Request proxyRequest, HttpServletRequest request) throws IOException {
        return new ProxyInputStreamContentProvider(proxyRequest, request, (InputStream)request.getInputStream());
    }

    protected Response.Listener newProxyResponseListener(HttpServletRequest request, HttpServletResponse response) {
        return new ProxyResponseListener(request, response);
    }

    protected void onClientRequestFailure(Request proxyRequest, HttpServletRequest request, Throwable failure) {
        if (this._log.isDebugEnabled()) {
            this._log.debug(this.getRequestId(request) + " client request failure", failure);
        }
        proxyRequest.abort(failure);
    }

    protected void onRewriteFailed(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendError(403);
    }

    protected Request addViaHeader(Request proxyRequest) {
        return proxyRequest.header(HttpHeader.VIA, "http/1.1 " + this.getViaHost());
    }

    protected void addXForwardedHeaders(Request proxyRequest, HttpServletRequest request) {
        proxyRequest.header(HttpHeader.X_FORWARDED_FOR, request.getRemoteAddr());
        proxyRequest.header(HttpHeader.X_FORWARDED_PROTO, request.getScheme());
        proxyRequest.header(HttpHeader.X_FORWARDED_HOST, request.getHeader(HttpHeader.HOST.asString()));
        proxyRequest.header(HttpHeader.X_FORWARDED_SERVER, request.getLocalName());
    }

    protected void onResponseHeaders(HttpServletRequest request, HttpServletResponse response, Response proxyResponse) {
        for (HttpField field : proxyResponse.getHeaders()) {
            String newHeaderValue;
            String headerName = field.getName();
            String lowerHeaderName = headerName.toLowerCase(Locale.ENGLISH);
            if (HOP_HEADERS.contains(lowerHeaderName) || (newHeaderValue = this.filterResponseHeader(request, headerName, field.getValue())) == null || newHeaderValue.trim().length() == 0) continue;
            response.addHeader(headerName, newHeaderValue);
        }
    }

    protected void onResponseContent(HttpServletRequest request, HttpServletResponse response, Response proxyResponse, byte[] buffer, int offset, int length, Callback callback) {
        try {
            if (this._log.isDebugEnabled()) {
                this._log.debug("{} proxying content to downstream: {} bytes", new Object[]{this.getRequestId(request), length});
            }
            response.getOutputStream().write(buffer, offset, length);
            callback.succeeded();
        }
        catch (Throwable x) {
            callback.failed(x);
        }
    }

    protected void onResponseSuccess(HttpServletRequest request, HttpServletResponse response, Response proxyResponse) {
        if (this._log.isDebugEnabled()) {
            this._log.debug("{} proxying successful", (long)this.getRequestId(request));
        }
        AsyncContext asyncContext = request.getAsyncContext();
        asyncContext.complete();
    }

    protected void onResponseFailure(HttpServletRequest request, HttpServletResponse response, Response proxyResponse, Throwable failure) {
        if (this._log.isDebugEnabled()) {
            this._log.debug(this.getRequestId(request) + " proxying failed", failure);
        }
        if (response.isCommitted()) {
            try {
                response.sendError(-1);
                AsyncContext asyncContext = request.getAsyncContext();
                asyncContext.complete();
            }
            catch (IOException x) {
                if (this._log.isDebugEnabled()) {
                    this._log.debug(this.getRequestId(request) + " could not close the connection", failure);
                }
            }
        } else {
            response.resetBuffer();
            if (failure instanceof TimeoutException) {
                response.setStatus(504);
            } else {
                response.setStatus(502);
            }
            response.setHeader(HttpHeader.CONNECTION.asString(), HttpHeaderValue.CLOSE.asString());
            AsyncContext asyncContext = request.getAsyncContext();
            asyncContext.complete();
        }
    }

    protected int getRequestId(HttpServletRequest request) {
        return System.identityHashCode(request);
    }

    protected URI rewriteURI(HttpServletRequest request) {
        if (!this.validateDestination(request.getServerName(), request.getServerPort())) {
            return null;
        }
        StringBuffer uri = request.getRequestURL();
        String query = request.getQueryString();
        if (query != null) {
            uri.append("?").append(query);
        }
        return URI.create(uri.toString());
    }

    protected void customizeProxyRequest(Request proxyRequest, HttpServletRequest request) {
    }

    protected String filterResponseHeader(HttpServletRequest request, String headerName, String headerValue) {
        return headerValue;
    }

    static {
        HOP_HEADERS.add("connection");
        HOP_HEADERS.add("keep-alive");
        HOP_HEADERS.add("proxy-authorization");
        HOP_HEADERS.add("proxy-authenticate");
        HOP_HEADERS.add("proxy-connection");
        HOP_HEADERS.add("transfer-encoding");
        HOP_HEADERS.add("te");
        HOP_HEADERS.add("trailer");
        HOP_HEADERS.add("upgrade");
    }

    protected class ProxyInputStreamContentProvider
    extends InputStreamContentProvider {
        private final Request proxyRequest;
        private final HttpServletRequest request;

        protected ProxyInputStreamContentProvider(Request proxyRequest, HttpServletRequest request, InputStream input) {
            super(input);
            this.proxyRequest = proxyRequest;
            this.request = request;
        }

        public long getLength() {
            return this.request.getContentLength();
        }

        protected ByteBuffer onRead(byte[] buffer, int offset, int length) {
            if (ProxyServlet.this._log.isDebugEnabled()) {
                ProxyServlet.this._log.debug("{} proxying content to upstream: {} bytes", new Object[]{ProxyServlet.this.getRequestId(this.request), length});
            }
            return this.onRequestContent(this.proxyRequest, this.request, buffer, offset, length);
        }

        protected ByteBuffer onRequestContent(Request proxyRequest, HttpServletRequest request, byte[] buffer, int offset, int length) {
            return super.onRead(buffer, offset, length);
        }

        protected void onReadFailure(Throwable failure) {
            ProxyServlet.this.onClientRequestFailure(this.proxyRequest, this.request, failure);
        }
    }

    protected class ProxyResponseListener
    extends Response.Listener.Adapter {
        private final HttpServletRequest request;
        private final HttpServletResponse response;

        protected ProxyResponseListener(HttpServletRequest request, HttpServletResponse response) {
            this.request = request;
            this.response = response;
        }

        public void onBegin(Response proxyResponse) {
            this.response.setStatus(proxyResponse.getStatus());
        }

        public void onHeaders(Response proxyResponse) {
            ProxyServlet.this.onResponseHeaders(this.request, this.response, proxyResponse);
            if (ProxyServlet.this._log.isDebugEnabled()) {
                StringBuilder builder = new StringBuilder("\r\n");
                builder.append(this.request.getProtocol()).append(" ").append(this.response.getStatus()).append(" ").append(proxyResponse.getReason()).append("\r\n");
                for (String headerName : this.response.getHeaderNames()) {
                    builder.append(headerName).append(": ");
                    Iterator headerValues = this.response.getHeaders(headerName).iterator();
                    while (headerValues.hasNext()) {
                        String headerValue = (String)headerValues.next();
                        if (headerValue != null) {
                            builder.append(headerValue);
                        }
                        if (!headerValues.hasNext()) continue;
                        builder.append(",");
                    }
                    builder.append("\r\n");
                }
                ProxyServlet.this._log.debug("{} proxying to downstream:{}{}{}{}{}", new Object[]{ProxyServlet.this.getRequestId(this.request), System.lineSeparator(), proxyResponse, System.lineSeparator(), proxyResponse.getHeaders().toString().trim(), System.lineSeparator(), builder});
            }
        }

        public void onContent(final Response proxyResponse, ByteBuffer content, final Callback callback) {
            int offset;
            byte[] buffer;
            int length = content.remaining();
            if (content.hasArray()) {
                buffer = content.array();
                offset = content.arrayOffset();
            } else {
                buffer = new byte[length];
                content.get(buffer);
                offset = 0;
            }
            ProxyServlet.this.onResponseContent(this.request, this.response, proxyResponse, buffer, offset, length, new Callback(){

                public void succeeded() {
                    callback.succeeded();
                }

                public void failed(Throwable x) {
                    callback.failed(x);
                    proxyResponse.abort(x);
                }
            });
        }

        public void onComplete(Result result) {
            if (result.isSucceeded()) {
                ProxyServlet.this.onResponseSuccess(this.request, this.response, result.getResponse());
            } else {
                ProxyServlet.this.onResponseFailure(this.request, this.response, result.getResponse(), result.getFailure());
            }
            if (ProxyServlet.this._log.isDebugEnabled()) {
                ProxyServlet.this._log.debug("{} proxying complete", (long)ProxyServlet.this.getRequestId(this.request));
            }
        }
    }

    protected static class TransparentDelegate {
        private final ProxyServlet proxyServlet;
        private String _proxyTo;
        private String _prefix;

        protected TransparentDelegate(ProxyServlet proxyServlet) {
            this.proxyServlet = proxyServlet;
        }

        protected void init(ServletConfig config) throws ServletException {
            this._proxyTo = config.getInitParameter("proxyTo");
            if (this._proxyTo == null) {
                throw new UnavailableException("Init parameter 'proxyTo' is required.");
            }
            String prefix = config.getInitParameter("prefix");
            if (prefix != null) {
                if (!prefix.startsWith("/")) {
                    throw new UnavailableException("Init parameter 'prefix' must start with a '/'.");
                }
                this._prefix = prefix;
            }
            String contextPath = config.getServletContext().getContextPath();
            String string = this._prefix = this._prefix == null ? contextPath : contextPath + this._prefix;
            if (this.proxyServlet._log.isDebugEnabled()) {
                this.proxyServlet._log.debug(config.getServletName() + " @ " + this._prefix + " to " + this._proxyTo, new Object[0]);
            }
        }

        protected URI rewriteURI(HttpServletRequest request) {
            URI rewrittenURI;
            String rest;
            String path = request.getRequestURI();
            if (!path.startsWith(this._prefix)) {
                return null;
            }
            StringBuilder uri = new StringBuilder(this._proxyTo);
            if (this._proxyTo.endsWith("/")) {
                uri.setLength(uri.length() - 1);
            }
            if (!(rest = path.substring(this._prefix.length())).startsWith("/")) {
                uri.append("/");
            }
            uri.append(rest);
            String query = request.getQueryString();
            if (query != null) {
                uri.append("?").append(query);
            }
            if (!this.proxyServlet.validateDestination((rewrittenURI = URI.create(uri.toString()).normalize()).getHost(), rewrittenURI.getPort())) {
                return null;
            }
            return rewrittenURI;
        }
    }

    public static class Transparent
    extends ProxyServlet {
        private final TransparentDelegate delegate = new TransparentDelegate(this);

        public void init(ServletConfig config) throws ServletException {
            super.init(config);
            this.delegate.init(config);
        }

        @Override
        protected URI rewriteURI(HttpServletRequest request) {
            return this.delegate.rewriteURI(request);
        }
    }
}

