/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletResponse;
import org.eclipse.jetty.server.AsyncContextEvent;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Locker;

public class HttpChannelState {
    private static final Logger LOG = Log.getLogger(HttpChannelState.class);
    private static final long DEFAULT_TIMEOUT = Long.getLong("org.eclipse.jetty.server.HttpChannelState.DEFAULT_TIMEOUT", 30000L);
    private final boolean DEBUG = LOG.isDebugEnabled();
    private final Locker _locker = new Locker();
    private final HttpChannel _channel;
    private List<AsyncListener> _asyncListeners;
    private State _state;
    private Async _async;
    private boolean _initial;
    private boolean _asyncReadPossible;
    private Interest _asyncRead = Interest.NONE;
    private boolean _asyncWritePossible;
    private long _timeoutMs = DEFAULT_TIMEOUT;
    private AsyncContextEvent _event;

    protected HttpChannelState(HttpChannel channel) {
        this._channel = channel;
        this._state = State.IDLE;
        this._async = Async.NOT_ASYNC;
        this._initial = true;
    }

    public State getState() {
        try (Locker.Lock lock = this._locker.lock();){
            State state = this._state;
            return state;
        }
    }

    public void addListener(AsyncListener listener) {
        try (Locker.Lock lock = this._locker.lock();){
            if (this._asyncListeners == null) {
                this._asyncListeners = new ArrayList<AsyncListener>();
            }
            this._asyncListeners.add(listener);
        }
    }

    public void setTimeout(long ms) {
        try (Locker.Lock lock = this._locker.lock();){
            this._timeoutMs = ms;
        }
    }

    public long getTimeout() {
        try (Locker.Lock lock = this._locker.lock();){
            long l = this._timeoutMs;
            return l;
        }
    }

    public AsyncContextEvent getAsyncContextEvent() {
        try (Locker.Lock lock = this._locker.lock();){
            AsyncContextEvent asyncContextEvent = this._event;
            return asyncContextEvent;
        }
    }

    public String toString() {
        try (Locker.Lock lock = this._locker.lock();){
            String string = String.format("%s@%x{s=%s a=%s i=%b r=%s/%s w=%b}", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this._state, this._async, this._initial, this._asyncRead, this._asyncReadPossible, this._asyncWritePossible});
            return string;
        }
    }

    private String getStatusStringLocked() {
        return String.format("s=%s i=%b a=%s", new Object[]{this._state, this._initial, this._async});
    }

    public String getStatusString() {
        try (Locker.Lock lock = this._locker.lock();){
            String string = this.getStatusStringLocked();
            return string;
        }
    }

    protected Action handling() {
        if (this.DEBUG) {
            LOG.debug("{} handling {}", new Object[]{this, this._state});
        }
        Throwable throwable = null;
        try (Locker.Lock lock = this._locker.lock();){
            switch (this._state) {
                case IDLE: {
                    this._initial = true;
                    this._state = State.DISPATCHED;
                    Action action = Action.DISPATCH;
                    return action;
                }
                case COMPLETING: 
                case COMPLETED: {
                    Action action = Action.TERMINATED;
                    return action;
                }
                case ASYNC_WOKEN: {
                    if (this._asyncRead.isInterested() && this._asyncReadPossible) {
                        this._state = State.ASYNC_IO;
                        this._asyncRead = Interest.NONE;
                        Action action = Action.READ_CALLBACK;
                        return action;
                    }
                    if (this._asyncWritePossible) {
                        this._state = State.ASYNC_IO;
                        this._asyncWritePossible = false;
                        Action action = Action.WRITE_CALLBACK;
                        return action;
                    }
                    switch (this._async) {
                        case COMPLETE: {
                            this._state = State.COMPLETING;
                            Action action = Action.COMPLETE;
                            return action;
                        }
                        case DISPATCH: {
                            this._state = State.DISPATCHED;
                            this._async = Async.NOT_ASYNC;
                            Action action = Action.ASYNC_DISPATCH;
                            return action;
                        }
                        case EXPIRING: {
                            break;
                        }
                        case EXPIRED: {
                            this._state = State.DISPATCHED;
                            this._async = Async.NOT_ASYNC;
                            Action action = Action.ERROR_DISPATCH;
                            return action;
                        }
                        case STARTED: {
                            Action action = Action.WAIT;
                            return action;
                        }
                        case ERRORING: {
                            this._state = State.DISPATCHED;
                            Action action = Action.ASYNC_ERROR;
                            return action;
                        }
                        case NOT_ASYNC: {
                            break;
                        }
                        default: {
                            throw new IllegalStateException(this.getStatusStringLocked());
                        }
                    }
                    Action action = Action.WAIT;
                    return action;
                }
            }
            try {
                throw new IllegalStateException(this.getStatusStringLocked());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public void startAsync(final AsyncContextEvent event) {
        List<AsyncListener> lastAsyncListeners;
        try (Locker.Lock lock = this._locker.lock();){
            if (this._state != State.DISPATCHED || this._async != Async.NOT_ASYNC) {
                throw new IllegalStateException(this.getStatusStringLocked());
            }
            this._async = Async.STARTED;
            this._event = event;
            lastAsyncListeners = this._asyncListeners;
            this._asyncListeners = null;
        }
        if (lastAsyncListeners != null) {
            Runnable callback = new Runnable(){

                @Override
                public void run() {
                    for (AsyncListener listener : lastAsyncListeners) {
                        try {
                            listener.onStartAsync((AsyncEvent)event);
                        }
                        catch (Throwable e) {
                            LOG.warn(e);
                        }
                    }
                }

                public String toString() {
                    return "startAsync";
                }
            };
            this.runInContext(event, callback);
        }
    }

    protected void error(Throwable th) {
        try (Locker.Lock lock = this._locker.lock();){
            if (this._event != null) {
                this._event.addThrowable(th);
            }
            this._async = Async.ERRORING;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void asyncError(Throwable failure) {
        event = null;
        lock = this._locker.lock();
        var4_4 = null;
        try {
            switch (4.$SwitchMap$org$eclipse$jetty$server$HttpChannelState$State[this._state.ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    ** break;
lbl8:
                    // 1 sources

                    break;
                }
                case 6: {
                    this._event.addThrowable(failure);
                    this._state = State.ASYNC_WOKEN;
                    this._async = Async.ERRORING;
                    event = this._event;
                    ** break;
lbl15:
                    // 1 sources

                    break;
                }
                default: {
                    throw new IllegalStateException(this.getStatusStringLocked());
                }
            }
        }
        catch (Throwable var5_6) {
            var4_4 = var5_6;
            throw var5_6;
        }
        finally {
            if (lock != null) {
                if (var4_4 != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable var5_5) {
                        var4_4.addSuppressed(var5_5);
                    }
                } else {
                    lock.close();
                }
            }
        }
        if (event != null) {
            this.cancelTimeout(event);
            this.runInContext(event, this._channel);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected Action unhandle() {
        read_interested = false;
        if (this.DEBUG) {
            HttpChannelState.LOG.debug("{} unhandle {}", new Object[]{this, this._state});
        }
        lock = this._locker.lock();
        var4_3 = null;
        try {
            switch (4.$SwitchMap$org$eclipse$jetty$server$HttpChannelState$State[this._state.ordinal()]) {
                case 2: 
                case 3: {
                    var5_4 = Action.TERMINATED;
                    return var5_4;
                }
                case 5: 
                case 7: {
                    break;
                }
                default: {
                    throw new IllegalStateException(this.getStatusStringLocked());
                }
            }
            this._initial = false;
            switch (4.$SwitchMap$org$eclipse$jetty$server$HttpChannelState$Async[this._async.ordinal()]) {
                case 1: {
                    this._state = State.COMPLETING;
                    this._async = Async.NOT_ASYNC;
                    action = Action.COMPLETE;
                    ** break;
lbl22:
                    // 1 sources

                    break;
                }
                case 2: {
                    this._state = State.DISPATCHED;
                    this._async = Async.NOT_ASYNC;
                    action = Action.ASYNC_DISPATCH;
                    ** break;
lbl28:
                    // 1 sources

                    break;
                }
                case 4: {
                    this._state = State.DISPATCHED;
                    this._async = Async.NOT_ASYNC;
                    action = Action.ERROR_DISPATCH;
                    ** break;
lbl34:
                    // 1 sources

                    break;
                }
                case 5: {
                    if (this._asyncRead.isInterested() && this._asyncReadPossible) {
                        this._state = State.ASYNC_IO;
                        this._asyncRead = Interest.NONE;
                        action = Action.READ_CALLBACK;
                        ** break;
lbl41:
                        // 1 sources

                    } else if (this._asyncWritePossible) {
                        this._state = State.ASYNC_IO;
                        this._asyncWritePossible = false;
                        action = Action.WRITE_CALLBACK;
                        ** break;
lbl47:
                        // 1 sources

                    } else {
                        this._state = State.ASYNC_WAIT;
                        action = Action.WAIT;
                        if (this._asyncRead == Interest.NEEDED) {
                            this._asyncRead = Interest.REGISTERED;
                            read_interested = true;
                        }
                        if ((scheduler = this._channel.getScheduler()) != null && this._timeoutMs > 0L) {
                            this._event.setTimeoutTask(scheduler.schedule((Runnable)this._event, this._timeoutMs, TimeUnit.MILLISECONDS));
                            ** break;
                        }
                    }
lbl56:
                    // 3 sources

                    break;
                }
                case 3: {
                    this._state = State.ASYNC_WAIT;
                    action = Action.WAIT;
                    ** break;
lbl61:
                    // 1 sources

                    break;
                }
                case 6: {
                    this._state = State.DISPATCHED;
                    action = Action.ASYNC_ERROR;
                    ** break;
lbl66:
                    // 1 sources

                    break;
                }
                case 8: {
                    this._state = State.DISPATCHED;
                    action = Action.ERROR_DISPATCH;
                    this._async = Async.NOT_ASYNC;
                    ** break;
lbl72:
                    // 1 sources

                    break;
                }
                case 7: {
                    this._state = State.COMPLETING;
                    action = Action.COMPLETE;
                    ** break;
lbl77:
                    // 1 sources

                    break;
                }
                default: {
                    this._state = State.COMPLETING;
                    action = Action.COMPLETE;
                    break;
                }
            }
        }
        catch (Throwable var5_7) {
            var4_3 = var5_7;
            throw var5_7;
        }
        finally {
            if (lock != null) {
                if (var4_3 != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable var6_8) {
                        var4_3.addSuppressed(var6_8);
                    }
                } else {
                    lock.close();
                }
            }
        }
        if (read_interested) {
            this._channel.asyncReadFillInterested();
        }
        return action;
    }

    /*
     * Unable to fully structure code
     */
    public void dispatch(ServletContext context, String path) {
        block23: {
            dispatch = false;
            event = null;
            lock = this._locker.lock();
            var6_6 = null;
            try {
                started = false;
                event = this._event;
                switch (4.$SwitchMap$org$eclipse$jetty$server$HttpChannelState$Async[this._async.ordinal()]) {
                    case 5: {
                        started = true;
                        break;
                    }
                    case 3: 
                    case 8: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException(this.getStatusStringLocked());
                    }
                }
                this._async = Async.DISPATCH;
                if (context != null) {
                    this._event.setDispatchContext(context);
                }
                if (path != null) {
                    this._event.setDispatchPath(path);
                }
                if (!started) break block23;
                switch (4.$SwitchMap$org$eclipse$jetty$server$HttpChannelState$State[this._state.ordinal()]) {
                    case 4: 
                    case 5: 
                    case 7: {
                        ** break;
lbl25:
                        // 1 sources

                        break;
                    }
                    case 6: {
                        this._state = State.ASYNC_WOKEN;
                        dispatch = true;
                        ** break;
lbl30:
                        // 1 sources

                        break;
                    }
                    default: {
                        HttpChannelState.LOG.warn("async dispatched when complete {}", new Object[]{this});
                        break;
                    }
                }
            }
            catch (Throwable var7_9) {
                var6_6 = var7_9;
                throw var7_9;
            }
            finally {
                if (lock != null) {
                    if (var6_6 != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable var7_8) {
                            var6_6.addSuppressed(var7_8);
                        }
                    } else {
                        lock.close();
                    }
                }
            }
        }
        this.cancelTimeout(event);
        if (dispatch) {
            this.scheduleDispatch();
        }
    }

    protected void onTimeout() {
        List<AsyncListener> listeners;
        AsyncContextEvent event;
        try (Locker.Lock lock = this._locker.lock();){
            if (this._async != Async.STARTED) {
                return;
            }
            this._async = Async.EXPIRING;
            event = this._event;
            listeners = this._asyncListeners;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Async timeout {}", new Object[]{this});
        }
        if (listeners != null) {
            Runnable callback = new Runnable(){

                @Override
                public void run() {
                    for (AsyncListener listener : listeners) {
                        try {
                            listener.onTimeout((AsyncEvent)event);
                        }
                        catch (Throwable e) {
                            LOG.debug(e);
                            event.addThrowable(e);
                            HttpChannelState.this._channel.getRequest().setAttribute("javax.servlet.error.exception", event.getThrowable());
                            break;
                        }
                    }
                }

                public String toString() {
                    return "onTimeout";
                }
            };
            this.runInContext(event, callback);
        }
        boolean dispatch = false;
        try (Locker.Lock lock = this._locker.lock();){
            switch (this._async) {
                case EXPIRING: {
                    if (event.getThrowable() == null) {
                        this._async = Async.EXPIRED;
                        this._event.addThrowable(new TimeoutException("Async API violation"));
                        break;
                    }
                    this._async = Async.ERRORING;
                    break;
                }
                case COMPLETE: 
                case DISPATCH: {
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (this._state == State.ASYNC_WAIT) {
                this._state = State.ASYNC_WOKEN;
                dispatch = true;
            }
        }
        if (dispatch) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Dispatch after async timeout {}", new Object[]{this});
            }
            this.scheduleDispatch();
        }
    }

    public void complete() {
        boolean handle = false;
        AsyncContextEvent event = null;
        try (Locker.Lock lock = this._locker.lock();){
            boolean started = false;
            event = this._event;
            switch (this._async) {
                case STARTED: {
                    started = true;
                    break;
                }
                case EXPIRING: 
                case ERRORED: {
                    break;
                }
                default: {
                    throw new IllegalStateException(this.getStatusStringLocked());
                }
            }
            this._async = Async.COMPLETE;
            if (started && this._state == State.ASYNC_WAIT) {
                handle = true;
                this._state = State.ASYNC_WOKEN;
            }
        }
        this.cancelTimeout(event);
        if (handle) {
            this.runInContext(event, this._channel);
        }
    }

    public void errorComplete() {
        try (Locker.Lock lock = this._locker.lock();){
            this._async = Async.COMPLETE;
            this._event.setDispatchContext(null);
            this._event.setDispatchPath(null);
        }
        this.cancelTimeout();
    }

    protected void onError() {
        AsyncContextEvent event;
        List<AsyncListener> aListeners;
        try (Locker.Lock lock = this._locker.lock();){
            if (this._state != State.DISPATCHED) {
                throw new IllegalStateException(this.getStatusStringLocked());
            }
            aListeners = this._asyncListeners;
            event = this._event;
            this._async = Async.ERRORED;
        }
        if (event != null && aListeners != null) {
            event.getSuppliedRequest().setAttribute("javax.servlet.error.exception", (Object)event.getThrowable());
            event.getSuppliedRequest().setAttribute("javax.servlet.error.message", (Object)event.getThrowable().getMessage());
            for (AsyncListener listener : aListeners) {
                try {
                    listener.onError((AsyncEvent)event);
                }
                catch (Throwable x) {
                    LOG.info("Exception while invoking listener " + listener, x);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void onComplete() {
        lock = this._locker.lock();
        var4_2 = null;
        try {
            switch (4.$SwitchMap$org$eclipse$jetty$server$HttpChannelState$State[this._state.ordinal()]) {
                case 2: {
                    aListeners = this._asyncListeners;
                    event = this._event;
                    this._state = State.COMPLETED;
                    this._async = Async.NOT_ASYNC;
                    ** break;
lbl11:
                    // 1 sources

                    break;
                }
                default: {
                    throw new IllegalStateException(this.getStatusStringLocked());
                }
            }
        }
        catch (Throwable var5_6) {
            var4_2 = var5_6;
            throw var5_6;
        }
        finally {
            if (lock != null) {
                if (var4_2 != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable var5_5) {
                        var4_2.addSuppressed(var5_5);
                    }
                } else {
                    lock.close();
                }
            }
        }
        if (event != null) {
            if (aListeners != null) {
                callback = new Runnable(){

                    @Override
                    public void run() {
                        for (AsyncListener listener : aListeners) {
                            try {
                                listener.onComplete((AsyncEvent)event);
                            }
                            catch (Throwable e) {
                                LOG.warn(e);
                            }
                        }
                    }

                    public String toString() {
                        return "onComplete";
                    }
                };
                this.runInContext(event, callback);
            }
            event.completed();
        }
    }

    protected void recycle() {
        this.cancelTimeout();
        try (Locker.Lock lock = this._locker.lock();){
            switch (this._state) {
                case ASYNC_IO: 
                case DISPATCHED: {
                    throw new IllegalStateException(this.getStatusStringLocked());
                }
                case UPGRADED: {
                    return;
                }
            }
            this._asyncListeners = null;
            this._state = State.IDLE;
            this._async = Async.NOT_ASYNC;
            this._initial = true;
            this._asyncReadPossible = false;
            this._asyncRead = Interest.NONE;
            this._asyncWritePossible = false;
            this._timeoutMs = DEFAULT_TIMEOUT;
            this._event = null;
        }
    }

    public void upgrade() {
        this.cancelTimeout();
        try (Locker.Lock lock = this._locker.lock();){
            switch (this._state) {
                case IDLE: 
                case COMPLETED: {
                    break;
                }
                default: {
                    throw new IllegalStateException(this.getStatusStringLocked());
                }
            }
            this._asyncListeners = null;
            this._state = State.UPGRADED;
            this._async = Async.NOT_ASYNC;
            this._initial = true;
            this._asyncReadPossible = false;
            this._asyncRead = Interest.NONE;
            this._asyncWritePossible = false;
            this._timeoutMs = DEFAULT_TIMEOUT;
            this._event = null;
        }
    }

    protected void scheduleDispatch() {
        this._channel.execute(this._channel);
    }

    protected void cancelTimeout() {
        AsyncContextEvent event;
        try (Locker.Lock lock = this._locker.lock();){
            event = this._event;
        }
        this.cancelTimeout(event);
    }

    protected void cancelTimeout(AsyncContextEvent event) {
        if (event != null) {
            event.cancelTimeoutTask();
        }
    }

    public boolean isIdle() {
        try (Locker.Lock lock = this._locker.lock();){
            boolean bl = this._state == State.IDLE;
            return bl;
        }
    }

    public boolean isExpired() {
        try (Locker.Lock lock = this._locker.lock();){
            boolean bl = this._async == Async.EXPIRED;
            return bl;
        }
    }

    public boolean isInitial() {
        try (Locker.Lock lock = this._locker.lock();){
            boolean bl = this._initial;
            return bl;
        }
    }

    public boolean isSuspended() {
        try (Locker.Lock lock = this._locker.lock();){
            boolean bl = this._state == State.ASYNC_WAIT || this._state == State.DISPATCHED && this._async == Async.STARTED;
            return bl;
        }
    }

    boolean isCompleting() {
        try (Locker.Lock lock = this._locker.lock();){
            boolean bl = this._state == State.COMPLETING;
            return bl;
        }
    }

    boolean isCompleted() {
        try (Locker.Lock lock = this._locker.lock();){
            boolean bl = this._state == State.COMPLETED;
            return bl;
        }
    }

    public boolean isAsyncStarted() {
        try (Locker.Lock lock = this._locker.lock();){
            if (this._state == State.DISPATCHED) {
                boolean bl = this._async != Async.NOT_ASYNC;
                return bl;
            }
            boolean bl = this._async == Async.STARTED || this._async == Async.EXPIRING;
            return bl;
        }
    }

    public boolean isAsync() {
        try (Locker.Lock lock = this._locker.lock();){
            boolean bl = !this._initial || this._async != Async.NOT_ASYNC;
            return bl;
        }
    }

    public Request getBaseRequest() {
        return this._channel.getRequest();
    }

    public HttpChannel getHttpChannel() {
        return this._channel;
    }

    public ContextHandler getContextHandler() {
        AsyncContextEvent event;
        try (Locker.Lock lock = this._locker.lock();){
            event = this._event;
        }
        return this.getContextHandler(event);
    }

    ContextHandler getContextHandler(AsyncContextEvent event) {
        ContextHandler.Context context;
        if (event != null && (context = (ContextHandler.Context)event.getServletContext()) != null) {
            return context.getContextHandler();
        }
        return null;
    }

    public ServletResponse getServletResponse() {
        AsyncContextEvent event;
        try (Locker.Lock lock = this._locker.lock();){
            event = this._event;
        }
        return this.getServletResponse(event);
    }

    public ServletResponse getServletResponse(AsyncContextEvent event) {
        if (event != null && event.getSuppliedResponse() != null) {
            return event.getSuppliedResponse();
        }
        return this._channel.getResponse();
    }

    void runInContext(AsyncContextEvent event, Runnable runnable) {
        ContextHandler contextHandler = this.getContextHandler(event);
        if (contextHandler == null) {
            runnable.run();
        } else {
            contextHandler.handle(this._channel.getRequest(), runnable);
        }
    }

    public Object getAttribute(String name) {
        return this._channel.getRequest().getAttribute(name);
    }

    public void removeAttribute(String name) {
        this._channel.getRequest().removeAttribute(name);
    }

    public void setAttribute(String name, Object attribute) {
        this._channel.getRequest().setAttribute(name, attribute);
    }

    public void onReadUnready() {
        boolean interested = false;
        try (Locker.Lock lock = this._locker.lock();){
            if (this._asyncRead != Interest.REGISTERED) {
                this._asyncReadPossible = false;
                if (this._state == State.ASYNC_WAIT) {
                    interested = true;
                    this._asyncRead = Interest.REGISTERED;
                } else {
                    this._asyncRead = Interest.NEEDED;
                }
            }
        }
        if (interested) {
            this._channel.asyncReadFillInterested();
        }
    }

    public boolean onReadPossible() {
        boolean woken = false;
        try (Locker.Lock lock = this._locker.lock();){
            this._asyncReadPossible = true;
            if (this._state == State.ASYNC_WAIT && this._asyncRead.isInterested()) {
                woken = true;
                this._state = State.ASYNC_WOKEN;
            }
        }
        return woken;
    }

    public boolean onReadReady() {
        boolean woken = false;
        try (Locker.Lock lock = this._locker.lock();){
            this._asyncRead = Interest.REGISTERED;
            this._asyncReadPossible = true;
            if (this._state == State.ASYNC_WAIT) {
                woken = true;
                this._state = State.ASYNC_WOKEN;
            }
        }
        return woken;
    }

    public boolean isReadPossible() {
        try (Locker.Lock lock = this._locker.lock();){
            boolean bl = this._asyncReadPossible;
            return bl;
        }
    }

    public boolean onWritePossible() {
        boolean handle = false;
        try (Locker.Lock lock = this._locker.lock();){
            this._asyncWritePossible = true;
            if (this._state == State.ASYNC_WAIT) {
                this._state = State.ASYNC_WOKEN;
                handle = true;
            }
        }
        return handle;
    }

    public static enum Interest {
        NONE(false),
        NEEDED(true),
        REGISTERED(true);

        final boolean _interested;

        boolean isInterested() {
            return this._interested;
        }

        private Interest(boolean interest) {
            this._interested = interest;
        }
    }

    public static enum Async {
        NOT_ASYNC,
        STARTED,
        DISPATCH,
        COMPLETE,
        EXPIRING,
        EXPIRED,
        ERRORING,
        ERRORED;

    }

    public static enum Action {
        DISPATCH,
        ASYNC_DISPATCH,
        ERROR_DISPATCH,
        ASYNC_ERROR,
        WRITE_CALLBACK,
        READ_CALLBACK,
        COMPLETE,
        TERMINATED,
        WAIT;

    }

    public static enum State {
        IDLE,
        DISPATCHED,
        ASYNC_WAIT,
        ASYNC_WOKEN,
        ASYNC_IO,
        COMPLETING,
        COMPLETED,
        UPGRADED;

    }
}

