/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.parser;

import java.nio.ByteBuffer;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jetty.spdy.CompressionFactory;
import org.eclipse.jetty.spdy.SessionException;
import org.eclipse.jetty.spdy.StreamException;
import org.eclipse.jetty.spdy.api.SessionStatus;
import org.eclipse.jetty.spdy.frames.ControlFrame;
import org.eclipse.jetty.spdy.frames.DataFrame;
import org.eclipse.jetty.spdy.parser.ControlFrameParser;
import org.eclipse.jetty.spdy.parser.DataFrameParser;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class Parser {
    private static final Logger logger = Log.getLogger(Parser.class);
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();
    private final ControlFrameParser controlFrameParser;
    private final DataFrameParser dataFrameParser;
    private State state = State.CONTROL_BIT;

    public Parser(CompressionFactory.Decompressor decompressor) {
        this.controlFrameParser = new ControlFrameParser(decompressor){

            @Override
            protected void onControlFrame(ControlFrame frame) {
                logger.debug("Parsed {}", new Object[]{frame});
                Parser.this.notifyControlFrame(frame);
            }
        };
        this.dataFrameParser = new DataFrameParser(){

            @Override
            protected void onDataFrame(DataFrame frame, ByteBuffer data) {
                logger.debug("Parsed {}, {} data bytes", new Object[]{frame, data.remaining()});
                Parser.this.notifyDataFrame(frame, data);
            }
        };
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    protected void notifyControlFrame(ControlFrame frame) {
        for (Listener listener : this.listeners) {
            try {
                listener.onControlFrame(frame);
            }
            catch (Exception x) {
                logger.info("Exception while notifying listener " + listener, (Throwable)x);
            }
        }
    }

    protected void notifyDataFrame(DataFrame frame, ByteBuffer data) {
        for (Listener listener : this.listeners) {
            try {
                listener.onDataFrame(frame, data);
            }
            catch (Exception x) {
                logger.info("Exception while notifying listener " + listener, (Throwable)x);
            }
        }
    }

    protected void notifyStreamException(StreamException x) {
        for (Listener listener : this.listeners) {
            try {
                listener.onStreamException(x);
            }
            catch (Exception xx) {
                logger.debug("Could not notify listener " + listener, (Throwable)xx);
            }
        }
    }

    protected void notifySessionException(SessionException x) {
        logger.debug("SPDY session exception", (Throwable)x);
        for (Listener listener : this.listeners) {
            try {
                listener.onSessionException(x);
            }
            catch (Exception xx) {
                logger.debug("Could not notify listener " + listener, (Throwable)xx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse(ByteBuffer buffer) {
        logger.debug("Parsing {} bytes", (long)buffer.remaining());
        try {
            block14: while (buffer.hasRemaining()) {
                try {
                    switch (this.state) {
                        case CONTROL_BIT: {
                            byte currByte = buffer.get(buffer.position());
                            boolean isControlFrame = (currByte & 0x80) == 128;
                            this.state = isControlFrame ? State.CONTROL_FRAME : State.DATA_FRAME;
                            continue block14;
                        }
                        case CONTROL_FRAME: {
                            if (!this.controlFrameParser.parse(buffer)) continue block14;
                            this.reset();
                            continue block14;
                        }
                        case DATA_FRAME: {
                            if (!this.dataFrameParser.parse(buffer)) continue block14;
                            this.reset();
                            continue block14;
                        }
                    }
                    throw new IllegalStateException();
                }
                catch (StreamException x) {
                    this.notifyStreamException(x);
                }
            }
            return;
        }
        catch (SessionException x) {
            this.notifySessionException(x);
            return;
        }
        catch (Throwable x) {
            this.notifySessionException(new SessionException(SessionStatus.PROTOCOL_ERROR, x));
            return;
        }
        finally {
            buffer.position(buffer.limit());
        }
    }

    private void reset() {
        this.state = State.CONTROL_BIT;
    }

    public static interface Listener
    extends EventListener {
        public void onControlFrame(ControlFrame var1);

        public void onDataFrame(DataFrame var1, ByteBuffer var2);

        public void onStreamException(StreamException var1);

        public void onSessionException(SessionException var1);

        public static class Adapter
        implements Listener {
            @Override
            public void onControlFrame(ControlFrame frame) {
            }

            @Override
            public void onDataFrame(DataFrame frame, ByteBuffer data) {
            }

            @Override
            public void onStreamException(StreamException x) {
            }

            @Override
            public void onSessionException(SessionException x) {
            }
        }
    }

    private static enum State {
        CONTROL_BIT,
        CONTROL_FRAME,
        DATA_FRAME;

    }
}

