/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jetty.spdy.Controller;
import org.eclipse.jetty.spdy.IStream;
import org.eclipse.jetty.spdy.StandardSession;
import org.eclipse.jetty.spdy.StreamException;
import org.eclipse.jetty.spdy.api.Stream;
import org.eclipse.jetty.spdy.api.StreamStatus;
import org.eclipse.jetty.util.ArrayQueue;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class Flusher {
    private static final Logger LOG = Log.getLogger(Flusher.class);
    private final IteratingCallback callback = new FlusherCallback();
    private final Object lock = new Object();
    private final ArrayQueue<StandardSession.FrameBytes> queue = new ArrayQueue(64, 32, this.lock);
    private final Controller controller;
    private final int maxGather;
    private Throwable failure;

    public Flusher(Controller controller) {
        this(controller, 8);
    }

    public Flusher(Controller controller, int maxGather) {
        this.controller = controller;
        this.maxGather = maxGather;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFrameBytesFromQueue(Stream stream) {
        Object object = this.lock;
        synchronized (object) {
            for (StandardSession.FrameBytes frameBytes : this.queue) {
                if (frameBytes.getStream() != stream) continue;
                this.queue.remove((Object)frameBytes);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Throwable prepend(StandardSession.FrameBytes frameBytes) {
        Object object = this.lock;
        synchronized (object) {
            Throwable failure = this.failure;
            if (failure == null) {
                StandardSession.FrameBytes element;
                int index;
                int size = this.queue.size();
                for (index = 0; index < size && (element = (StandardSession.FrameBytes)this.queue.getUnsafe(index)).compareTo(frameBytes) > 0; ++index) {
                }
                this.queue.add(index, (Object)frameBytes);
            }
            return failure;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Throwable append(StandardSession.FrameBytes frameBytes) {
        Object object = this.lock;
        synchronized (object) {
            Throwable failure = this.failure;
            if (failure == null) {
                this.queue.add((Object)frameBytes);
            }
            return failure;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Throwable append(StandardSession.DataFrameBytes frameBytes) {
        Object object = this.lock;
        synchronized (object) {
            Throwable failure = this.failure;
            if (failure == null) {
                StandardSession.FrameBytes element;
                int index;
                for (index = this.queue.size(); index > 0 && (element = (StandardSession.FrameBytes)this.queue.getUnsafe(index - 1)).compareTo(frameBytes) < 0; --index) {
                }
                this.queue.add(index, (Object)frameBytes);
            }
            return failure;
        }
    }

    public void flush() {
        this.callback.iterate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueueSize() {
        Object object = this.lock;
        synchronized (object) {
            return this.queue.size();
        }
    }

    private class FlusherCallback
    extends IteratingCallback {
        private final List<StandardSession.FrameBytes> active;
        private final List<StandardSession.FrameBytes> succeeded;
        private final Set<IStream> stalled;

        private FlusherCallback() {
            this.active = new ArrayList<StandardSession.FrameBytes>(Flusher.this.maxGather);
            this.succeeded = new ArrayList<StandardSession.FrameBytes>(Flusher.this.maxGather);
            this.stalled = new HashSet<IStream>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IteratingCallback.Action process() throws Exception {
            Object object = Flusher.this.lock;
            synchronized (object) {
                int index = 0;
                int size = Flusher.this.queue.size();
                while (index < size) {
                    StandardSession.FrameBytes frameBytes = (StandardSession.FrameBytes)Flusher.this.queue.getUnsafe(index);
                    IStream stream = frameBytes.getStream();
                    if (stream != null) {
                        if (this.stalled.size() > 0 && this.stalled.contains(stream)) {
                            ++index;
                            continue;
                        }
                        if (stream.getWindowSize() <= 0) {
                            this.stalled.add(stream);
                            ++index;
                            continue;
                        }
                    }
                    Flusher.this.queue.remove(index);
                    --size;
                    if (stream != null && stream.isReset() && frameBytes instanceof StandardSession.DataFrameBytes) {
                        frameBytes.failed(new StreamException(frameBytes.getStream().getId(), StreamStatus.INVALID_STREAM, "Stream: " + frameBytes.getStream() + " is reset!"));
                        continue;
                    }
                    this.active.add(frameBytes);
                }
                this.stalled.clear();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Flushing {} of {} frame(s) in queue", new Object[]{this.active.size(), Flusher.this.queue.size()});
                }
            }
            if (this.active.isEmpty()) {
                return IteratingCallback.Action.IDLE;
            }
            ByteBuffer[] buffers = new ByteBuffer[this.active.size()];
            for (int i = 0; i < buffers.length; ++i) {
                buffers[i] = this.active.get(i).getByteBuffer();
            }
            if (Flusher.this.controller != null) {
                Flusher.this.controller.write((Callback)this, buffers);
            }
            return IteratingCallback.Action.SCHEDULED;
        }

        protected void onCompleteSuccess() {
            throw new IllegalStateException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void succeeded() {
            Iterator<StandardSession.FrameBytes> iterator = Flusher.this.lock;
            synchronized (iterator) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Succeeded write of {}, q={}", new Object[]{this.active, Flusher.this.queue.size()});
                }
                this.succeeded.addAll(this.active);
                this.active.clear();
            }
            for (StandardSession.FrameBytes frame : this.succeeded) {
                frame.succeeded();
            }
            this.succeeded.clear();
            super.succeeded();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCompleteFailure(Throwable x) {
            ArrayList<StandardSession.FrameBytes> failed = new ArrayList<StandardSession.FrameBytes>();
            Iterator iterator = Flusher.this.lock;
            synchronized (iterator) {
                Flusher.this.failure = x;
                if (LOG.isDebugEnabled()) {
                    String logMessage = String.format("Failed write of %s, failing all %d frame(s) in queue", new Object[]{this, Flusher.this.queue.size()});
                    LOG.debug(logMessage, x);
                }
                failed.addAll(this.active);
                this.active.clear();
                failed.addAll((Collection<StandardSession.FrameBytes>)Flusher.this.queue);
                Flusher.this.queue.clear();
            }
            for (StandardSession.FrameBytes frame : failed) {
                frame.failed(x);
            }
        }
    }
}

